/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResultHandler.class);
    private final Collection<NamingEnumeration<SearchResult>> searchResults;

    public SearchResultHandler(Collection<NamingEnumeration<SearchResult>> searchResults) {
        this.searchResults = searchResults;
    }

    public List<String> getAllLdapNames() throws NamingException {
        final ArrayList<String> result = new ArrayList<String>();
        this.handle(new RecordProcessor(){

            @Override
            public boolean process(SearchResult record) throws NamingException {
                result.add(record.getNameInNamespace());
                return true;
            }
        });
        return result;
    }

    public boolean hasSingleResult() throws NamingException {
        List<String> allResults = this.getAllLdapNames();
        return allResults != null && allResults.size() == 1;
    }

    public String getSingleLdapName() throws NamingException {
        List<String> allLdapNames = this.getAllLdapNames();
        if (allLdapNames.size() == 1) {
            return allLdapNames.get(0);
        }
        throw new NamingException("Single result was expected");
    }

    public List<String> getAllLdapNamesAndAttributes() throws NamingException {
        final ArrayList<String> result = new ArrayList<String>();
        this.handle(new RecordProcessor(){

            @Override
            public boolean process(SearchResult record) throws NamingException {
                result.add(record.getNameInNamespace());
                NamingEnumeration<? extends Attribute> allAttributes = record.getAttributes().getAll();
                while (allAttributes.hasMore()) {
                    Attribute attribute = allAttributes.next();
                    this.addAllAttributeValuesToResult(attribute.getAll());
                }
                return true;
            }

            private void addAllAttributeValuesToResult(NamingEnumeration values) throws NamingException {
                while (values.hasMore()) {
                    result.add(String.valueOf(values.next()));
                }
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RecordProcessor processor) throws NamingException {
        try {
            for (NamingEnumeration<SearchResult> searchResult : this.searchResults) {
                while (searchResult.hasMore()) {
                    if (processor.process(searchResult.next())) continue;
                    return;
                }
            }
        }
        finally {
            for (NamingEnumeration<SearchResult> searchResult : this.searchResults) {
                try {
                    searchResult.close();
                }
                catch (NamingException ex) {
                    LOG.warn("Failed to close LDAP search result", (Throwable)ex);
                }
            }
        }
    }

    public static interface RecordProcessor {
        public boolean process(SearchResult var1) throws NamingException;
    }
}

