/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.credentials;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.CredentialsRef;
import org.apache.kyuubi.credentials.CredentialsRef$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager$;
import org.apache.kyuubi.credentials.HadoopDelegationTokenProvider;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0014)\u0001EB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0015\u0002!Ia\u0013\u0005\u0006\u0015\u0002!\ta\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019y\u0006\u0001)A\u0005%\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007BB4\u0001A\u0003%!\rC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\"I\u0001\u000f\u0001a\u0001\u0002\u0004%I!\u001d\u0005\no\u0002\u0001\r\u0011!Q!\n)D\u0011\u0002\u001f\u0001A\u0002\u0003\u0007I\u0011B=\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\b\"C?\u0001\u0001\u0004\u0005\t\u0015)\u0003d\u0011%q\b\u00011AA\u0002\u0013%\u0011\u0010\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003A!\"!\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003d\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%I!!\u0003\t\u0017\u0005m\u0001\u00011AA\u0002\u0013%\u0011Q\u0004\u0005\f\u0003C\u0001\u0001\u0019!A!B\u0013\tY\u0001\u0003\u0006\u0002$\u0001\u0001\r\u0011\"\u0001)\u0003KA!\"a\r\u0001\u0001\u0004%\t\u0001KA\u001b\u0011!\tI\u0004\u0001Q!\n\u0005\u001d\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t\t\u0006\u0001C!\u0003\u001fBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002j\u0001!\t!a\u001b\t\u0011\u0005=\u0004\u0001\"\u0001)\u0003cB\u0001\"!\u001e\u0001\t\u0003A\u0013q\u000f\u0005\t\u0003w\u0002A\u0011\u0001\u0015\u0002~!9\u0011\u0011\u0012\u0001\u0005\n\u0005-uaBAKQ!\u0005\u0011q\u0013\u0004\u0007O!B\t!!'\t\r)\u000bC\u0011AAQ\u0011%\t\u0019+\tb\u0001\n\u0013\t)\u000b\u0003\u0005\u00022\u0006\u0002\u000b\u0011BAT\u0011\u001d\t\u0019,\tC\u0001\u0003kCq!a/\"\t\u0003\tiL\u0001\rIC\u0012|w\u000e]\"sK\u0012,g\u000e^5bYNl\u0015M\\1hKJT!!\u000b\u0016\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\u0006\u0003W1\naa[=vk\nL'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ea\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0016\u0002\u000fM,'O^5dK&\u0011q\u0007\u000e\u0002\u0010\u0003\n\u001cHO]1diN+'O^5dKB\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0011\u0005y:eBA F!\t\u00015)D\u0001B\u0015\t\u0011\u0005'\u0001\u0004=e>|GO\u0010\u0006\u0002\t\u0006)1oY1mC&\u0011aiQ\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G\u0007\u00061A(\u001b8jiz\"\"\u0001\u0014(\u0011\u00055\u0003Q\"\u0001\u0015\t\u000bq\u0012\u0001\u0019A\u001f\u0015\u00031\u000bQ#^:fe\u000e\u0013X\rZ3oi&\fGn\u001d*fM6\u000b\u0007/F\u0001S!\u0011\u0019&,\u0010/\u000e\u0003QS!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017+\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002N;&\u0011a\f\u000b\u0002\u000f\u0007J,G-\u001a8uS\u0006d7OU3g\u0003Y)8/\u001a:De\u0016$WM\u001c;jC2\u001c(+\u001a4NCB\u0004\u0013AG:fgNLwN\\\"sK\u0012,g\u000e^5bYN,\u0005o\\2i\u001b\u0006\u0004X#\u00012\u0011\tMSVh\u0019\t\u0003I\u0016l\u0011aQ\u0005\u0003M\u000e\u0013A\u0001T8oO\u0006Y2/Z:tS>t7I]3eK:$\u0018.\u00197t\u000bB|7\r['ba\u0002\n\u0011\u0002\u001d:pm&$WM]:\u0016\u0003)\u0004BAP6>[&\u0011A.\u0013\u0002\u0004\u001b\u0006\u0004\bCA'o\u0013\ty\u0007FA\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s\u00035\u0001(o\u001c<jI\u0016\u00148o\u0018\u0013fcR\u0011!/\u001e\t\u0003INL!\u0001^\"\u0003\tUs\u0017\u000e\u001e\u0005\bm&\t\t\u00111\u0001k\u0003\rAH%M\u0001\u000baJ|g/\u001b3feN\u0004\u0013a\u0004:f]\u0016<\u0018\r\\%oi\u0016\u0014h/\u00197\u0016\u0003\r\f1C]3oK^\fG.\u00138uKJ4\u0018\r\\0%KF$\"A\u001d?\t\u000fYd\u0011\u0011!a\u0001G\u0006\u0001\"/\u001a8fo\u0006d\u0017J\u001c;feZ\fG\u000eI\u0001\u0011e\u0016tWm^1m%\u0016$(/_,bSR\fAC]3oK^\fGNU3uef<\u0016-\u001b;`I\u0015\fHc\u0001:\u0002\u0004!9aoDA\u0001\u0002\u0004\u0019\u0017!\u0005:f]\u0016<\u0018\r\u001c*fiJLx+Y5uA\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005G>tgMC\u0002\u0002\u00161\na\u0001[1e_>\u0004\u0018\u0002BA\r\u0003\u001f\u0011QbQ8oM&<WO]1uS>t\u0017A\u00045bI>|\u0007oQ8oM~#S-\u001d\u000b\u0004e\u0006}\u0001\u0002\u0003<\u0013\u0003\u0003\u0005\r!a\u0003\u0002\u0017!\fGm\\8q\u0007>tg\rI\u0001\u0010e\u0016tWm^1m\u000bb,7-\u001e;peV\u0011\u0011q\u0005\t\u0006I\u0006%\u0012QF\u0005\u0004\u0003W\u0019%AB(qi&|g\u000eE\u0002T\u0003_I1!!\rU\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0014e\u0016tWm^1m\u000bb,7-\u001e;pe~#S-\u001d\u000b\u0004e\u0006]\u0002\u0002\u0003<\u0016\u0003\u0003\u0005\r!a\n\u0002!I,g.Z<bY\u0016CXmY;u_J\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0019!/a\u0010\t\u000f\u0005Eq\u00031\u0001\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002H)\naaY8oM&<\u0017\u0002BA&\u0003\u000b\u0012!bS=vk\nL7i\u001c8g\u0003\u0015\u0019H/\u0019:u)\u0005\u0011\u0018\u0001B:u_B\fqc]3oI\u000e\u0013X\rZ3oi&\fGn]%g\u001d\u0016,G-\u001a3\u0015\u000fI\f9&a\u0017\u0002`!1\u0011\u0011\f\u000eA\u0002u\n\u0011b]3tg&|g.\u00133\t\r\u0005u#\u00041\u0001>\u0003\u001d\t\u0007\u000f]+tKJDq!!\u0019\u001b\u0001\u0004\t\u0019'\u0001\u0003tK:$\u0007#\u00023\u0002fu\u0012\u0018bAA4\u0007\nIa)\u001e8di&|g.M\u0001\u001ee\u0016lwN^3TKN\u001c\u0018n\u001c8De\u0016$WM\u001c;jC2\u001cX\t]8dQR\u0019!/!\u001c\t\r\u0005e3\u00041\u0001>\u0003u9W\r^(s\u0007J,\u0017\r^3Vg\u0016\u00148I]3eK:$\u0018.\u00197t%\u00164Gc\u0001/\u0002t!1\u0011Q\f\u000fA\u0002u\n!dZ3u'\u0016\u001c8/[8o\u0007J,G-\u001a8uS\u0006d7/\u00129pG\"$2aYA=\u0011\u0019\tI&\ba\u0001{\u0005\u00012m\u001c8uC&t7\u000f\u0015:pm&$WM\u001d\u000b\u0005\u0003\u007f\n)\tE\u0002e\u0003\u0003K1!a!D\u0005\u001d\u0011un\u001c7fC:Da!a\"\u001f\u0001\u0004i\u0014aC:feZL7-\u001a(b[\u0016\fqb]2iK\u0012,H.\u001a*f]\u0016<\u0018\r\u001c\u000b\u0006e\u00065\u0015\u0011\u0013\u0005\u0007\u0003\u001f{\u0002\u0019\u0001/\u0002\u000fU\u001cXM\u001d*fM\"1\u00111S\u0010A\u0002\r\fQ\u0001Z3mCf\f\u0001\u0004S1e_>\u00048I]3eK:$\u0018.\u00197t\u001b\u0006t\u0017mZ3s!\ti\u0015e\u0005\u0003\"\u00037C\u0004c\u00013\u0002\u001e&\u0019\u0011qT\"\u0003\r\u0005s\u0017PU3g)\t\t9*A\u000bqe>4\u0018\u000eZ3s\u000b:\f'\r\\3e\u0007>tg-[4\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003_k!!a+\u000b\u0007\u00055\u0006,\u0001\u0003mC:<\u0017b\u0001%\u0002,\u00061\u0002O]8wS\u0012,'/\u00128bE2,GmQ8oM&<\u0007%A\u0007m_\u0006$\u0007K]8wS\u0012,'o\u001d\u000b\u0004U\u0006]\u0006bBA]K\u0001\u0007\u0011\u0011I\u0001\u000bWf,XOY5D_:4\u0017\u0001E5t'\u0016\u0014h/[2f\u000b:\f'\r\\3e)\u0019\ty(a0\u0002B\"9\u0011\u0011\u0018\u0014A\u0002\u0005\u0005\u0003BBADM\u0001\u0007Q\b")
public class HadoopCredentialsManager
extends AbstractService {
    private final ConcurrentHashMap<String, CredentialsRef> userCredentialsRefMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> sessionCredentialsEpochMap = new ConcurrentHashMap();
    private Map<String, HadoopDelegationTokenProvider> org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers;
    private long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval;
    private long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait;
    private Configuration hadoopConf;
    private Option<ScheduledExecutorService> renewalExecutor = None$.MODULE$;

    public static boolean isServiceEnabled(KyuubiConf kyuubiConf, String string) {
        return HadoopCredentialsManager$.MODULE$.isServiceEnabled(kyuubiConf, string);
    }

    public static Map<String, HadoopDelegationTokenProvider> loadProviders(KyuubiConf kyuubiConf) {
        return HadoopCredentialsManager$.MODULE$.loadProviders(kyuubiConf);
    }

    private ConcurrentHashMap<String, CredentialsRef> userCredentialsRefMap() {
        return this.userCredentialsRefMap;
    }

    private ConcurrentHashMap<String, Object> sessionCredentialsEpochMap() {
        return this.sessionCredentialsEpochMap;
    }

    public Map<String, HadoopDelegationTokenProvider> org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers() {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers;
    }

    private void org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers_$eq(Map<String, HadoopDelegationTokenProvider> x$1) {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers = x$1;
    }

    public long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval() {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval;
    }

    private void org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval_$eq(long x$1) {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval = x$1;
    }

    public long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait() {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait;
    }

    private void org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait_$eq(long x$1) {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private void hadoopConf_$eq(Configuration x$1) {
        this.hadoopConf = x$1;
    }

    public Option<ScheduledExecutorService> renewalExecutor() {
        return this.renewalExecutor;
    }

    public void renewalExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.renewalExecutor = x$1;
    }

    public void initialize(KyuubiConf conf) {
        this.hadoopConf_$eq(KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf));
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers_$eq((Map<String, HadoopDelegationTokenProvider>)((Map)HadoopCredentialsManager$.MODULE$.loadProviders(conf).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopCredentialsManager.$anonfun$initialize$1(this, conf, x0$1)))));
        if (this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().isEmpty()) {
            this.warn((Function0 & Serializable & scala.Serializable)() -> "No delegation token is required by services.");
        } else {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Using the following builtin delegation token providers: ").append(this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().keys().mkString(", ")).append(".").toString());
        }
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.CREDENTIALS_RENEWAL_INTERVAL())));
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
        super.initialize(conf);
    }

    public void start() {
        if (this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().nonEmpty()) {
            this.renewalExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Delegation Token Renewal Thread")));
        }
        super.start();
    }

    public void stop() {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.renewalExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> {
            Object object;
            executor.shutdownNow();
            try {
                object = BoxesRunTime.boxToBoolean((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException interruptedException) {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        super.stop();
    }

    public void sendCredentialsIfNeeded(String sessionId, String appUser, Function1<String, BoxedUnit> send) {
        if (this.renewalExecutor().isEmpty()) {
            return;
        }
        CredentialsRef userRef = this.getOrCreateUserCredentialsRef(appUser);
        long sessionEpoch = this.getSessionCredentialsEpoch(sessionId);
        if (userRef.getEpoch() > sessionEpoch) {
            long currentEpoch = userRef.getEpoch();
            String currentCreds = userRef.getEncodedCredentials();
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Send new credentials with epoch ").append(currentEpoch).append(" to SQL engine through session ").append(sessionId).toString());
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> send.apply((Object)currentCreds));
            if (try_ instanceof Success) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Update session credentials epoch from ").append(sessionEpoch).append(" to ").append(currentEpoch).toString());
                this.sessionCredentialsEpochMap().put(sessionId, BoxesRunTime.boxToLong((long)currentEpoch));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Failed to send new credentials to SQL engine through session ").append(sessionId).toString(), exception);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    public void removeSessionCredentialsEpoch(String sessionId) {
        this.sessionCredentialsEpochMap().remove(sessionId);
    }

    public CredentialsRef getOrCreateUserCredentialsRef(String appUser2) {
        return this.userCredentialsRefMap().computeIfAbsent(appUser2, appUser -> {
            void var2_2;
            CredentialsRef ref = new CredentialsRef((String)appUser);
            this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(ref, 0L);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Created CredentialsRef for user ").append((String)appUser).append(" and scheduled a renewal task").toString());
            return var2_2;
        });
    }

    public long getSessionCredentialsEpoch(String sessionId) {
        return BoxesRunTime.unboxToLong((Object)this.sessionCredentialsEpochMap().getOrDefault(sessionId, BoxesRunTime.boxToLong((long)CredentialsRef$.MODULE$.UNSET_EPOCH())));
    }

    public boolean containsProvider(String serviceName) {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().contains((Object)serviceName);
    }

    public void org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(CredentialsRef userRef, long delay) {
        Runnable renewalTask = new Runnable(this, userRef){
            private final /* synthetic */ HadoopCredentialsManager $outer;
            private final CredentialsRef userRef$1;

            public void run() {
                try {
                    Credentials creds = new Credentials();
                    this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$providers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                        $anon$1.$anonfun$run$1(this, creds, x$2);
                        return BoxedUnit.UNIT;
                    });
                    this.userRef$1.updateCredentials(creds);
                    this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(this.userRef$1, this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    this.$outer.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to update tokens for ").append($this.userRef$1.getAppUser()).append(", try again in").append(" ").append($this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait()).append(" ms").toString(), e);
                    this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(this.userRef$1, this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait());
                }
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Credentials creds$1, HadoopDelegationTokenProvider x$2) {
                x$2.obtainDelegationTokens($this.userRef$1.getAppUser(), creds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.userRef$1 = userRef$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.credentials.HadoopCredentialsManager$$anon$1 org.apache.hadoop.security.Credentials org.apache.kyuubi.credentials.HadoopDelegationTokenProvider ), $anonfun$run$2(org.apache.kyuubi.credentials.HadoopCredentialsManager$$anon$1 )}, serializedLambda);
            }
        };
        this.renewalExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Scheduling renewal in ").append(delay).append(" ms.").toString());
            return executor.schedule(renewalTask, delay, TimeUnit.MILLISECONDS);
        });
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(HadoopCredentialsManager $this, KyuubiConf conf$1, Tuple2 x0$1) {
        boolean required;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            HadoopDelegationTokenProvider provider = (HadoopDelegationTokenProvider)tuple2._2();
            provider.initialize($this.hadoopConf(), conf$1);
            required = provider.delegationTokensRequired();
            if (!required) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Service ").append(provider.serviceName()).append(" does not require a token.").append(" Check your configuration to see if security is disabled or not.").toString());
                provider.close();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = required;
        return bl;
    }

    private HadoopCredentialsManager(String name) {
        super(name);
    }

    public HadoopCredentialsManager() {
        this(HadoopCredentialsManager.class.getSimpleName());
    }
}

