/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.credentials;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.CredentialsRef;
import org.apache.kyuubi.credentials.CredentialsRef$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager$;
import org.apache.kyuubi.credentials.HadoopDelegationTokenProvider;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u00180\u0001aB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006#\u0002!IA\u0015\u0005\u0006#\u0002!\tA\u0016\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u00191\u0007\u0001)A\u00053\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00028\u0001A\u0003%\u0011\u000eC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"Iq\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001f\u0005\n}\u0002\u0001\r\u0011!Q!\nED!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&!\u000eC\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0001bCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA!\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003k\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!!\u0001\t\u0017\u0005]\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0004\u0005\u000b\u0003;\u0001\u0001\u0019!A!B\u0013Q\u0007bCA\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0003CA1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u0011\u0011\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0012\u0011)\tY\u0004\u0001a\u0001\n\u0003y\u0013Q\b\u0005\u000b\u0003\u0017\u0002\u0001\u0019!C\u0001_\u00055\u0003\u0002CA)\u0001\u0001\u0006K!a\u0010\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA5\u0001\u0011\u0005\u0013q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011%\tY\tAI\u0001\n\u0003\ti\tC\u0004\u0002$\u0002!\t!!*\t\u0011\u0005%\u0006\u0001\"\u00010\u0003WC!\"!-\u0001#\u0003%\taLAG\u0011!\t\u0019\f\u0001C\u0001_\u0005U\u0006\u0002CA]\u0001\u0011\u0005q&a/\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007\"CAp\u0001E\u0005I\u0011BAG\u000f\u001d\t\to\fE\u0001\u0003G4aAL\u0018\t\u0002\u0005\u0015\bBB))\t\u0003\ti\u000fC\u0005\u0002p\"\u0012\r\u0011\"\u0003\u0002r\"A\u0011Q \u0015!\u0002\u0013\t\u0019\u0010C\u0004\u0002\u0000\"\"\tA!\u0001\t\u000f\t\u001d\u0001\u0006\"\u0001\u0003\n\tA\u0002*\u00193p_B\u001c%/\u001a3f]RL\u0017\r\\:NC:\fw-\u001a:\u000b\u0005A\n\u0014aC2sK\u0012,g\u000e^5bYNT!AM\u001a\u0002\r-LX/\u001e2j\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0005q\n\u0014aB:feZL7-Z\u0005\u0003}m\u0012q\"\u00112tiJ\f7\r^*feZL7-\u001a\t\u0003\u0001\u0006k\u0011!M\u0005\u0003\u0005F\u0012q\u0001T8hO&tw-\u0001\u0003oC6,\u0007CA#O\u001d\t1E\n\u0005\u0002H\u00156\t\u0001J\u0003\u0002Jo\u00051AH]8pizR\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u000ba\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QJS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M+\u0006C\u0001+\u0001\u001b\u0005y\u0003\"B\"\u0003\u0001\u0004!E#A*\u0002+U\u001cXM]\"sK\u0012,g\u000e^5bYN\u0014VMZ'baV\t\u0011\f\u0005\u0003[C\u0012\u001bW\"A.\u000b\u0005qk\u0016AC2p]\u000e,(O]3oi*\u0011alX\u0001\u0005kRLGNC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\t\\&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011A\u000bZ\u0005\u0003K>\u0012ab\u0011:fI\u0016tG/[1mgJ+g-\u0001\fvg\u0016\u00148I]3eK:$\u0018.\u00197t%\u00164W*\u00199!\u0003i\u0019Xm]:j_:\u001c%/\u001a3f]RL\u0017\r\\:Fa>\u001c\u0007.T1q+\u0005I\u0007\u0003\u0002.b\t*\u0004\"a\u001b7\u000e\u0003)K!!\u001c&\u0003\t1{gnZ\u0001\u001cg\u0016\u001c8/[8o\u0007J,G-\u001a8uS\u0006d7/\u00129pG\"l\u0015\r\u001d\u0011\u0002\u0013A\u0014xN^5eKJ\u001cX#A9\u0011\t\u0015\u0013H\t^\u0005\u0003gB\u00131!T1q!\t!V/\u0003\u0002w_\ti\u0002*\u00193p_B$U\r\\3hCRLwN\u001c+pW\u0016t\u0007K]8wS\u0012,'/A\u0007qe>4\u0018\u000eZ3sg~#S-\u001d\u000b\u0003sr\u0004\"a\u001b>\n\u0005mT%\u0001B+oSRDq!`\u0005\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\n!\u0002\u001d:pm&$WM]:!\u0003=\u0011XM\\3xC2Le\u000e^3sm\u0006dW#\u00016\u0002'I,g.Z<bY&sG/\u001a:wC2|F%Z9\u0015\u0007e\f9\u0001C\u0004~\u0019\u0005\u0005\t\u0019\u00016\u0002!I,g.Z<bY&sG/\u001a:wC2\u0004\u0013\u0001\u0005:f]\u0016<\u0018\r\u001c*fiJLx+Y5u\u0003Q\u0011XM\\3xC2\u0014V\r\u001e:z/\u0006LGo\u0018\u0013fcR\u0019\u00110!\u0005\t\u000fu|\u0011\u0011!a\u0001U\u0006\t\"/\u001a8fo\u0006d'+\u001a;ss^\u000b\u0017\u000e\u001e\u0011\u0002-\r\u0014X\rZ3oi&\fGn],bSR$\u0016.\\3pkR\f!d\u0019:fI\u0016tG/[1mg^\u000b\u0017\u000e\u001e+j[\u0016|W\u000f^0%KF$2!_A\u000e\u0011\u001di(#!AA\u0002)\fqc\u0019:fI\u0016tG/[1mg^\u000b\u0017\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002\u0015!\fGm\\8q\u0007>tg-\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001B2p]\u001aT1!!\f4\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011GA\u0014\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006q\u0001.\u00193p_B\u001cuN\u001c4`I\u0015\fHcA=\u00028!AQ0FA\u0001\u0002\u0004\t\u0019#A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013a\u0004:f]\u0016<\u0018\r\\#yK\u000e,Ho\u001c:\u0016\u0005\u0005}\u0002#B6\u0002B\u0005\u0015\u0013bAA\"\u0015\n1q\n\u001d;j_:\u00042AWA$\u0013\r\tIe\u0017\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017a\u0005:f]\u0016<\u0018\r\\#yK\u000e,Ho\u001c:`I\u0015\fHcA=\u0002P!AQ\u0010GA\u0001\u0002\u0004\ty$\u0001\tsK:,w/\u00197Fq\u0016\u001cW\u000f^8sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007e\f9\u0006C\u0004\u0002*i\u0001\r!!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u00182\u0003\u0019\u0019wN\u001c4jO&!\u00111MA/\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0002s\u0006!1\u000f^8q\u0003]\u0019XM\u001c3De\u0016$WM\u001c;jC2\u001c\u0018J\u001a(fK\u0012,G\rF\u0005z\u0003_\n\u0019(a\u001e\u0002\u0002\"1\u0011\u0011O\u000fA\u0002\u0011\u000b\u0011b]3tg&|g.\u00133\t\r\u0005UT\u00041\u0001E\u0003\u001d\t\u0007\u000f]+tKJDq!!\u001f\u001e\u0001\u0004\tY(\u0001\u0003tK:$\u0007#B6\u0002~\u0011K\u0018bAA@\u0015\nIa)\u001e8di&|g.\r\u0005\n\u0003\u0007k\u0002\u0013!a\u0001\u0003\u000b\u000b\u0011d^1jiVsG/\u001b7De\u0016$WM\u001c;jC2\u001c(+Z1esB\u00191.a\"\n\u0007\u0005%%JA\u0004C_>dW-\u00198\u0002CM,g\u000eZ\"sK\u0012,g\u000e^5bYNLeMT3fI\u0016$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=%\u0006BAC\u0003#[#!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;S\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011UAL\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ee\u0016lwN^3TKN\u001c\u0018n\u001c8De\u0016$WM\u001c;jC2\u001cX\t]8dQR\u0019\u00110a*\t\r\u0005Et\u00041\u0001E\u0003u9W\r^(s\u0007J,\u0017\r^3Vg\u0016\u00148I]3eK:$\u0018.\u00197t%\u00164G#B2\u0002.\u0006=\u0006BBA;A\u0001\u0007A\tC\u0005\u0002\u0004\u0002\u0002\n\u00111\u0001\u0002\u0006\u00069s-\u001a;Pe\u000e\u0013X-\u0019;f+N,'o\u0011:fI\u0016tG/[1mgJ+g\r\n3fM\u0006,H\u000e\u001e\u00133\u0003i9W\r^*fgNLwN\\\"sK\u0012,g\u000e^5bYN,\u0005o\\2i)\rQ\u0017q\u0017\u0005\u0007\u0003c\u0012\u0003\u0019\u0001#\u0002!\r|g\u000e^1j]N\u0004&o\u001c<jI\u0016\u0014H\u0003BAC\u0003{Ca!a0$\u0001\u0004!\u0015aC:feZL7-\u001a(b[\u0016\f\u0011#\u001e9eCR,7I]3eK:$\u0018.\u00197t)\rI\u0018Q\u0019\u0005\u0007\u0003\u000f$\u0003\u0019A2\u0002\u000fU\u001cXM\u001d*fM\u0006y1o\u00195fIVdWMU3oK^\fG\u000e\u0006\u0005\u0002N\u0006]\u0017\u0011\\Ao!\u0015\ty-a5z\u001b\t\t\tN\u0003\u0002]\u0015&!\u0011Q[Ai\u0005\u00191U\u000f^;sK\"1\u0011qY\u0013A\u0002\rDa!a7&\u0001\u0004Q\u0017!\u00023fY\u0006L\b\"CABKA\u0005\t\u0019AAC\u0003e\u00198\r[3ek2,'+\u001a8fo\u0006dG\u0005Z3gCVdG\u000fJ\u001a\u00021!\u000bGm\\8q\u0007J,G-\u001a8uS\u0006d7/T1oC\u001e,'\u000f\u0005\u0002UQM!\u0001&a:@!\rY\u0017\u0011^\u0005\u0004\u0003WT%AB!osJ+g\r\u0006\u0002\u0002d\u0006)\u0002O]8wS\u0012,'/\u00128bE2,GmQ8oM&<WCAAz!\u0011\t)0a?\u000e\u0005\u0005](bAA}?\u0006!A.\u00198h\u0013\ry\u0015q_\u0001\u0017aJ|g/\u001b3fe\u0016s\u0017M\u00197fI\u000e{gNZ5hA\u0005iAn\\1e!J|g/\u001b3feN$2!\u001dB\u0002\u0011\u001d\u0011)\u0001\fa\u0001\u00033\n!b[=vk\nL7i\u001c8g\u0003AI7oU3sm&\u001cW-\u00128bE2,G\r\u0006\u0004\u0002\u0006\n-!Q\u0002\u0005\b\u0005\u000bi\u0003\u0019AA-\u0011\u0019\ty,\fa\u0001\t\u0002")
public class HadoopCredentialsManager
extends AbstractService {
    private final ConcurrentHashMap<String, CredentialsRef> userCredentialsRefMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> sessionCredentialsEpochMap = new ConcurrentHashMap();
    private Map<String, HadoopDelegationTokenProvider> providers;
    private long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval;
    private long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait;
    private long credentialsWaitTimeout;
    private Configuration hadoopConf;
    private Option<ScheduledExecutorService> renewalExecutor = None$.MODULE$;

    public static boolean isServiceEnabled(KyuubiConf kyuubiConf, String string) {
        return HadoopCredentialsManager$.MODULE$.isServiceEnabled(kyuubiConf, string);
    }

    public static Map<String, HadoopDelegationTokenProvider> loadProviders(KyuubiConf kyuubiConf) {
        return HadoopCredentialsManager$.MODULE$.loadProviders(kyuubiConf);
    }

    private ConcurrentHashMap<String, CredentialsRef> userCredentialsRefMap() {
        return this.userCredentialsRefMap;
    }

    private ConcurrentHashMap<String, Object> sessionCredentialsEpochMap() {
        return this.sessionCredentialsEpochMap;
    }

    private Map<String, HadoopDelegationTokenProvider> providers() {
        return this.providers;
    }

    private void providers_$eq(Map<String, HadoopDelegationTokenProvider> x$1) {
        this.providers = x$1;
    }

    public long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval() {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval;
    }

    private void org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval_$eq(long x$1) {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval = x$1;
    }

    public long org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait() {
        return this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait;
    }

    private void org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait_$eq(long x$1) {
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait = x$1;
    }

    private long credentialsWaitTimeout() {
        return this.credentialsWaitTimeout;
    }

    private void credentialsWaitTimeout_$eq(long x$1) {
        this.credentialsWaitTimeout = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private void hadoopConf_$eq(Configuration x$1) {
        this.hadoopConf = x$1;
    }

    public Option<ScheduledExecutorService> renewalExecutor() {
        return this.renewalExecutor;
    }

    public void renewalExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.renewalExecutor = x$1;
    }

    public void initialize(KyuubiConf conf) {
        this.hadoopConf_$eq(KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf, KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        this.providers_$eq((Map<String, HadoopDelegationTokenProvider>)((Map)HadoopCredentialsManager$.MODULE$.loadProviders(conf).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopCredentialsManager.$anonfun$initialize$1(this, conf, x0$1)))));
        if (this.providers().isEmpty()) {
            this.warn((Function0 & Serializable & scala.Serializable)() -> "No delegation token is required by services.");
        } else {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Using the following builtin delegation token providers: ").append(this.providers().keys().mkString(", ")).append(".").toString());
        }
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.CREDENTIALS_RENEWAL_INTERVAL())));
        this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
        this.credentialsWaitTimeout_$eq(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.CREDENTIALS_UPDATE_WAIT_TIMEOUT())));
        super.initialize(conf);
    }

    public void start() {
        if (this.providers().nonEmpty()) {
            this.renewalExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Delegation Token Renewal Thread")));
        }
        super.start();
    }

    public void stop() {
        this.providers().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.renewalExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> {
            Object object;
            executor.shutdownNow();
            try {
                object = BoxesRunTime.boxToBoolean((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException interruptedException) {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        super.stop();
    }

    public void sendCredentialsIfNeeded(String sessionId, String appUser, Function1<String, BoxedUnit> send, boolean waitUntilCredentialsReady) {
        if (this.renewalExecutor().isEmpty()) {
            return;
        }
        CredentialsRef userRef = this.getOrCreateUserCredentialsRef(appUser, waitUntilCredentialsReady);
        long sessionEpoch = this.getSessionCredentialsEpoch(sessionId);
        if (userRef.getEpoch() > sessionEpoch) {
            long currentEpoch = userRef.getEpoch();
            String currentCreds = userRef.getEncodedCredentials();
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Send new credentials with epoch ").append(currentEpoch).append(" to SQL engine through session ").append(sessionId).toString());
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> send.apply((Object)currentCreds));
            if (try_ instanceof Success) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Update session credentials epoch from ").append(sessionEpoch).append(" to ").append(currentEpoch).toString());
                this.sessionCredentialsEpochMap().put(sessionId, BoxesRunTime.boxToLong((long)currentEpoch));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Failed to send new credentials to SQL engine through session ").append(sessionId).toString(), exception);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    public boolean sendCredentialsIfNeeded$default$4() {
        return false;
    }

    public void removeSessionCredentialsEpoch(String sessionId) {
        this.sessionCredentialsEpochMap().remove(sessionId);
    }

    /*
     * WARNING - void declaration
     */
    public CredentialsRef getOrCreateUserCredentialsRef(String appUser2, boolean waitUntilCredentialsReady) {
        void var3_3;
        block0: {
            CredentialsRef ref = this.userCredentialsRefMap().computeIfAbsent(appUser2, appUser -> {
                void var3_3;
                CredentialsRef ref = new CredentialsRef((String)appUser);
                Future<BoxedUnit> credentialsFuture = this.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(ref, 0L, waitUntilCredentialsReady);
                ref.setFuture(credentialsFuture);
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Created CredentialsRef for user ").append((String)appUser).append(" and scheduled a renewal task").toString());
                return var3_3;
            });
            if (!waitUntilCredentialsReady) break block0;
            ref.waitUntilReady((Duration)Duration$.MODULE$.apply(this.credentialsWaitTimeout(), TimeUnit.MILLISECONDS));
        }
        return var3_3;
    }

    public boolean getOrCreateUserCredentialsRef$default$2() {
        return false;
    }

    public long getSessionCredentialsEpoch(String sessionId) {
        return BoxesRunTime.unboxToLong((Object)this.sessionCredentialsEpochMap().getOrDefault(sessionId, BoxesRunTime.boxToLong((long)CredentialsRef$.MODULE$.UNSET_EPOCH())));
    }

    public boolean containsProvider(String serviceName) {
        return this.providers().contains((Object)serviceName);
    }

    public void org$apache$kyuubi$credentials$HadoopCredentialsManager$$updateCredentials(CredentialsRef userRef) {
        Credentials creds = new Credentials();
        this.providers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.obtainDelegationTokens(userRef.getAppUser(), creds);
            return BoxedUnit.UNIT;
        });
        userRef.updateCredentials(creds);
    }

    public Future<BoxedUnit> org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(CredentialsRef userRef, long delay, boolean waitUntilCredentialsReady) {
        Promise promise = Promise$.MODULE$.apply();
        Runnable renewalTask = new Runnable(this, promise, userRef, waitUntilCredentialsReady){
            private final /* synthetic */ HadoopCredentialsManager $outer;
            private final Promise promise$1;
            private final CredentialsRef userRef$2;
            private final boolean waitUntilCredentialsReady$2;

            public void run() {
                block3: {
                    try {
                        this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$updateCredentials(this.userRef$2);
                        this.promise$1.trySuccess((Object)BoxedUnit.UNIT);
                        this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(this.userRef$2, this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalInterval(), this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal$default$3());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        this.$outer.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to update tokens for ").append($this.userRef$2.getAppUser()).append(", try again in").append(" ").append($this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait()).append(" ms").toString(), e);
                        this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal(this.userRef$2, this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$renewalRetryWait(), this.$outer.org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal$default$3());
                        if (!this.waitUntilCredentialsReady$2) break block3;
                        this.promise$1.tryFailure((Throwable)e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
                this.userRef$2 = userRef$2;
                this.waitUntilCredentialsReady$2 = waitUntilCredentialsReady$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.kyuubi.credentials.HadoopCredentialsManager$$anon$1 )}, serializedLambda);
            }
        };
        this.renewalExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Scheduling renewal in ").append(delay).append(" ms.").toString());
            return executor.schedule(renewalTask, delay, TimeUnit.MILLISECONDS);
        });
        return promise.future();
    }

    public boolean org$apache$kyuubi$credentials$HadoopCredentialsManager$$scheduleRenewal$default$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(HadoopCredentialsManager $this, KyuubiConf conf$1, Tuple2 x0$1) {
        boolean required;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            HadoopDelegationTokenProvider provider = (HadoopDelegationTokenProvider)tuple2._2();
            provider.initialize($this.hadoopConf(), conf$1);
            required = provider.delegationTokensRequired();
            if (!required) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(308).append("Service ").append(provider.serviceName()).append(" does not require a token.").append(" Check your configuration to see if security is disabled or not.").append(" If security is enabled, some configurations of ").append(provider.serviceName()).append(" ").append(" might be missing, please check the configurations in ").append(" https://kyuubi.readthedocs.io/en/latest/security").append("/hadoop_credentials_manager.html#required-security-configs").toString());
                provider.close();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = required;
        return bl;
    }

    private HadoopCredentialsManager(String name) {
        super(name);
    }

    public HadoopCredentialsManager() {
        this(HadoopCredentialsManager.class.getSimpleName());
    }
}

