/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!\u0002\u0013&\u0001\u001dj\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u00191\u0006\u0001)A\u0005\u0003\"9q\u000b\u0001b\u0001\n\u0013A\u0006B\u0002/\u0001A\u0003%\u0011\fC\u0004^\u0001\t\u0007I\u0011\u00020\t\r9\u0004\u0001\u0015!\u0003`\u0011\u001dy\u0007A1A\u0005\nADa\u0001\u001f\u0001!\u0002\u0013\t\bbB=\u0001\u0005\u0004%IA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\u000f}\u0004!\u0019!C\u0005u\"9\u0011\u0011\u0001\u0001!\u0002\u0013Y\b\u0002CA\u0002\u0001\t\u0007I\u0011B+\t\u000f\u0005\u0015\u0001\u0001)A\u0005\u0003\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013\u0005q%\u0016\u0005\b\u0003+\u0001\u0001\u0015!\u0003B\u0011%\t\t\u0004\u0001b\u0001\n\u00039S\u000bC\u0004\u00024\u0001\u0001\u000b\u0011B!\t\u0013\u0005U\u0002A1A\u0005\u0002\u001d*\u0006bBA\u001c\u0001\u0001\u0006I!\u0011\u0005\u000b\u0003w\u0001\u0001R1A\u0005\u0002\u001d*\u0006bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GC\u0011\"!+\u0001#\u0003%\t!a+\b\u0015\u0005\u0005W%!A\t\u0002\u001d\n\u0019MB\u0005%K\u0005\u0005\t\u0012A\u0014\u0002F\"1Q*\tC\u0001\u0003\u000fD\u0011\"!3\"#\u0003%\t!a3\u0003\u0013\u0015sw-\u001b8f%\u00164'B\u0001\u0014(\u0003\u0019)gnZ5oK*\u0011\u0001&K\u0001\u0007Wf,XOY5\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\tq%\u0003\u00028O\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002<}5\tAH\u0003\u0002>O\u000511m\u001c8gS\u001eL!a\u0010\u001f\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\u0003vg\u0016\u0014\bC\u0001\"J\u001d\t\u0019u\t\u0005\u0002Ea5\tQI\u0003\u0002Gs\u00051AH]8pizJ!\u0001\u0013\u0019\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011B\n1\"\u001a8hS:,'+\u001a4JI\u00061A(\u001b8jiz\"BaT)S'B\u0011\u0001\u000bA\u0007\u0002K!)\u0001\b\u0002a\u0001u!)\u0001\t\u0002a\u0001\u0003\"9A\n\u0002I\u0001\u0002\u0004\t\u0015aC:feZ,'o\u00159bG\u0016,\u0012!Q\u0001\rg\u0016\u0014h/\u001a:Ta\u0006\u001cW\rI\u0001\bi&lWm\\;u+\u0005I\u0006CA\u0018[\u0013\tY\u0006G\u0001\u0003M_:<\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u0015MD\u0017M]3MKZ,G.F\u0001`!\t\u00017N\u0004\u0002bS:\u0011!\r\u001b\b\u0003G\u001et!\u0001\u001a4\u000f\u0005\u0011+\u0017\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002kK\u0005Q1\u000b[1sK2+g/\u001a7\n\u00051l'AC*iCJ,G*\u001a<fY*\u0011!.J\u0001\fg\"\f'/\u001a'fm\u0016d\u0007%\u0001\u0006f]\u001eLg.\u001a+za\u0016,\u0012!\u001d\t\u0003eVt!!Y:\n\u0005Q,\u0013AC#oO&tW\rV=qK&\u0011ao\u001e\u0002\u000b\u000b:<\u0017N\\3UsB,'B\u0001;&\u0003-)gnZ5oKRK\b/\u001a\u0011\u0002\u001bA|w\u000e\u001c+ie\u0016\u001c\bn\u001c7e+\u0005Y\bCA\u0018}\u0013\ti\bGA\u0002J]R\fa\u0002]8pYRC'/Z:i_2$\u0007%\u0001\bdY&,g\u000e\u001e)p_2\u001c\u0016N_3\u0002\u001f\rd\u0017.\u001a8u!>|GnU5{K\u0002\nab\u00197jK:$\bk\\8m\u001d\u0006lW-A\bdY&,g\u000e\u001e)p_2t\u0015-\\3!\u0003aaujQ&`)&kUiT+U?N\u0003\u0016IT0G\u0003\u000e#vJU\u000b\u0003\u0003\u0017\u00012aLA\u0007\u0013\r\ty\u0001\r\u0002\u0007\t>,(\r\\3\u000231{5iS0U\u00136+u*\u0016+`'B\u000bej\u0018$B\u0007R{%\u000bI\u0001\ngV\u0014Gm\\7bS:\f!b];cI>l\u0017-\u001b8!Q\r1\u0012\u0011\u0004\t\u0005\u00037\ti#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005\r\u0012QE\u0001\u0007G>lWn\u001c8\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007O>|w\r\\3\u000b\u0005\u0005-\u0012aA2p[&!\u0011qFA\u000f\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\bCB\u0004Xk]3s\u0003!\t\u0007\u000f]+tKJ\u0004\u0013!\u00053fM\u0006,H\u000e^#oO&tWMT1nK\u0006\u0011B-\u001a4bk2$XI\\4j]\u0016t\u0015-\\3!Q\rQ\u0012\u0011D\u0001\fK:<\u0017N\\3Ta\u0006\u001cW\rK\u0002\u001c\u00033\t1\u0002\u001e:z/&$\b\u000eT8dWV!\u00111IA&)\u0011\t)%a\u001a\u0015\t\u0005\u001d\u0013Q\f\t\u0005\u0003\u0013\nY\u0005\u0004\u0001\u0005\u000f\u00055CD1\u0001\u0002P\t\tA+\u0005\u0003\u0002R\u0005]\u0003cA\u0018\u0002T%\u0019\u0011Q\u000b\u0019\u0003\u000f9{G\u000f[5oOB\u0019q&!\u0017\n\u0007\u0005m\u0003GA\u0002B]fD\u0001\"a\u0018\u001d\t\u0003\u0007\u0011\u0011M\u0001\u0002MB)q&a\u0019\u0002H%\u0019\u0011Q\r\u0019\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u001b\u001d\u0001\u0004\tY'\u0001\u0005{W\u000ec\u0017.\u001a8u!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011B\u001a:b[\u0016<xN]6\u000b\u0007\u0005U\u0014&A\u0004dkJ\fGo\u001c:\n\t\u0005e\u0014q\u000e\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.\faa\u0019:fCR,GCBA@\u0003\u000b\u000b9\tE\u00030\u0003\u0003\u000b50C\u0002\u0002\u0004B\u0012a\u0001V;qY\u0016\u0014\u0004bBA5;\u0001\u0007\u00111\u000e\u0005\b\u0003\u0013k\u0002\u0019AAF\u00039)\u0007\u0010\u001e:b\u000b:<\u0017N\\3M_\u001e\u0004RaLAG\u0003#K1!a$1\u0005\u0019y\u0005\u000f^5p]B!\u00111SAO\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015a\u00017pO*\u0019\u00111T\u0014\u0002\u0013=\u0004XM]1uS>t\u0017\u0002BAP\u0003+\u0013Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\f1bZ3u\u001fJ\u001c%/Z1uKR1\u0011qPAS\u0003OCq!!\u001b\u001f\u0001\u0004\tY\u0007C\u0005\u0002\nz\u0001\n\u00111\u0001\u0002\f\u0006)r-\u001a;Pe\u000e\u0013X-\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAAWU\u0011\tY)a,,\u0005\u0005E\u0006\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a/1\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\u000b)LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\"\u00128hS:,'+\u001a4\u0011\u0005A\u000b3CA\u0011/)\t\t\u0019-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bT3!QAX\u0001")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String user;
    private final String engineRefId;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    @VisibleForTesting
    private final String subdomain;
    private final String appUser;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$3() {
        return EngineRef$.MODULE$.$lessinit$greater$default$3();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String appUser() {
        return this.appUser;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                String string = !(value2 != null ? !value2.equals(value3) : value3 != null) ? ZKPaths.makePath((String)commonParent, (String)this.appUser(), (String[])new String[]{this.engineRefId}) : ZKPaths.makePath((String)commonParent, (String)this.appUser(), (String[])new String[]{this.subdomain()});
                this.engineSpace = string;
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        return !this.bitmap$0 ? this.engineSpace$lzycompute() : this.engineSpace;
    }

    private <T> T tryWithLock(CuratorFramework zkClient, Function0<T> f) {
        Object object;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = f.apply();
        } else {
            Object object2;
            String lockPath = ZKPaths.makePath((String)new StringBuilder(1).append(this.serverSpace()).append("_").append(this.shareLevel()).toString(), (String)"lock", (String[])new String[]{this.appUser(), this.subdomain()});
            InterProcessSemaphoreMutex lock = null;
            try {
                try {
                    lock = new InterProcessSemaphoreMutex(zkClient, lockPath);
                    boolean acquired = lock.acquire(this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), TimeUnit.MILLISECONDS);
                    if (!acquired) {
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(this.timeout()).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                }
                catch (KyuubiSQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
                object2 = f.apply();
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            Object object3 = object2;
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception exception) {}
            object = object3;
        }
        return (T)object;
    }

    private Tuple2<String, Object> create(CuratorFramework zkClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(zkClient, (Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = ServiceDiscovery$.MODULE$.getServerHost(zkClient, this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    $this.conf.set("spark.yarn.tags", new StringBuilder(6).append((String)$this.conf.getOption("spark.yarn.tags").map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("KYUUBI").toString());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("yarn.application.name", this.defaultEngineName());
                        $this.conf.set("yarn.tags", new StringBuilder(6).append((String)$this.conf.getOption("yarn.tags").map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append((String)x$2).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("KYUUBI").toString());
                        $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE(), (Object)this.engineSpace());
                        $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_REF_ID(), (Object)$this.engineRefId);
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, extraEngineLog);
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                try (TrinoProcessBuilder builder = logging;){
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(builder).toString());
                    Process process = ((ProcBuilder)builder).start();
                    None$ exitValue = None$.MODULE$;
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS) && BoxesRunTime.unboxToInt((Object)(exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()))).get()) != 0) {
                            Throwable error = ((ProcBuilder)builder).getError();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                EngineRef.$anonfun$create$8(this, error, ms);
                                return BoxedUnit.UNIT;
                            });
                            throw error;
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            String killMessage = ((ProcBuilder)builder).killApplication(((ProcBuilder)builder).killApplication$default$1());
                            process.destroyForcibly();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                                x$4.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(40).append("Timeout(").append(this.timeout()).append(" ms) to launched ").append(this.engineType()).append(" engine with ").append(builder).append(". ").append(killMessage).toString(), ((ProcBuilder)builder).getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = ServiceDiscovery$.MODULE$.getEngineByRefId(zkClient, this.engineSpace(), $this.engineRefId);
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(CuratorFramework zkClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)ServiceDiscovery$.MODULE$.getServerHost(zkClient, this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(zkClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$create$8(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public EngineRef(KyuubiConf conf, String user, String engineRefId) {
        String string;
        String string2;
        this.conf = conf;
        this.user = user;
        this.engineRefId = engineRefId;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string2 = _subdomain = (String)some.value();
        } else if (None$.MODULE$.equals(option) && this.clientPoolSize() > 0) {
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            string2 = new StringBuilder(1).append(this.clientPoolName()).append("-").append(Random$.MODULE$.nextInt(poolSize)).toString();
        } else {
            string2 = "default";
        }
        this.subdomain = string2;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String string3;
                UserGroupInformation clientUGI = UserGroupInformation.createRemoteUser((String)user);
                Option option2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clientUGI.getGroupNames())).headOption();
                if (option2 instanceof Some) {
                    String primaryGroup;
                    Some some = (Some)option2;
                    string3 = primaryGroup = (String)some.value();
                } else if (None$.MODULE$.equals(option2)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("There is no primary group for ").append($this.user).append(", use the client user name as group directly").toString());
                    string3 = user;
                } else {
                    throw new MatchError((Object)option2);
                }
                string = string3;
            } else {
                string = user;
            }
        }
        this.appUser = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        String string4 = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
        this.defaultEngineName = string4;
    }
}

