/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.schema;

import java.io.Serializable;
import java.util.Collections;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SchemaHelper$ {
    public static SchemaHelper$ MODULE$;

    static {
        new SchemaHelper$();
    }

    public TTypeId toTTypeId(DataType typ) {
        TTypeId tTypeId;
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.NULL_TYPE;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BOOLEAN_TYPE;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.TINYINT_TYPE;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.SMALLINT_TYPE;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.INT_TYPE;
        } else if (LongType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BIGINT_TYPE;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.FLOAT_TYPE;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.DOUBLE_TYPE;
        } else if (StringType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.STRING_TYPE;
        } else if (dataType instanceof DecimalType) {
            tTypeId = TTypeId.DECIMAL_TYPE;
        } else if (DateType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.DATE_TYPE;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.TIMESTAMP_TYPE;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BINARY_TYPE;
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.STRING_TYPE;
        } else if (dataType instanceof ArrayType) {
            tTypeId = TTypeId.ARRAY_TYPE;
        } else if (dataType instanceof MapType) {
            tTypeId = TTypeId.MAP_TYPE;
        } else if (dataType instanceof StructType) {
            tTypeId = TTypeId.STRUCT_TYPE;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(dataType.catalogString()).toString());
        }
        return tTypeId;
    }

    /*
     * WARNING - void declaration
     */
    public TTypeQualifiers toTTypeQualifiers(DataType typ) {
        void var3_2;
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        DataType dataType = typ;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value((int)decimalType.precision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value((int)decimalType.scale()))}))).asJava();
        } else {
            map = Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public TTypeDesc toTTypeDesc(DataType typ) {
        void var3_3;
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry((TPrimitiveTypeEntry)typeEntry));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public TColumnDesc toTColumnDesc(StructField field, int pos) {
        void var3_3;
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.name());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.dataType()));
        tColumnDesc.setComment((String)field.getComment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        tColumnDesc.setPosition(pos);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public TTableSchema toTTableSchema(StructType schema) {
        void var2_2;
        TTableSchema tTableSchema = new TTableSchema();
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaHelper$.$anonfun$toTTableSchema$1(tTableSchema, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public int toJavaSQLType(DataType sparkType) {
        DataType dataType = sparkType;
        int n = NullType$.MODULE$.equals(dataType) ? 0 : (BooleanType$.MODULE$.equals(dataType) ? 16 : (ByteType$.MODULE$.equals(dataType) ? -6 : (ShortType$.MODULE$.equals(dataType) ? 5 : (IntegerType$.MODULE$.equals(dataType) ? 4 : (LongType$.MODULE$.equals(dataType) ? -5 : (FloatType$.MODULE$.equals(dataType) ? 6 : (DoubleType$.MODULE$.equals(dataType) ? 8 : (StringType$.MODULE$.equals(dataType) ? 12 : (dataType instanceof DecimalType ? 3 : (DateType$.MODULE$.equals(dataType) ? 91 : (TimestampType$.MODULE$.equals(dataType) ? 93 : (BinaryType$.MODULE$.equals(dataType) ? -2 : (dataType instanceof ArrayType ? 2003 : (dataType instanceof MapType ? 2000 : (dataType instanceof StructType ? 2002 : 1111)))))))))))))));
        return n;
    }

    public Option<Object> getColumnSize(DataType sparkType) {
        StructType structType;
        StructField[] fields;
        Option[] sizeArr;
        DataType dataType = sparkType;
        boolean bl = BooleanType$.MODULE$.equals(dataType) ? true : (dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (CalendarIntervalType$.MODULE$.equals(dataType) ? true : NullType$.MODULE$.equals(dataType)))));
        Object object = bl ? new Some((Object)BoxesRunTime.boxToInteger((int)dataType.defaultSize())) : (dataType instanceof StructType ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(sizeArr = (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.getColumnSize(f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)))))).contains((Object)None$.MODULE$) ? None$.MODULE$ : new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sizeArr)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SchemaHelper$.$anonfun$getColumnSize$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))) : None$.MODULE$);
        return object;
    }

    public Option<Object> getDecimalDigits(DataType sparkType) {
        Object object;
        DataType dataType = sparkType;
        boolean bl = BooleanType$.MODULE$.equals(dataType) ? true : dataType instanceof IntegerType;
        if (bl) {
            object = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)BoxesRunTime.boxToInteger((int)7));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)BoxesRunTime.boxToInteger((int)15));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)BoxesRunTime.boxToInteger((int)decimalType.scale()));
        } else {
            object = TimestampType$.MODULE$.equals(dataType) ? new Some((Object)BoxesRunTime.boxToInteger((int)6)) : None$.MODULE$;
        }
        return object;
    }

    public Option<Object> getNumPrecRadix(DataType typ) {
        DataType dataType = typ;
        Object object = dataType instanceof NumericType ? new Some((Object)BoxesRunTime.boxToInteger((int)10)) : None$.MODULE$;
        return object;
    }

    public static final /* synthetic */ void $anonfun$toTTableSchema$1(TTableSchema tTableSchema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField f = (StructField)tuple2._1();
        int i = tuple2._2$mcI$sp();
        tTableSchema$1.addToColumns(MODULE$.toTColumnDesc(f, i));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$getColumnSize$2(Option x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1.get());
    }

    private SchemaHelper$() {
        MODULE$ = this;
    }
}

