/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.zookeeper;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.PathAndBytesable;
import org.apache.kyuubi.shade.org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.kyuubi.shade.org.apache.curator.utils.ZKPaths;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ServiceDiscoveryClient$
implements Logging {
    public static ServiceDiscoveryClient$ MODULE$;
    private ScheduledExecutorService org$apache$kyuubi$ha$client$zookeeper$ServiceDiscoveryClient$$connectionChecker;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ServiceDiscoveryClient$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private ScheduledExecutorService connectionChecker$lzycompute() {
        ServiceDiscoveryClient$ serviceDiscoveryClient$ = this;
        synchronized (serviceDiscoveryClient$) {
            if (!this.bitmap$0) {
                this.org$apache$kyuubi$ha$client$zookeeper$ServiceDiscoveryClient$$connectionChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("zk-connection-checker");
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$kyuubi$ha$client$zookeeper$ServiceDiscoveryClient$$connectionChecker;
    }

    public final ScheduledExecutorService org$apache$kyuubi$ha$client$zookeeper$ServiceDiscoveryClient$$connectionChecker() {
        return !this.bitmap$0 ? this.connectionChecker$lzycompute() : this.org$apache$kyuubi$ha$client$zookeeper$ServiceDiscoveryClient$$connectionChecker;
    }

    public PersistentNode createServiceNode(KyuubiConf conf, CuratorFramework zkClient, String namespace, String instance, Option<String> version, boolean external) {
        Object object;
        String ns = ZKPaths.makePath(null, namespace);
        try {
            object = ((PathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ns);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            object = BoxedUnit.UNIT;
        }
        catch (KeeperException e) {
            throw new KyuubiException(new StringBuilder(29).append("Failed to create namespace '").append(ns).append("'").toString(), e);
        }
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String pathPrefix = ZKPaths.makePath(namespace, new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(";").append(session).append("sequence=").toString());
        ObjectRef serviceNode = ObjectRef.create(null);
        CreateMode createMode = external ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL;
        String znodeData = BoxesRunTime.unboxToBoolean((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_PUBLISH_CONFIGS())) && session.isEmpty() ? this.addConfsToPublish(conf, instance) : instance;
        try {
            serviceNode.elem = new PersistentNode(zkClient, createMode, false, pathPrefix, znodeData.getBytes(StandardCharsets.UTF_8));
            ((PersistentNode)serviceNode.elem).start();
            long znodeTimeout = BoxesRunTime.unboxToLong((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NODE_TIMEOUT()));
            if (!((PersistentNode)serviceNode.elem).waitForInitialCreate(znodeTimeout, TimeUnit.MILLISECONDS)) {
                throw new KyuubiException(new StringBuilder(41).append("Max znode creation wait time ").append(znodeTimeout).append(" s exhausted").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Created a ").append(((PersistentNode)serviceNode$1.elem).getActualPath()).append(" on ZooKeeper for KyuubiServer uri: ").append(instance).toString());
        }
        catch (Exception e) {
            if ((PersistentNode)serviceNode.elem != null) {
                ((PersistentNode)serviceNode.elem).close();
            }
            throw new KyuubiException(new StringBuilder(51).append("Unable to create a znode for this server instance: ").append(instance).toString(), e);
        }
        return (PersistentNode)serviceNode.elem;
    }

    public Option<String> createServiceNode$default$5() {
        return None$.MODULE$;
    }

    public boolean createServiceNode$default$6() {
        return false;
    }

    public String addConfsToPublish(KyuubiConf conf, String instance) {
        if (!instance.contains(":")) {
            return instance;
        }
        String[] hostPort = instance.split(":", 2);
        Map confsToPublish = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.bind.host"), (Object)hostPort[0]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.transport.mode"), (Object)"binary"));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.port"), (Object)hostPort[1]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.sasl.qop"), (Object)conf.get(KyuubiConf$.MODULE$.SASL_QOP())));
        String authenticationMethod = ((TraversableOnce)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).mkString(",");
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication"), (Object)authenticationMethod));
        Object object = authenticationMethod.equalsIgnoreCase("KERBEROS") ? confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication.kerberos.principal"), ((Option)conf.get(KyuubiConf$.MODULE$.SERVER_PRINCIPAL())).map((Function1 & Serializable & scala.Serializable)principal -> KyuubiHadoopUtils$.MODULE$.getServerPrincipal((String)principal)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))) : BoxedUnit.UNIT;
        return ((TraversableOnce)confsToPublish.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    private ServiceDiscoveryClient$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

