/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$OperationModes$;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import org.apache.kyuubi.operation.OperationType$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import scala.Enumeration;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0004\b\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0011(\u0011!)\u0004A!A!\u0002\u0013A\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000b1\u0003A\u0011A'\t\u000fI\u0003!\u0019!C\u0005'\"11\f\u0001Q\u0001\nQCq\u0001\u0018\u0001C\u0002\u0013%q\u0005\u0003\u0004^\u0001\u0001\u0006I\u0001\u000b\u0005\u0006=\u0002!\te\u0018\u0005\u0006I\u0002!\t&\u001a\u0005\u0006S\u0002!IA\u001b\u0002\u0012!2\fgn\u00148msN#\u0018\r^3nK:$(BA\b\u0011\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u0012%\u0005)a\r\\5oW*\u00111\u0003F\u0001\u0007K:<\u0017N\\3\u000b\u0005U1\u0012AB6zkV\u0014\u0017N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u00039I!a\b\b\u0003\u001d\u0019c\u0017N\\6Pa\u0016\u0014\u0018\r^5p]\u000691/Z:tS>t\u0007C\u0001\u0012%\u001b\u0005\u0019#B\u0001\u0011\u0015\u0013\t)3EA\u0004TKN\u001c\u0018n\u001c8\u0002\u0013M$\u0018\r^3nK:$X#\u0001\u0015\u0011\u0005%\u0012dB\u0001\u00161!\tYc&D\u0001-\u0015\ti#$\u0001\u0004=e>|GO\u0010\u0006\u0002_\u0005)1oY1mC&\u0011\u0011GL\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022]\u0005Q1\u000f^1uK6,g\u000e\u001e\u0011\u0002\t5|G-\u001a\t\u0003q%s!!\u000f$\u000f\u0005i\u001aeBA\u001eB\u001d\ta\u0004I\u0004\u0002>\u007f9\u00111FP\u0005\u00023%\u0011q\u0003G\u0005\u0003+YI!A\u0011\u000b\u0002\r\r|gNZ5h\u0013\t!U)\u0001\u0006LsV,(-[\"p]\u001aT!A\u0011\u000b\n\u0005\u001dC\u0015AD(qKJ\fG/[8o\u001b>$Wm\u001d\u0006\u0003\t\u0016K!AS&\u0003\u001b=\u0003XM]1uS>tWj\u001c3f\u0015\t9\u0005*\u0001\u0004=S:LGO\u0010\u000b\u0005\u001d>\u0003\u0016\u000b\u0005\u0002\u001e\u0001!)\u0001%\u0002a\u0001C!)a%\u0002a\u0001Q!)a'\u0002a\u0001o\u0005aq\u000e]3sCRLwN\u001c'pOV\tA\u000b\u0005\u0002V36\taK\u0003\u0002X1\u0006\u0019An\\4\u000b\u0005=!\u0012B\u0001.W\u00051y\u0005/\u001a:bi&|g\u000eT8h\u00035y\u0007/\u001a:bi&|g\u000eT8hA\u0005iA.\u001b8f'\u0016\u0004\u0018M]1u_J\fa\u0002\\5oKN+\u0007/\u0019:bi>\u0014\b%A\bhKR|\u0005/\u001a:bi&|g\u000eT8h+\u0005\u0001\u0007cA1c)6\ta&\u0003\u0002d]\t1q\n\u001d;j_:\f1B];o\u0013:$XM\u001d8bYR\ta\r\u0005\u0002bO&\u0011\u0001N\f\u0002\u0005+:LG/\u0001\tfqBd\u0017-\u001b8Pa\u0016\u0014\u0018\r^5p]R\u0011am\u001b\u0005\u0006M1\u0001\r\u0001\u000b")
public class PlanOnlyStatement
extends FlinkOperation {
    private final String statement;
    private final Enumeration.Value mode;
    private final OperationLog operationLog;
    private final String lineSeparator;

    @Override
    public String statement() {
        return this.statement;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public void runInternal() {
        try {
            Operation operation;
            Operation operation2 = operation = this.executor().parseStatement(this.sessionId(), this.statement());
            if (operation2 instanceof SetOperation) {
                SetOperation setOperation = (SetOperation)operation2;
                this.resultSet_$eq(ResultSetUtil$.MODULE$.runSetOperation(setOperation, this.executor(), this.sessionId()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (operation2 instanceof ResetOperation) {
                ResetOperation resetOperation = (ResetOperation)operation2;
                this.resultSet_$eq(ResultSetUtil$.MODULE$.runResetOperation(resetOperation, this.executor(), this.sessionId()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.explainOperation(this.statement());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
    }

    private void explainOperation(String statement) {
        String string;
        StreamTableEnvironment tableEnv = this.sessionContext().getExecutionContext().getTableEnvironment();
        String[] explainPlans = tableEnv.explainSql(statement, new ExplainDetail[0]).split(new StringBuilder(0).append(this.lineSeparator()).append(this.lineSeparator()).toString());
        Enumeration.Value value = this.mode;
        Enumeration.Value value2 = KyuubiConf$OperationModes$.MODULE$.PARSE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = explainPlans[0].split(new StringBuilder(26).append("== Abstract Syntax Tree ==").append(this.lineSeparator()).toString())[1];
        } else {
            Enumeration.Value value4 = KyuubiConf$OperationModes$.MODULE$.PHYSICAL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = explainPlans[1].split(new StringBuilder(29).append("== Optimized Physical Plan ==").append(this.lineSeparator()).toString())[1];
            } else {
                Enumeration.Value value6 = KyuubiConf$OperationModes$.MODULE$.EXECUTION();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    string = explainPlans[2].split(new StringBuilder(30).append("== Optimized Execution Plan ==").append(this.lineSeparator()).toString())[1];
                } else {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(56).append("The operation mode ").append(this.mode).append(" doesn't support in Flink SQL engine.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
            }
        }
        String operationPlan = string;
        this.resultSet_$eq(ResultSetUtil$.MODULE$.stringListToResultSet((List<String>)new .colon.colon((Object)operationPlan, (List)Nil$.MODULE$), "plan"));
    }

    public PlanOnlyStatement(Session session, String statement, Enumeration.Value mode) {
        this.statement = statement;
        this.mode = mode;
        super(OperationType$.MODULE$.EXECUTE_STATEMENT(), session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.lineSeparator = System.lineSeparator();
    }
}

