/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TOperationType;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.kyuubi.jdbc.hive.ClosedOrCancelledException;
import org.apache.kyuubi.jdbc.hive.HttpBasicAuthInterceptor;
import org.apache.kyuubi.jdbc.hive.HttpKerberosRequestInterceptor;
import org.apache.kyuubi.jdbc.hive.HttpRequestInterceptorBase;
import org.apache.kyuubi.jdbc.hive.HttpTokenAuthInterceptor;
import org.apache.kyuubi.jdbc.hive.KyuubiDatabaseMetaData;
import org.apache.kyuubi.jdbc.hive.KyuubiPreparedStatement;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.XsrfHttpRequestInterceptor;
import org.apache.kyuubi.jdbc.hive.ZooKeeperHiveClientException;
import org.apache.kyuubi.jdbc.hive.logs.KyuubiLoggable;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiConnection
implements Connection,
KyuubiLoggable {
    public static final Logger LOG = LoggerFactory.getLogger((String)KyuubiConnection.class.getName());
    public static final String BEELINE_MODE_PROPERTY = "BEELINE_MODE";
    public static int DEFAULT_ENGINE_LOG_THREAD_TIMEOUT = 10000;
    private String jdbcUriString;
    private String host;
    private int port;
    private final Map<String, String> sessConfMap;
    private Utils.JdbcConnectionParams connParams;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private boolean assumeSubject;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int loginTimeout = 0;
    private TProtocolVersion protocol;
    private int fetchSize = 1000;
    private String initFile = null;
    private boolean initFileCompleted = false;
    private TOperationHandle launchEngineOpHandle = null;
    private Thread engineLogThread;
    private boolean engineLogInflight = true;
    private volatile boolean launchEngineOpCompleted = false;
    private boolean isBeeLineMode;

    public KyuubiConnection(String uri, Properties info) throws SQLException {
        this.setupLoginTimeout();
        try {
            this.connParams = Utils.parseURL(uri, info);
        }
        catch (ZooKeeperHiveClientException e) {
            throw new SQLException(e);
        }
        this.isBeeLineMode = Boolean.parseBoolean(info.getProperty(BEELINE_MODE_PROPERTY));
        this.jdbcUriString = this.connParams.getJdbcUriString();
        this.host = this.connParams.getHost();
        this.port = this.connParams.getPort();
        this.sessConfMap = this.connParams.getSessionVars();
        this.isEmbeddedMode = this.connParams.isEmbeddedMode();
        if (this.sessConfMap.containsKey("fetchSize")) {
            this.fetchSize = Integer.parseInt(this.sessConfMap.get("fetchSize"));
        }
        if (this.sessConfMap.containsKey("initFile")) {
            this.initFile = this.sessConfMap.get("initFile");
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V2);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V4);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V5);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V7);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V10);
        if (this.isEmbeddedMode) {
            EmbeddedThriftBinaryCLIService embeddedClient = new EmbeddedThriftBinaryCLIService();
            embeddedClient.init(null);
            EmbeddedThriftBinaryCLIService _client = embeddedClient;
            this.client = KyuubiConnection.newSynchronizedClient((TCLIService.Iface)_client);
            this.openSession();
            this.showLaunchEngineLog();
            this.waitLaunchEngineToComplete();
            this.executeInitSql();
        } else {
            int maxRetries = 1;
            try {
                String strRetries = this.sessConfMap.get("retries");
                if (StringUtils.isNotBlank((String)strRetries)) {
                    maxRetries = Integer.parseInt(strRetries);
                }
            }
            catch (NumberFormatException strRetries) {
                // empty catch block
            }
            int numRetries = 0;
            while (true) {
                try {
                    this.openTransport();
                    TCLIService.Client _client = new TCLIService.Client((TProtocol)new TBinaryProtocol(this.transport));
                    this.client = KyuubiConnection.newSynchronizedClient((TCLIService.Iface)_client);
                    this.openSession();
                    if (this.isBeeLineMode) break;
                    this.showLaunchEngineLog();
                    this.waitLaunchEngineToComplete();
                    this.executeInitSql();
                }
                catch (Exception e) {
                    LOG.warn("Failed to connect to " + this.connParams.getHost() + ":" + this.connParams.getPort());
                    String errMsg = null;
                    String warnMsg = "Could not open client transport with JDBC Uri: " + this.jdbcUriString + ": ";
                    if (this.isZkDynamicDiscoveryMode()) {
                        errMsg = "Could not open client transport for any of the Server URI's in ZooKeeper: ";
                        while (!Utils.updateConnParamsFromZooKeeper(this.connParams) && ++numRetries < maxRetries) {
                            this.connParams.getRejectedHostZnodePaths().clear();
                        }
                        this.jdbcUriString = this.connParams.getJdbcUriString();
                        this.host = this.connParams.getHost();
                        this.port = this.connParams.getPort();
                    } else {
                        errMsg = warnMsg;
                        ++numRetries;
                    }
                    if (numRetries >= maxRetries) {
                        throw new SQLException(errMsg + e.getMessage(), " 08S01", e);
                    }
                    LOG.warn(warnMsg + e.getMessage() + " Retrying " + numRetries + " of " + maxRetries);
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public boolean hasMoreLogs() {
        return this.launchEngineOpHandle != null && (this.engineLogInflight || !this.launchEngineOpCompleted);
    }

    @Override
    public List<String> getExecLog() throws SQLException, ClosedOrCancelledException {
        if (this.isClosed()) {
            throw new ClosedOrCancelledException("Method getExecLog() failed. The connection has been closed.");
        }
        if (this.launchEngineOpHandle == null) {
            return Collections.emptyList();
        }
        TFetchResultsReq fetchResultsReq = new TFetchResultsReq(this.launchEngineOpHandle, TFetchOrientation.FETCH_NEXT, (long)this.fetchSize);
        fetchResultsReq.setFetchType((short)1);
        ArrayList<String> logs = new ArrayList<String>();
        try {
            TFetchResultsResp tFetchResultsResp = this.client.FetchResults(fetchResultsReq);
            RowSet rowSet = RowSetFactory.create((TRowSet)tFetchResultsResp.getResults(), (TProtocolVersion)this.getProtocol());
            for (Object[] row : rowSet) {
                logs.add(String.valueOf(row[0]));
            }
        }
        catch (TException e) {
            throw new SQLException("Error building result set for query log", e);
        }
        this.engineLogInflight = !logs.isEmpty();
        return Collections.unmodifiableList(logs);
    }

    private void showLaunchEngineLog() {
        if (this.launchEngineOpHandle != null) {
            LOG.info("Starting to get launch engine log.");
            this.engineLogThread = new Thread("engine-launch-log"){

                @Override
                public void run() {
                    try {
                        while (KyuubiConnection.this.hasMoreLogs()) {
                            List<String> logs = KyuubiConnection.this.getExecLog();
                            for (String log : logs) {
                                LOG.info(log);
                            }
                            Thread.sleep(300L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LOG.info("Finished to get launch engine log.");
                }
            };
            this.engineLogThread.start();
        }
    }

    public void setEngineLogThread(Thread logThread) {
        this.engineLogThread = logThread;
    }

    public void executeInitSql() throws SQLException {
        if (this.initFileCompleted) {
            return;
        }
        if (this.initFile != null) {
            try {
                List<String> sqlList = KyuubiConnection.parseInitFile(this.initFile);
                Statement st = this.createStatement();
                for (String sql : sqlList) {
                    boolean hasResult = st.execute(sql);
                    if (!hasResult) continue;
                    ResultSet rs = st.getResultSet();
                    while (rs.next()) {
                        System.out.println(rs.getString(1));
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute initial SQL");
                throw new SQLException(e.getMessage());
            }
        }
        this.initFileCompleted = true;
    }

    public static List<String> parseInitFile(String initFile) throws IOException {
        File file = new File(initFile);
        List<String> initSqlList = null;
        try (BufferedReader br = null;){
            String line;
            FileInputStream input = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)input, "UTF-8"));
            StringBuilder sb = new StringBuilder("");
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("--")) continue;
                line = line.concat(" ");
                sb.append(line);
            }
            initSqlList = KyuubiConnection.getInitSql(sb.toString());
        }
        return initSqlList;
    }

    private static List<String> getInitSql(String sbLine) {
        char[] sqlArray = sbLine.toCharArray();
        ArrayList<String> initSqlList = new ArrayList<String>();
        int beginIndex = 0;
        for (int index = 0; index < sqlArray.length; ++index) {
            if (sqlArray[index] != ';') continue;
            String sql = sbLine.substring(beginIndex, index).trim();
            initSqlList.add(sql);
            beginIndex = index + 1;
        }
        return initSqlList;
    }

    private void openTransport() throws Exception {
        this.assumeSubject = "fromSubject".equals(this.sessConfMap.get("kerberosAuthType"));
        TTransport tTransport = this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
        if (!this.transport.isOpen()) {
            this.transport.open();
            this.logZkDiscoveryMessage("Connected to " + this.connParams.getHost() + ":" + this.connParams.getPort());
        }
    }

    public String getConnectedUrl() {
        return this.jdbcUriString;
    }

    private String getServerHttpUrl(boolean useSsl) {
        String schemeName = useSsl ? "https" : "http";
        String httpPath = this.sessConfMap.get("httpPath");
        if (httpPath == null) {
            httpPath = "/";
        } else if (!httpPath.startsWith("/")) {
            httpPath = "/" + httpPath;
        }
        return schemeName + "://" + this.host + ":" + this.port + httpPath;
    }

    private TTransport createHttpTransport() throws SQLException, TTransportException {
        boolean useSsl = this.isSslConnection();
        CloseableHttpClient httpClient = this.getHttpClient(useSsl);
        this.transport = new THttpClient(this.getServerHttpUrl(useSsl), (HttpClient)httpClient);
        return this.transport;
    }

    private CloseableHttpClient getHttpClient(Boolean useSsl) throws SQLException {
        String tokenStr;
        boolean isCookieEnabled = this.sessConfMap.get("cookieAuth") == null || !"false".equalsIgnoreCase(this.sessConfMap.get("cookieAuth"));
        String cookieName = this.sessConfMap.get("cookieName") == null ? "hive.server2.auth" : this.sessConfMap.get("cookieName");
        BasicCookieStore cookieStore = isCookieEnabled ? new BasicCookieStore() : null;
        HashMap<String, String> additionalHttpHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.sessConfMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("http.header.")) continue;
            additionalHttpHeaders.put(key.substring("http.header.".length()), entry.getValue());
        }
        HttpRequestInterceptorBase requestInterceptor = this.isKerberosAuthMode() ? new HttpKerberosRequestInterceptor(this.sessConfMap.get("principal"), this.host, this.getServerHttpUrl(useSsl), this.assumeSubject, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders) : ((tokenStr = this.getClientDelegationToken(this.sessConfMap)) != null ? new HttpTokenAuthInterceptor(tokenStr, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders) : new HttpBasicAuthInterceptor(this.getUserName(), this.getPassword(), (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders));
        HttpClientBuilder httpClientBuilder = isCookieEnabled ? HttpClients.custom().setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean ret;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl = ret = statusCode == 401 && executionCount <= 1;
                if (ret) {
                    context.setAttribute("hive.server2.retryserver", (Object)"true");
                }
                return ret;
            }

            public long getRetryInterval() {
                return 0L;
            }
        }) : HttpClientBuilder.create();
        httpClientBuilder.setRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > 1) {
                    LOG.info("Retry attempts to connect to server exceeded.");
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    LOG.info("Could not connect to the server. Retrying one more time.");
                    return true;
                }
                return false;
            }
        });
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)requestInterceptor);
        httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new XsrfHttpRequestInterceptor());
        if (useSsl.booleanValue()) {
            String useTwoWaySSL = this.sessConfMap.get("twoWay");
            String sslTrustStorePath = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            try {
                SSLConnectionSocketFactory socketFactory;
                if (useTwoWaySSL != null && useTwoWaySSL.equalsIgnoreCase("true")) {
                    socketFactory = this.getTwoWaySSLSocketFactory();
                } else if (sslTrustStorePath == null || sslTrustStorePath.isEmpty()) {
                    socketFactory = SSLConnectionSocketFactory.getSocketFactory();
                } else {
                    KeyStore sslTrustStore = KeyStore.getInstance("JKS");
                    try (FileInputStream fis = new FileInputStream(sslTrustStorePath);){
                        sslTrustStore.load(fis, sslTrustStorePassword.toCharArray());
                    }
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(sslTrustStore, null).build();
                    socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier(null));
                }
                Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
            }
            catch (Exception e) {
                String msg = "Could not create an https connection to " + this.jdbcUriString + ". " + e.getMessage();
                throw new SQLException(msg, " 08S01", e);
            }
        }
        return httpClientBuilder.build();
    }

    private TTransport createUnderlyingTransport() throws TTransportException {
        TTransport transport = null;
        if (this.isSslConnection()) {
            String sslTrustStore = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            transport = sslTrustStore == null || sslTrustStore.isEmpty() ? HiveAuthUtils.getSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout) : HiveAuthUtils.getSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout, (String)sslTrustStore, (String)sslTrustStorePassword);
        } else {
            transport = HiveAuthUtils.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout);
        }
        return transport;
    }

    private TTransport createBinaryTransport() throws SQLException, TTransportException {
        block11: {
            try {
                TTransport socketTransport = this.createUnderlyingTransport();
                if (!"noSasl".equals(this.sessConfMap.get("auth"))) {
                    HashMap<String, String> saslProps = new HashMap<String, String>();
                    SaslQOP saslQOP = SaslQOP.AUTH;
                    if (this.sessConfMap.containsKey("saslQop")) {
                        try {
                            saslQOP = SaslQOP.fromString((String)this.sessConfMap.get("saslQop"));
                        }
                        catch (IllegalArgumentException e) {
                            throw new SQLException("Invalid saslQop parameter. " + e.getMessage(), "42000", e);
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                    } else {
                        saslProps.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
                    }
                    saslProps.put("javax.security.sasl.server.authentication", "true");
                    if (this.sessConfMap.containsKey("principal")) {
                        this.transport = KerberosSaslHelper.getKerberosTransport((String)this.sessConfMap.get("principal"), (String)this.host, (TTransport)socketTransport, saslProps, (boolean)this.assumeSubject);
                    } else {
                        String tokenStr = this.getClientDelegationToken(this.sessConfMap);
                        if (tokenStr != null) {
                            this.transport = KerberosSaslHelper.getTokenTransport((String)tokenStr, (String)this.host, (TTransport)socketTransport, saslProps);
                        } else {
                            String userName = this.getUserName();
                            String passwd = this.getPassword();
                            this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)socketTransport);
                        }
                    }
                    break block11;
                }
                this.transport = socketTransport;
            }
            catch (SaslException e) {
                throw new SQLException("Could not create secure connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
            }
        }
        return this.transport;
    }

    SSLConnectionSocketFactory getTwoWaySSLSocketFactory() throws SQLException {
        SSLConnectionSocketFactory socketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            String keyStorePath = this.sessConfMap.get("sslKeyStore");
            String keyStorePassword = this.sessConfMap.get("keyStorePassword");
            KeyStore sslKeyStore = KeyStore.getInstance("JKS");
            if (keyStorePath == null || keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslKeyStore Not configured for 2 way SSL connection, keyStorePath param is empty");
            }
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                sslKeyStore.load(fis, keyStorePassword.toCharArray());
            }
            keyManagerFactory.init(sslKeyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            String trustStorePath = this.sessConfMap.get("sslTrustStore");
            String trustStorePassword = this.sessConfMap.get("trustStorePassword");
            KeyStore sslTrustStore = KeyStore.getInstance("JKS");
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslTrustStore Not configured for 2 way SSL connection");
            }
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                sslTrustStore.load(fis, trustStorePassword.toCharArray());
            }
            trustManagerFactory.init(sslTrustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            socketFactory = new SSLConnectionSocketFactory(context);
        }
        catch (Exception e) {
            throw new SQLException("Error while initializing 2 way ssl socket factory ", e);
        }
        return socketFactory;
    }

    private String getClientDelegationToken(Map<String, String> jdbcConnConf) throws SQLException {
        String tokenStr = null;
        if ("delegationToken".equalsIgnoreCase(jdbcConnConf.get("auth"))) {
            try {
                tokenStr = org.apache.hadoop.hive.shims.Utils.getTokenStrForm((String)"hiveserver2ClientToken");
            }
            catch (IOException e) {
                throw new SQLException("Error reading token ", e);
            }
        }
        return tokenStr;
    }

    private void openSession() throws SQLException {
        TOpenSessionReq openReq = new TOpenSessionReq();
        HashMap<String, String> openConf = new HashMap<String, String>();
        for (Map.Entry<String, String> hiveConf : this.connParams.getHiveConfs().entrySet()) {
            openConf.put("set:hiveconf:" + hiveConf.getKey(), hiveConf.getValue());
        }
        for (Map.Entry<String, String> hiveVar : this.connParams.getHiveVars().entrySet()) {
            openConf.put("set:hivevar:" + hiveVar.getKey(), hiveVar.getValue());
        }
        openConf.put("use:database", this.connParams.getDbName());
        openConf.put("set:hiveconf:hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.fetchSize));
        Map<String, String> sessVars = this.connParams.getSessionVars();
        if (sessVars.containsKey("hive.server2.proxy.user")) {
            openConf.put("hive.server2.proxy.user", sessVars.get("hive.server2.proxy.user"));
        }
        openReq.setConfiguration(openConf);
        if ("noSasl".equals(this.sessConfMap.get("auth"))) {
            openReq.setUsername(this.sessConfMap.get("user"));
            openReq.setPassword(this.sessConfMap.get("password"));
        }
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.protocol = openResp.getServerProtocolVersion();
            this.sessHandle = openResp.getSessionHandle();
            Map openRespConf = openResp.getConfiguration();
            String serverFetchSize = (String)openRespConf.get("hive.server2.thrift.resultset.default.fetch.size");
            if (serverFetchSize != null) {
                this.fetchSize = Integer.parseInt(serverFetchSize);
            }
            String launchEngineOpHandleGuid = (String)openRespConf.get("kyuubi.session.engine.launch.handle.guid");
            String launchEngineOpHandleSecret = (String)openRespConf.get("kyuubi.session.engine.launch.handle.secret");
            if (launchEngineOpHandleGuid != null && launchEngineOpHandleSecret != null) {
                try {
                    byte[] guidBytes = Base64.getMimeDecoder().decode(launchEngineOpHandleGuid);
                    byte[] secretBytes = Base64.getMimeDecoder().decode(launchEngineOpHandleSecret);
                    THandleIdentifier handleIdentifier = new THandleIdentifier(ByteBuffer.wrap(guidBytes), ByteBuffer.wrap(secretBytes));
                    this.launchEngineOpHandle = new TOperationHandle(handleIdentifier, TOperationType.UNKNOWN, false);
                }
                catch (Exception e) {
                    LOG.error("Failed to decode launch engine operation handle from open session resp", (Throwable)e);
                }
            }
        }
        catch (TException e) {
            LOG.error("Error opening session", (Throwable)e);
            throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
        }
        this.isClosed = false;
    }

    private String getUserName() {
        return this.getSessionValue("user", "anonymous");
    }

    private String getPassword() {
        return this.getSessionValue("password", "anonymous");
    }

    private boolean isSslConnection() {
        return "true".equalsIgnoreCase(this.sessConfMap.get("ssl"));
    }

    private boolean isKerberosAuthMode() {
        return !"noSasl".equals(this.sessConfMap.get("auth")) && this.sessConfMap.containsKey("principal");
    }

    private boolean isHttpTransportMode() {
        String transportMode = this.sessConfMap.get("transportMode");
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    private boolean isZkDynamicDiscoveryMode() {
        return this.sessConfMap.get("serviceDiscoveryMode") != null && "zooKeeper".equalsIgnoreCase(this.sessConfMap.get("serviceDiscoveryMode"));
    }

    private void logZkDiscoveryMessage(String message) {
        if (this.isZkDynamicDiscoveryMode()) {
            LOG.info(message);
        }
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupLoginTimeout() {
        long timeOut = TimeUnit.SECONDS.toMillis(DriverManager.getLoginTimeout());
        this.loginTimeout = timeOut > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeOut;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new SQLException("Could not retrieve token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not cancel token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not renew token: " + e.getMessage(), " 08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    private void closeOnLaunchEngineFailure() throws SQLException {
        if (this.engineLogThread != null && this.engineLogThread.isAlive()) {
            this.engineLogThread.interrupt();
            try {
                this.engineLogThread.join(DEFAULT_ENGINE_LOG_THREAD_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.engineLogThread = null;
        this.close();
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new KyuubiStatement(this, this.client, this.sessHandle, this.fetchSize);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported", "HYC00");
        }
        if (resultSetType == 1005) {
            throw new SQLException("Statement with resultset type " + resultSetType + " is not supported", "HYC00");
        }
        return new KyuubiStatement(this, this.client, this.sessHandle, resultSetType == 1004, this.fetchSize);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new KyuubiDatabaseMetaData(this, this.client, this.sessHandle);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getSchema() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout value was negative");
        }
        boolean rc = false;
        try {
            String productName = new KyuubiDatabaseMetaData(this, this.client, this.sessHandle).getDatabaseProductName();
            rc = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new KyuubiPreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (!autoCommit) {
            LOG.warn("Request to set autoCommit to false; Hive does not support autoCommit=false.");
            SQLWarning warning = new SQLWarning("Hive does not support autoCommit=false");
            if (this.warningChain == null) {
                this.warningChain = warning;
            } else {
                this.warningChain.setNextWarning(warning);
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (readOnly) {
            throw new SQLException("Enabling read-only mode not supported");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Schema name is null or empty");
        }
        Statement stmt = this.createStatement();
        stmt.execute("use " + schema);
        stmt.close();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public TProtocolVersion getProtocol() {
        return this.protocol;
    }

    public static TCLIService.Iface newSynchronizedClient(TCLIService.Iface client) {
        return (TCLIService.Iface)Proxy.newProxyInstance(KyuubiConnection.class.getClassLoader(), new Class[]{TCLIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public void waitLaunchEngineToComplete() throws SQLException {
        if (this.launchEngineOpHandle == null) {
            return;
        }
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.launchEngineOpHandle);
        TGetOperationStatusResp statusResp = null;
        while (!this.launchEngineOpCompleted) {
            try {
                try {
                    statusResp = this.client.GetOperationStatus(statusReq);
                }
                catch (Exception e) {
                    LOG.debug("Failed to get launch engine operation status, assume it has completed", (Throwable)e);
                    this.launchEngineOpCompleted = true;
                    break;
                }
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case CLOSED_STATE: 
                    case FINISHED_STATE: {
                        this.launchEngineOpCompleted = true;
                        this.engineLogInflight = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        throw new SQLException("Launch engine was cancelled", "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Launch engine timeout");
                    }
                    case ERROR_STATE: {
                        throw new SQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new SQLException("Unknown state", "HY000");
                    }
                }
            }
            catch (Exception e) {
                this.engineLogInflight = false;
                this.closeOnLaunchEngineFailure();
                if (e instanceof SQLException) {
                    throw e;
                }
                throw new SQLException(e.getMessage(), "08S01", e);
            }
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TCLIService.Iface client;
        private final ReentrantLock lock = new ReentrantLock(true);

        SynchronizedHandler(TCLIService.Iface client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                this.lock.lock();
                Object object = method.invoke((Object)this.client, args);
                return object;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw (TException)e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

