/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.LoggerNameModel;

public class LoggerNameModelSupport
implements LoggerNameModel {
    private Set loggerNameSet = new HashSet();
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public Collection getLoggerNames() {
        return Collections.unmodifiableSet(this.loggerNameSet);
    }

    @Override
    public boolean addLoggerName(String loggerName) {
        boolean isNew = this.loggerNameSet.add(loggerName);
        if (isNew) {
            this.notifyListeners(loggerName);
        }
        return isNew;
    }

    @Override
    public void reset() {
        this.loggerNameSet.clear();
        LoggerNameListener[] eventListeners = (LoggerNameListener[])this.listenerList.getListeners(LoggerNameListener.class);
        for (int i = 0; i < eventListeners.length; ++i) {
            LoggerNameListener listener = eventListeners[i];
            listener.reset();
        }
    }

    private void notifyListeners(String loggerName) {
        LoggerNameListener[] eventListeners = (LoggerNameListener[])this.listenerList.getListeners(LoggerNameListener.class);
        for (int i = 0; i < eventListeners.length; ++i) {
            LoggerNameListener listener = eventListeners[i];
            listener.loggerNameAdded(loggerName);
        }
    }

    @Override
    public void addLoggerNameListener(LoggerNameListener l) {
        this.listenerList.add(LoggerNameListener.class, l);
    }

    @Override
    public void removeLoggerNameListener(LoggerNameListener l) {
        this.listenerList.remove(LoggerNameListener.class, l);
    }
}

