/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.osx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.LogUI;

public class OSXIntegration {
    public static final boolean IS_OSX = System.getProperty("os.name").startsWith("Mac OS X");
    private static final Logger LOG = Logger.getLogger(OSXIntegration.class);
    private static Object applicationInstance;

    public static final void init(final LogUI logui) {
        LOG.info("OSXIntegration.init() called");
        if (!IS_OSX) {
            LOG.info("Not OSX, ignoring...");
            return;
        }
        try {
            Class<?> applicationClazz = Class.forName("com.apple.eawt.Application");
            Class<?> listenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            applicationInstance = applicationClazz.newInstance();
            Method enablePreferenceMethod = applicationClazz.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            enablePreferenceMethod.invoke(applicationInstance, Boolean.TRUE);
            Method enableAboutMethod = applicationClazz.getMethod("setEnabledAboutMenu", Boolean.TYPE);
            enableAboutMethod.invoke(applicationInstance, Boolean.TRUE);
            Object listenerProxy = Proxy.newProxyInstance(OSXIntegration.class.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("handlePreferences".equals(method.getName())) {
                        LOG.info("handlePreferences(...) called");
                        logui.showApplicationPreferences();
                    } else if ("handleQuit".equals(method.getName())) {
                        this.setHandled(args[0], logui.exit() ? Boolean.TRUE : Boolean.FALSE);
                    } else if ("handleAbout".equals(method.getName())) {
                        logui.showAboutBox();
                        this.setHandled(args[0], Boolean.TRUE);
                    }
                    return null;
                }

                private void setHandled(Object event, Boolean val) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                    Method handleMethod = event.getClass().getMethod("setHandled", Boolean.TYPE);
                    handleMethod.invoke(event, val);
                }
            });
            Method registerListenerMethod = applicationClazz.getMethod("addApplicationListener", listenerClass);
            registerListenerMethod.invoke(applicationInstance, listenerProxy);
        }
        catch (Exception e) {
            LOG.error("Failed to setup OSXIntegration", e);
        }
    }
}

