/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLDecoder
implements Decoder {
    private static final String ENCODING = "UTF-8";
    private static final String BEGINPART = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE log4j:eventSet SYSTEM \"http://localhost/log4j.dtd\"><log4j:eventSet version=\"1.2\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">";
    private static final String ENDPART = "</log4j:eventSet>";
    private static final String RECORD_END = "</log4j:event>";
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private Component owner = null;

    public XMLDecoder(Component o) {
        this();
        this.owner = o;
    }

    public XMLDecoder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler((ErrorHandler)new SAXErrorHandler());
            this.docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Unable to get document builder");
        }
    }

    @Override
    public void setAdditionalProperties(Map properties) {
        this.additionalProperties = properties;
    }

    private Document parse(String data) {
        if (this.docBuilder == null || data == null) {
            return null;
        }
        Document document = null;
        try {
            String buf = BEGINPART + data + ENDPART;
            InputSource inputSource = new InputSource(new StringReader(buf));
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<LoggingEvent> decode(URL url) throws IOException {
        InputStream inputStream;
        boolean isZipFile = url.getPath().toLowerCase().endsWith(".zip");
        if (isZipFile) {
            inputStream = new ZipInputStream(url.openStream());
            ((ZipInputStream)inputStream).getNextEntry();
        } else {
            inputStream = url.openStream();
        }
        LineNumberReader reader = this.owner != null ? new LineNumberReader(new InputStreamReader((InputStream)new ProgressMonitorInputStream(this.owner, "Loading " + url, inputStream), ENCODING)) : new LineNumberReader(new InputStreamReader(inputStream, ENCODING));
        Vector<LoggingEvent> v = new Vector<LoggingEvent>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuilder buffer = new StringBuilder(line);
                for (int i = 0; i < 1000; ++i) {
                    buffer.append(reader.readLine()).append("\n");
                }
                Vector<LoggingEvent> events = this.decodeEvents(buffer.toString());
                if (events == null) continue;
                v.addAll(events);
            }
        }
        finally {
            this.partialEvent = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    @Override
    public Vector<LoggingEvent> decodeEvents(String document) {
        if (document != null) {
            Object newDoc;
            if (document.trim().equals("")) {
                return null;
            }
            String newPartialEvent = null;
            if (document.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + document;
                return null;
            }
            if (document.lastIndexOf(RECORD_END) + RECORD_END.length() < document.length()) {
                newDoc = document.substring(0, document.lastIndexOf(RECORD_END) + RECORD_END.length());
                newPartialEvent = document.substring(document.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                newDoc = document;
            }
            if (this.partialEvent != null) {
                newDoc = this.partialEvent + (String)newDoc;
            }
            this.partialEvent = newPartialEvent;
            Document doc = this.parse((String)newDoc);
            if (doc == null) {
                return null;
            }
            return this.decodeEvents(doc);
        }
        return null;
    }

    @Override
    public LoggingEvent decode(String data) {
        Document document = this.parse(data);
        if (document == null) {
            return null;
        }
        Vector<LoggingEvent> events = this.decodeEvents(document);
        if (events.size() > 0) {
            return events.firstElement();
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    private Vector<LoggingEvent> decodeEvents(Document document) {
        Vector<LoggingEvent> events = new Vector<LoggingEvent>();
        String message = null;
        String ndc = null;
        String[] exception = null;
        String className = null;
        String methodName = null;
        String fileName = null;
        String lineNumber = null;
        Hashtable<String, String> properties = null;
        NodeList nl = document.getElementsByTagName("log4j:eventSet");
        Node eventSet = nl.item(0);
        NodeList eventList = eventSet.getChildNodes();
        for (int eventIndex = 0; eventIndex < eventList.getLength(); ++eventIndex) {
            Node eventNode = eventList.item(eventIndex);
            if (eventNode.getNodeType() != 1) continue;
            Logger logger = Logger.getLogger((String)eventNode.getAttributes().getNamedItem("logger").getNodeValue());
            long timeStamp = Long.parseLong(eventNode.getAttributes().getNamedItem("timestamp").getNodeValue());
            Level level = Level.toLevel((String)eventNode.getAttributes().getNamedItem("level").getNodeValue());
            String threadName = eventNode.getAttributes().getNamedItem("thread").getNodeValue();
            NodeList list = eventNode.getChildNodes();
            int listLength = list.getLength();
            if (listLength == 0) continue;
            for (int y = 0; y < listLength; ++y) {
                String exceptionString;
                String value;
                String name;
                Node property;
                String propertyTag;
                int i;
                int propertyLength;
                Object propertyList;
                String tagName = list.item(y).getNodeName();
                if (tagName.equalsIgnoreCase("log4j:message")) {
                    message = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("log4j:NDC")) {
                    ndc = this.getCData(list.item(y));
                }
                if (tagName.equalsIgnoreCase("log4j:MDC")) {
                    properties = new Hashtable<String, String>();
                    propertyList = list.item(y).getChildNodes();
                    propertyLength = propertyList.getLength();
                    for (i = 0; i < propertyLength; ++i) {
                        propertyTag = propertyList.item(i).getNodeName();
                        if (!propertyTag.equalsIgnoreCase("log4j:data")) continue;
                        property = propertyList.item(i);
                        name = property.getAttributes().getNamedItem("name").getNodeValue();
                        value = property.getAttributes().getNamedItem("value").getNodeValue();
                        properties.put(name, value);
                    }
                }
                if (tagName.equalsIgnoreCase("log4j:throwable") && (exceptionString = this.getCData(list.item(y))) != null && !exceptionString.trim().equals("")) {
                    exception = new String[]{exceptionString.trim()};
                }
                if (tagName.equalsIgnoreCase("log4j:locationinfo")) {
                    className = list.item(y).getAttributes().getNamedItem("class").getNodeValue();
                    methodName = list.item(y).getAttributes().getNamedItem("method").getNodeValue();
                    fileName = list.item(y).getAttributes().getNamedItem("file").getNodeValue();
                    lineNumber = list.item(y).getAttributes().getNamedItem("line").getNodeValue();
                }
                if (tagName.equalsIgnoreCase("log4j:properties")) {
                    if (properties == null) {
                        properties = new Hashtable();
                    }
                    propertyList = list.item(y).getChildNodes();
                    propertyLength = propertyList.getLength();
                    for (i = 0; i < propertyLength; ++i) {
                        propertyTag = propertyList.item(i).getNodeName();
                        if (!propertyTag.equalsIgnoreCase("log4j:data")) continue;
                        property = propertyList.item(i);
                        name = property.getAttributes().getNamedItem("name").getNodeValue();
                        value = property.getAttributes().getNamedItem("value").getNodeValue();
                        properties.put(name, value);
                    }
                }
                if (this.additionalProperties.size() <= 0) continue;
                if (properties == null) {
                    properties = new Hashtable(this.additionalProperties);
                }
                for (Object o : this.additionalProperties.entrySet()) {
                    Map.Entry e = (Map.Entry)o;
                    properties.put((String)e.getKey(), (String)e.getValue());
                }
            }
            LocationInfo info = fileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(fileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
            ThrowableInformation throwableInfo = null;
            if (exception != null) {
                throwableInfo = new ThrowableInformation(exception);
            }
            LoggingEvent loggingEvent = new LoggingEvent(null, (Category)logger, timeStamp, level, (Object)message, threadName, throwableInfo, ndc, info, properties);
            events.add(loggingEvent);
            message = null;
            ndc = null;
            exception = null;
            className = null;
            methodName = null;
            fileName = null;
            lineNumber = null;
            properties = null;
        }
        return events;
    }

    private String getCData(Node n) {
        StringBuilder buf = new StringBuilder();
        NodeList nl = n.getChildNodes();
        for (int x = 0; x < nl.getLength(); ++x) {
            Node innerNode = nl.item(x);
            if (innerNode.getNodeType() != 3 && innerNode.getNodeType() != 4) continue;
            buf.append(innerNode.getNodeValue());
        }
        return buf.toString();
    }
}

