/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.LoggerContextAccessor;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.test.junit.LoggerContextSource;
import org.apache.logging.log4j.core.test.junit.ReconfigurationPolicy;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.support.AnnotationSupport;

class LoggerContextResolver
extends TypeBasedParameterResolver<LoggerContext>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    public LoggerContextResolver() {
        super(LoggerContext.class);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        AnnotationSupport.findAnnotation((AnnotatedElement)testClass, LoggerContextSource.class).ifPresent(testSource -> {
            LoggerContextConfig config = new LoggerContextConfig((LoggerContextSource)testSource, context);
            LoggerContextResolver.getTestClassStore(context).put(LoggerContext.class, (Object)config);
        });
    }

    public void afterAll(ExtensionContext context) throws Exception {
        LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
        if (config != null) {
            config.close();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, LoggerContextSource.class)) {
            LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
            if (config == null) {
                throw new IllegalStateException("Specified @LoggerContextSource but no LoggerContext found for test class " + testClass.getCanonicalName());
            }
            if (config.reconfigurationPolicy == ReconfigurationPolicy.BEFORE_EACH) {
                config.reconfigure();
            }
        }
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), LoggerContextSource.class).ifPresent(source -> {
            LoggerContextConfig config = new LoggerContextConfig((LoggerContextSource)source, context);
            if (config.reconfigurationPolicy == ReconfigurationPolicy.BEFORE_EACH) {
                config.reconfigure();
            }
            LoggerContextResolver.getTestInstanceStore(context).put(LoggerContext.class, (Object)config);
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Class testClass;
        LoggerContextConfig testInstanceConfig = (LoggerContextConfig)LoggerContextResolver.getTestInstanceStore(context).get(LoggerContext.class, LoggerContextConfig.class);
        if (testInstanceConfig != null) {
            testInstanceConfig.close();
        }
        if (AnnotationSupport.isAnnotated((AnnotatedElement)(testClass = context.getRequiredTestClass()), LoggerContextSource.class)) {
            LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
            if (config == null) {
                throw new IllegalStateException("Specified @LoggerContextSource but no LoggerContext found for test class " + testClass.getCanonicalName());
            }
            if (config.reconfigurationPolicy == ReconfigurationPolicy.AFTER_EACH) {
                config.reconfigure();
            }
        }
    }

    public LoggerContext resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return LoggerContextResolver.getParameterLoggerContext(parameterContext, extensionContext);
    }

    private static ExtensionContext.Store getTestClassStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{LoggerContext.class, context.getRequiredTestClass()}));
    }

    private static ExtensionContext.Store getTestInstanceStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{LoggerContext.class, context.getRequiredTestInstance()}));
    }

    static LoggerContext getParameterLoggerContext(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (parameterContext.getDeclaringExecutable() instanceof Method) {
            LoggerContextAccessor accessor = (LoggerContextAccessor)LoggerContextResolver.getTestInstanceStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class);
            return accessor != null ? accessor.getLoggerContext() : ((LoggerContextAccessor)LoggerContextResolver.getTestClassStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class)).getLoggerContext();
        }
        return ((LoggerContextAccessor)LoggerContextResolver.getTestClassStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class)).getLoggerContext();
    }

    private static final class LoggerContextConfig
    implements AutoCloseable,
    LoggerContextAccessor {
        private final LoggerContext context;
        private final ReconfigurationPolicy reconfigurationPolicy;
        private final long shutdownTimeout;
        private final TimeUnit unit;

        private LoggerContextConfig(LoggerContextSource source, ExtensionContext extensionContext) {
            String displayName = extensionContext.getDisplayName();
            ClassLoader classLoader = extensionContext.getRequiredTestClass().getClassLoader();
            this.context = Configurator.initialize((String)displayName, (ClassLoader)classLoader, (String)LoggerContextConfig.getConfigLocation(source, extensionContext));
            this.reconfigurationPolicy = source.reconfigure();
            this.shutdownTimeout = source.timeout();
            this.unit = source.unit();
        }

        private static String getConfigLocation(LoggerContextSource source, ExtensionContext extensionContext) {
            String value = source.value();
            if (value.isEmpty()) {
                for (Class clazz = extensionContext.getRequiredTestClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    URL url = clazz.getResource(clazz.getSimpleName() + ".xml");
                    if (url == null) continue;
                    try {
                        return url.toURI().toString();
                    }
                    catch (URISyntaxException e) {
                        throw new ExtensionContextException("An error occurred accessing the configuration.", (Throwable)e);
                    }
                }
                return extensionContext.getRequiredTestClass().getName().replaceAll("[.$]", "/") + ".xml";
            }
            return value;
        }

        public LoggerContext getLoggerContext() {
            return this.context;
        }

        public void reconfigure() {
            this.context.reconfigure();
        }

        @Override
        public void close() {
            this.context.stop(this.shutdownTimeout, this.unit);
        }
    }
}

