/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;

class StatusLoggerMockExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback {
    private static final String KEY_PREFIX = StatusLoggerMockExtension.class.getSimpleName() + '.';
    private static final String INITIAL_STATUS_LOGGER_KEY = KEY_PREFIX + "initialStatusLogger";

    StatusLoggerMockExtension() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.setAttribute(INITIAL_STATUS_LOGGER_KEY, StatusLogger.getLogger(), context);
        StatusLogger statusLogger = (StatusLogger)Mockito.mock(StatusLogger.class);
        StatusLoggerMockExtension.stubFallbackListener(statusLogger);
        StatusLogger.setLogger((StatusLogger)statusLogger);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        StatusLogger statusLogger = StatusLogger.getLogger();
        Mockito.reset((Object[])new StatusLogger[]{statusLogger});
        StatusLoggerMockExtension.stubFallbackListener(statusLogger);
    }

    private static void stubFallbackListener(StatusLogger statusLogger) {
        StatusConsoleListener fallbackListener = (StatusConsoleListener)Mockito.mock(StatusConsoleListener.class);
        Mockito.when((Object)statusLogger.getFallbackListener()).thenReturn((Object)fallbackListener);
    }

    public void afterAll(ExtensionContext context) {
        StatusLogger statusLogger = ExtensionContextAnchor.getAttribute(INITIAL_STATUS_LOGGER_KEY, StatusLogger.class, context);
        StatusLogger.setLogger((StatusLogger)statusLogger);
    }
}

