/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.spi;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.DependencyChain;
import org.jspecify.annotations.Nullable;

class DependencyChains {
    static final DependencyChain EMPTY = new EmptyChain();

    DependencyChains() {
    }

    static DependencyChain singleton(Key<?> key) {
        return new LinkedChain(key);
    }

    private static final class LinkedChain
    implements DependencyChain {
        private final Key<?> head;
        private final @Nullable LinkedChain tail;

        private LinkedChain(Key<?> head) {
            this(head, null);
        }

        private LinkedChain(Key<?> head, @Nullable LinkedChain tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public boolean hasDependency(Key<?> key) {
            return key.equals(this.head) || this.tail != null && this.tail.hasDependency(key);
        }

        @Override
        public LinkedChain withDependency(Key<?> key) {
            if (key.equals(this.head)) {
                return this;
            }
            DependencyChain newTail = this.tail != null ? this.tail.withDependency((Key)key) : new LinkedChain(key);
            return new LinkedChain(this.head, (LinkedChain)newTail);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Key<?>> iterator() {
            return new Iter(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinkedChain keys = (LinkedChain)o;
            return this.head.equals(keys.head) && Objects.equals(this.tail, keys.tail);
        }

        public int hashCode() {
            return Objects.hash(this.head, this.tail);
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (Key<?> key : this) {
                joiner.add(key.toString());
            }
            return joiner.toString();
        }

        private static final class Iter
        implements Iterator<Key<?>> {
            private @Nullable LinkedChain current;

            private Iter(LinkedChain current) {
                this.current = current;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Key<?> next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Key<?> head = this.current.head;
                this.current = this.current.tail;
                return head;
            }
        }
    }

    private static final class EmptyChain
    implements DependencyChain {
        private EmptyChain() {
        }

        @Override
        public boolean hasDependency(Key<?> key) {
            return false;
        }

        @Override
        public DependencyChain withDependency(Key<?> key) {
            return new LinkedChain(key);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<Key<?>> iterator() {
            return Collections.emptyIterator();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return "[]";
        }
    }
}

