/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.core.lookup.Lookup;
import org.apache.logging.log4j.plugins.Plugin;

@Lookup
@Plugin(value="event")
public class EventLookup
extends AbstractLookup {
    @Override
    public String lookup(LogEvent event, String key) {
        if (event == null) {
            return null;
        }
        switch (key) {
            case "Marker": {
                return event.getMarker() != null ? event.getMarker().getName() : null;
            }
            case "ThreadName": {
                return event.getThreadName();
            }
            case "Level": {
                return event.getLevel().toString();
            }
            case "ThreadId": {
                return Long.toString(event.getThreadId());
            }
            case "Timestamp": {
                return Long.toString(event.getTimeMillis());
            }
            case "Exception": {
                if (event.getThrown() != null) {
                    return event.getThrown().getClass().getSimpleName();
                }
                return null;
            }
            case "Logger": {
                return event.getLoggerName();
            }
            case "Message": {
                return event.getMessage().getFormattedMessage();
            }
        }
        return null;
    }
}

