/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.replicator.nrt;

/**
 * Holds metadata details about a single file that we use to confirm two files (one remote, one
 * local) are in fact "identical". Header and footer of the file must be identical between primary
 * and replica to consider the files equal:
 *
 * @param header Header of the file
 * @param footer Footer of the file
 * @param length Length of the file
 * @param checksum Used to ensure no bit flips when copying the file:
 * @lucene.experimental
 */
public record FileMetaData(byte[] header, byte[] footer, long length, long checksum) {

  @Override
  public String toString() {
    return "FileMetaData(length=" + length + " checksum=" + checksum + ")";
  }
}
