/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import org.apache.lucene.sandbox.facet.cutters.LongValueFacetCutter;
import org.apache.lucene.sandbox.facet.labels.OrdToLabel;
import org.apache.lucene.sandbox.facet.utils.BaseFacetBuilder;
import org.apache.lucene.sandbox.facet.utils.ComparableUtils;
import org.apache.lucene.sandbox.facet.utils.FacetBuilder;

public final class LongValueFacetBuilder
extends BaseFacetBuilder<LongValueFacetBuilder> {
    private LongValueFacetCutter cutter;
    private final CollectionKey collectionKey;

    public LongValueFacetBuilder(String field) {
        super(field, new String[0]);
        this.collectionKey = new CollectionKey(field);
        this.sortOrderSupplier = () -> ComparableUtils.byLongValue(this.getFacetCutter());
    }

    @Override
    LongValueFacetCutter getFacetCutter() {
        return this.cutter;
    }

    @Override
    OrdToLabel getOrdToLabel() {
        return this.cutter;
    }

    @Override
    Number getOverallValue() {
        return -1;
    }

    @Override
    FacetBuilder initOrReuseCollector(FacetBuilder similar) {
        if (similar == null) {
            this.cutter = new LongValueFacetCutter(this.dimension);
        } else if (similar instanceof LongValueFacetBuilder) {
            LongValueFacetBuilder castedSimilar = (LongValueFacetBuilder)similar;
            this.cutter = castedSimilar.cutter;
        } else assert (false);
        return super.initOrReuseCollector(similar);
    }

    @Override
    LongValueFacetBuilder self() {
        return this;
    }

    @Override
    Object collectionKey() {
        return this.collectionKey;
    }

    private record CollectionKey(String indexFieldName) {
    }
}

