/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import org.apache.lucene.monitor.CollectingMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;

public class ScoringMatch
extends QueryMatch {
    public static final MatcherFactory<ScoringMatch> DEFAULT_MATCHER = ScoringMatch.matchWithSimilarity((Similarity)new BM25Similarity());
    private final float score;

    public static final MatcherFactory<ScoringMatch> matchWithSimilarity(Similarity similarity) {
        return searcher -> {
            searcher.setSimilarity(similarity);
            return new CollectingMatcher<ScoringMatch>(searcher, ScoreMode.COMPLETE){

                @Override
                protected ScoringMatch doMatch(String queryId, int doc, Scorable scorer) throws IOException {
                    float score = scorer.score();
                    if (score > 0.0f) {
                        return new ScoringMatch(queryId, score);
                    }
                    return null;
                }

                @Override
                public ScoringMatch resolve(ScoringMatch match1, ScoringMatch match2) {
                    return new ScoringMatch(match1.getQueryId(), match1.getScore() + match2.getScore());
                }
            };
        };
    }

    private ScoringMatch(String queryId, float score) {
        super(queryId);
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScoringMatch)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScoringMatch that = (ScoringMatch)o;
        return Float.compare(that.score, this.score) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.score != 0.0f ? Float.floatToIntBits(this.score) : 0);
        return result;
    }
}

