/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public final class MockFixedLengthPayloadFilter
extends TokenFilter {
    private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final Random random;
    private final byte[] bytes;
    private final BytesRef payload;

    public MockFixedLengthPayloadFilter(Random random, TokenStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        this.random = random;
        this.bytes = new byte[length];
        this.payload = new BytesRef(this.bytes);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.random.nextBytes(this.bytes);
            this.payloadAtt.setPayload(this.payload);
            return true;
        }
        return false;
    }
}

