/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.core.fuzzyml.AttrNameValue;
import org.apache.manifoldcf.core.fuzzyml.TagParseState;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;

public class XMLFuzzyParseState
extends TagParseState {
    protected final boolean lowerCaseAttributes;
    protected final boolean lowerCaseTags;
    protected final boolean lowerCaseQAttributes;
    protected final boolean lowerCaseQTags;
    protected final boolean lowerCaseBTags;
    protected final boolean lowerCaseEscapeTags;

    public XMLFuzzyParseState(boolean lowerCaseAttributes, boolean lowerCaseTags, boolean lowerCaseQAttributes, boolean lowerCaseQTags, boolean lowerCaseBTags, boolean lowerCaseEscapeTags) {
        this.lowerCaseAttributes = lowerCaseAttributes;
        this.lowerCaseTags = lowerCaseTags;
        this.lowerCaseQAttributes = lowerCaseQAttributes;
        this.lowerCaseQTags = lowerCaseQTags;
        this.lowerCaseBTags = lowerCaseBTags;
        this.lowerCaseEscapeTags = lowerCaseEscapeTags;
    }

    @Override
    protected final boolean noteTag(String tagName, List<AttrNameValue> attributes) throws ManifoldCFException {
        String nameSpace;
        String localName;
        int index;
        HashMap<String, String> attrMap = new HashMap<String, String>(attributes.size());
        for (AttrNameValue nv : attributes) {
            String name = nv.getName();
            if (this.lowerCaseAttributes) {
                name = nv.getName().toLowerCase(Locale.ROOT);
            }
            attrMap.put(name, nv.getValue());
        }
        if (this.lowerCaseTags) {
            tagName = tagName.toLowerCase(Locale.ROOT);
        }
        if ((index = tagName.indexOf(":")) == -1) {
            localName = tagName;
            nameSpace = null;
        } else {
            localName = tagName.substring(index + 1);
            nameSpace = tagName.substring(0, index);
        }
        return this.noteTagEx(tagName, nameSpace, localName, attrMap);
    }

    protected boolean noteTagEx(String tagName, String nameSpace, String localName, Map<String, String> attributes) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw tag '" + tagName + "'"));
        }
        return false;
    }

    @Override
    protected final boolean noteEndTag(String tagName) throws ManifoldCFException {
        String nameSpace;
        String localName;
        int index;
        if (this.lowerCaseTags) {
            tagName = tagName.toLowerCase(Locale.ROOT);
        }
        if ((index = tagName.indexOf(":")) == -1) {
            localName = tagName;
            nameSpace = null;
        } else {
            localName = tagName.substring(index + 1);
            nameSpace = tagName.substring(0, index);
        }
        return this.noteEndTagEx(tagName, nameSpace, localName);
    }

    protected boolean noteEndTagEx(String tagName, String nameSpace, String localName) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw end tag '" + tagName + "'"));
        }
        return false;
    }

    @Override
    protected final boolean noteQTag(String tagName, List<AttrNameValue> attributes) throws ManifoldCFException {
        HashMap<String, String> attrMap = new HashMap<String, String>(attributes.size());
        for (AttrNameValue nv : attributes) {
            String name = nv.getName();
            if (this.lowerCaseQAttributes) {
                name = nv.getName().toLowerCase(Locale.ROOT);
            }
            attrMap.put(name, nv.getValue());
        }
        if (this.lowerCaseQTags) {
            tagName = tagName.toLowerCase(Locale.ROOT);
        }
        return this.noteQTagEx(tagName, attrMap);
    }

    protected boolean noteQTagEx(String tagName, Map<String, String> attributes) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw QTag '" + tagName + "'"));
        }
        return false;
    }

    @Override
    protected final boolean noteBTag(String tagName) throws ManifoldCFException {
        if (this.lowerCaseBTags) {
            tagName = tagName.toLowerCase(Locale.ROOT);
        }
        return this.noteBTagEx(tagName);
    }

    protected boolean noteBTagEx(String tagName) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw BTag '" + tagName + "'"));
        }
        return false;
    }

    @Override
    protected final boolean noteEscaped(String token) throws ManifoldCFException {
        if (this.lowerCaseEscapeTags && token != null) {
            token = token.toLowerCase(Locale.ROOT);
        }
        return this.noteEscapedEx(token);
    }

    protected boolean noteEscapedEx(String token) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw Escaped '" + token + "'"));
        }
        return false;
    }

    @Override
    protected final boolean noteBTagToken(String token) throws ManifoldCFException {
        if (this.lowerCaseBTags) {
            token = token.toLowerCase(Locale.ROOT);
        }
        return this.noteBTagTokenEx(token);
    }

    protected boolean noteBTagTokenEx(String token) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw BTag token '" + token + "'"));
        }
        return false;
    }
}

