/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.jobs.JobDescription;

public class ForcedParamManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: ForcedParamManager.java 1601529 2014-06-09 23:19:08Z kwright $";
    public static final String ownerIDField = "ownerid";
    public static final String paramNameField = "paramname";
    public static final String paramValueField = "paramvalue";

    public ForcedParamManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobforcedparams");
    }

    public void install(String ownerTable, String owningTablePrimaryKey) throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(paramNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(paramValueField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(true, new String[]{ownerIDField, paramNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex == null) break block3;
            this.performAddIndex(null, ownerIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public Map<String, Set<String>> readRows(Long id) throws ManifoldCFException {
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)id)});
        IResultSet set = this.performQuery("SELECT paramname,paramvalue FROM " + this.getTableName() + " WHERE " + query, params, null, null);
        HashMap<String, Set<String>> rval = new HashMap<String, Set<String>>();
        if (set.getRowCount() == 0) {
            return rval;
        }
        for (int i = 0; i < set.getRowCount(); ++i) {
            HashSet<String> valueSet;
            IResultRow row = set.getRow(i);
            String paramName = (String)row.getValue(paramNameField);
            String paramValue = (String)row.getValue(paramValueField);
            if (paramValue == null) {
                paramValue = "";
            }
            if ((valueSet = (HashSet<String>)rval.get(paramName)) == null) {
                valueSet = new HashSet<String>();
                rval.put(paramName, valueSet);
            }
            valueSet.add(paramValue);
        }
        return rval;
    }

    public void getRows(Map<Long, JobDescription> returnValues, String ownerIDList, ArrayList ownerIDParams) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + ownerIDField + " IN (" + ownerIDList + ")", ownerIDParams, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            String paramName = (String)row.getValue(paramNameField);
            String paramValue = (String)row.getValue(paramValueField);
            if (paramValue == null) {
                paramValue = "";
            }
            returnValues.get(ownerID).addForcedMetadataValue(paramName, paramValue);
        }
    }

    public boolean compareRows(Long ownerID, IJobDescription list) throws ManifoldCFException {
        Map<String, Set<String>> map = this.readRows(ownerID);
        Map<String, Set<String>> otherMap = list.getForcedMetadata();
        if (map.size() != otherMap.size()) {
            return false;
        }
        for (String x : map.keySet()) {
            Set<String> xValues = map.get(x);
            Set<String> otherValues = otherMap.get(x);
            if (otherValues == null) {
                return false;
            }
            if (xValues.size() != otherValues.size()) {
                return false;
            }
            for (String y : xValues) {
                if (otherValues.contains(y)) continue;
                return false;
            }
        }
        return true;
    }

    public void writeRows(Long ownerID, IJobDescription list) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.beginTransaction();
        try {
            Map<String, Set<String>> forcedMetadata = list.getForcedMetadata();
            for (String paramName : forcedMetadata.keySet()) {
                Set<String> forcedValue = forcedMetadata.get(paramName);
                for (String paramValue : forcedValue) {
                    map.clear();
                    map.put(paramNameField, paramName);
                    map.put(paramValueField, paramValue);
                    map.put(ownerIDField, ownerID);
                    this.performInsert(map, null);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(Long ownerID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ownerID);
        this.performDelete("WHERE ownerid=?", list, null);
    }
}

