/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.ffm;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.MemoryLayout;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.impl.ffm.CLibrary;
import org.jline.terminal.impl.ffm.FfmNativePty;
import org.jline.terminal.impl.ffm.NativeWinSysTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.OSUtils;

public class FfmTerminalProvider
implements TerminalProvider {
    public FfmTerminalProvider() {
        if (!FfmTerminalProvider.class.getModule().isNativeAccessEnabled()) {
            throw new UnsupportedOperationException("Native access is not enabled for the current module: " + String.valueOf(FfmTerminalProvider.class.getModule()));
        }
    }

    public String name() {
        return "ffm";
    }

    public Terminal sysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, Charset stdinEncoding, Charset stdoutEncoding, Charset stderrEncoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return NativeWinSysTerminal.createTerminal(this, systemStream, name, type, ansiPassThrough, encoding, stdinEncoding, stdoutEncoding, stderrEncoding, nativeSignals, signalHandler, paused);
        }
        FfmNativePty pty = new FfmNativePty(this, systemStream, -1, null, 0, FileDescriptor.in, systemStream == SystemStream.Output ? 1 : 2, systemStream == SystemStream.Output ? FileDescriptor.out : FileDescriptor.err, CLibrary.ttyName(0));
        return new PosixSysTerminal(name, type, (Pty)pty, encoding, stdinEncoding, stdoutEncoding, stderrEncoding, nativeSignals, signalHandler);
    }

    public Terminal newTerminal(String name, String type, InputStream in, OutputStream out, Charset encoding, Charset stdinEncoding, Charset stdoutEncoding, Charset stderrEncoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes, Size size) throws IOException {
        Pty pty = CLibrary.openpty(this, attributes, size);
        return new PosixPtyTerminal(name, type, pty, in, out, encoding, stdinEncoding, stdoutEncoding, stderrEncoding, signalHandler, paused);
    }

    public boolean isSystemStream(SystemStream stream) {
        if (OSUtils.IS_WINDOWS) {
            return this.isWindowsSystemStream(stream);
        }
        return this.isPosixSystemStream(stream);
    }

    public boolean isWindowsSystemStream(SystemStream stream) {
        return NativeWinSysTerminal.isWindowsSystemStream(stream);
    }

    public boolean isPosixSystemStream(SystemStream stream) {
        return FfmNativePty.isPosixSystemStream(stream);
    }

    public String systemStreamName(SystemStream stream) {
        return FfmNativePty.posixSystemStreamName(stream);
    }

    public int systemStreamWidth(SystemStream stream) {
        return FfmNativePty.systemStreamWidth(stream);
    }

    public String toString() {
        return "TerminalProvider[" + this.name() + "]";
    }

    static VarHandle lookupVarHandle(MemoryLayout layout, MemoryLayout.PathElement ... element) {
        VarHandle h = layout.varHandle(element);
        h = MethodHandles.insertCoordinates(h, h.coordinateTypes().size() - 1, 0L);
        return h;
    }
}

