/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.AbstractUpgradeStrategy;
import org.apache.maven.cling.invoker.mvnup.goals.ModelVersionUtils;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

@Named
@Singleton
@Priority(value=40)
public class ModelUpgradeStrategy
extends AbstractUpgradeStrategy {
    @Override
    public boolean isApplicable(UpgradeContext context) {
        UpgradeOptions options = this.getOptions(context);
        if (options.all().orElse(false).booleanValue()) {
            return true;
        }
        String targetModel = this.determineTargetModelVersion(context);
        return !"4.0.0".equals(targetModel);
    }

    @Override
    public String getDescription() {
        return "Upgrading POM model version";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doApply(UpgradeContext context, Map<Path, Document> pomMap) {
        String targetModelVersion = this.determineTargetModelVersion(context);
        HashSet<Path> processedPoms = new HashSet<Path>();
        HashSet<Path> modifiedPoms = new HashSet<Path>();
        HashSet<Path> errorPoms = new HashSet<Path>();
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path pomPath = entry.getKey();
            Document pomDocument = entry.getValue();
            processedPoms.add(pomPath);
            String currentVersion = ModelVersionUtils.detectModelVersion(pomDocument);
            context.info(String.valueOf(pomPath) + " (current: " + currentVersion + ")");
            context.indent();
            try {
                if (currentVersion.equals(targetModelVersion)) {
                    context.success("Already at target version " + targetModelVersion);
                    continue;
                }
                if (ModelVersionUtils.canUpgrade(currentVersion, targetModelVersion)) {
                    context.action("Upgrading from " + currentVersion + " to " + targetModelVersion);
                    context.indent();
                    try {
                        this.performModelUpgrade(pomDocument, context, currentVersion, targetModelVersion);
                    }
                    finally {
                        context.unindent();
                    }
                    context.success("Model upgrade completed");
                    modifiedPoms.add(pomPath);
                    continue;
                }
                context.warning("Cannot upgrade from " + currentVersion + " to " + targetModelVersion);
            }
            catch (Exception e) {
                context.failure("Model upgrade failed: " + e.getMessage());
                errorPoms.add(pomPath);
            }
            finally {
                context.unindent();
            }
        }
        return new UpgradeResult(processedPoms, modifiedPoms, errorPoms);
    }

    private void performModelUpgrade(Document pomDocument, UpgradeContext context, String currentVersion, String targetModelVersion) {
        this.upgradeNamespaceAndSchemaLocation(pomDocument, context, targetModelVersion);
        if (ModelVersionUtils.isVersionGreaterOrEqual(targetModelVersion, "4.1.0")) {
            this.convertModulesToSubprojects(pomDocument, context);
        }
        ModelVersionUtils.updateModelVersion(pomDocument, targetModelVersion);
        context.detail("Updated modelVersion to " + targetModelVersion);
    }

    private void upgradeNamespaceAndSchemaLocation(Document pomDocument, UpgradeContext context, String targetModelVersion) {
        Element root = pomDocument.getRootElement();
        String targetNamespace = this.getNamespaceForModelVersion(targetModelVersion);
        Namespace newNamespace = Namespace.getNamespace((String)targetNamespace);
        this.updateElementNamespace(root, newNamespace);
        context.detail("Updated namespace to " + targetNamespace);
        Attribute schemaLocationAttr = root.getAttribute("schemaLocation", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        if (schemaLocationAttr != null) {
            schemaLocationAttr.setValue(ModelVersionUtils.getSchemaLocationForModelVersion(targetModelVersion));
            context.detail("Updated xsi:schemaLocation");
        }
    }

    private void updateElementNamespace(Element element, Namespace newNamespace) {
        element.setNamespace(newNamespace);
        for (Element child : element.getChildren()) {
            this.updateElementNamespace(child, newNamespace);
        }
    }

    private void convertModulesToSubprojects(Document pomDocument, UpgradeContext context) {
        Element profilesElement;
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element modulesElement = root.getChild("modules", namespace = root.getNamespace());
        if (modulesElement != null) {
            modulesElement.setName("subprojects");
            context.detail("Converted <modules> to <subprojects>");
            List moduleElements = modulesElement.getChildren("module", namespace);
            for (Element moduleElement : moduleElements) {
                moduleElement.setName("subproject");
            }
            if (!moduleElements.isEmpty()) {
                context.detail("Converted " + moduleElements.size() + " <module> elements to <subproject>");
            }
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                Element profileModulesElement = profileElement.getChild("modules", namespace);
                if (profileModulesElement == null) continue;
                profileModulesElement.setName("subprojects");
                List profileModuleElements = profileModulesElement.getChildren("module", namespace);
                for (Element moduleElement : profileModuleElements) {
                    moduleElement.setName("subproject");
                }
                if (profileModuleElements.isEmpty()) continue;
                context.detail("Converted " + profileModuleElements.size() + " <module> elements to <subproject> in profiles");
            }
        }
    }

    private String determineTargetModelVersion(UpgradeContext context) {
        UpgradeOptions options = this.getOptions(context);
        if (options.modelVersion().isPresent()) {
            return (String)options.modelVersion().get();
        }
        if (options.all().orElse(false).booleanValue()) {
            return "4.1.0";
        }
        return "4.0.0";
    }

    private String getNamespaceForModelVersion(String modelVersion) {
        if ("4.1.0".equals(modelVersion)) {
            return "http://maven.apache.org/POM/4.1.0";
        }
        return "http://maven.apache.org/POM/4.0.0";
    }
}

