/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugin.coreit;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 */
@Mojo(name = "generate-properties", defaultPhase = LifecyclePhase.VALIDATE)
public class UsesPropertiesMojo extends AbstractMojo {
    /**
     */
    @Parameter(defaultValue = "${basedir}")
    private File basedir;

    /**
     */
    @Parameter(defaultValue = "${project.properties}")
    private Properties properties;

    public void execute() throws MojoExecutionException {
        try {
            File file = new File(basedir, "target/project.properties");
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);

            properties.store(
                    fos,
                    "# Properties generated by the execution of a mojo that uses"
                            + " interpolated POM values for configuration.");
        } catch (Exception e) {
            getLog().error("Error creating mojo generated properties.", e);
        }
    }
}
