/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.session.proxyprotocolv2;

import java.util.Arrays;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.contrib.server.session.proxyprotocol.ProxyProtocolAcceptor;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.data.AddressData;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.data.FamilyAndTransport;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.data.VersionAndCommand;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.utils.ProxyUtils;
import org.apache.sshd.server.session.ServerSession;

public class ProxyProtocolV2Acceptor
extends ProxyProtocolAcceptor {
    private static final byte[] PROXY_V2_HEADER = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final char FIELD_SEPARATOR = ' ';

    @Override
    public boolean acceptServerProxyMetadata(ServerSession session, Buffer buffer) throws Exception {
        int mark = buffer.rpos();
        int dataLen = buffer.available();
        if (dataLen < PROXY_V2_HEADER.length) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("acceptServerProxyMetadata(session={}) incomplete data - {}/{}", new Object[]{session, dataLen, PROXY_V2_HEADER.length});
            }
            return false;
        }
        byte[] proxyV2Header = new byte[PROXY_V2_HEADER.length];
        buffer.getRawBytes(proxyV2Header);
        if (!Arrays.equals(PROXY_V2_HEADER, proxyV2Header)) {
            buffer.rpos(mark);
            return super.acceptServerProxyMetadata(session, buffer);
        }
        return this.readProxyV2Header(session, mark, buffer);
    }

    protected boolean readProxyV2Header(ServerSession session, int markPosition, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            int mark = buffer.rpos();
            buffer.rpos(markPosition);
            this.log.debug("readProxyV2Header(session={}) processing Proxy Protocol V2 buffer : [{}]", (Object)session, (Object)ProxyUtils.toHexString(buffer, mark));
        }
        StringBuilder proxyPayload = new StringBuilder();
        VersionAndCommand versionAndCommand = VersionAndCommand.extractValue(this.log, session, buffer);
        proxyPayload.append(versionAndCommand.name());
        FamilyAndTransport familyAndTransport = FamilyAndTransport.extractValue(this.log, session, buffer);
        proxyPayload.append(' ').append(familyAndTransport.name());
        int dataLength = buffer.getUShort();
        if (familyAndTransport.hasSockAddress()) {
            this.log.warn("parseProxyHeader(session={}) unsupported sub-protocol - {} - continue as usual", (Object)session, (Object)familyAndTransport);
            AddressData.skipUnprocessedData(this.log, session, buffer, FamilyAndTransport.UNSPEC, dataLength);
            return true;
        }
        AddressData data = AddressData.extractAddressData(this.log, session, buffer, familyAndTransport, dataLength);
        proxyPayload.append(' ').append(data);
        return this.parseProxyHeader(session, proxyPayload.toString(), markPosition, buffer);
    }

    @Override
    protected boolean parseProxyHeader(ServerSession session, String proxyHeader, int markPosition, Buffer buffer) throws Exception {
        String[] proxyFields = GenericUtils.split((String)proxyHeader, (char)' ');
        for (int index = 0; index < proxyFields.length; ++index) {
            String f = proxyFields[index];
            proxyFields[index] = GenericUtils.trimToEmpty((String)f);
        }
        if ("LOCAL".equals(proxyFields[0])) {
            this.log.debug("parseProxyHeader(session={}) local proxy check", (Object)session);
            return true;
        }
        return super.parseProxyHeader(session, proxyHeader, markPosition, buffer);
    }
}

