/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.Expression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class _ErrorPageWriter {
    private static final Log log = LogFactory.getLog(_ErrorPageWriter.class);
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/rsc/myfaces-dev-error.xml";
    private static final String ERROR_TEMPLATE_RESOURCE = "org.apache.myfaces.ERROR_TEMPLATE_RESOURCE";
    private static String[] ERROR_PARTS;
    private static final String DEBUG_TEMPLATE = "META-INF/rsc/myfaces-dev-debug.xml";
    private static final String DEBUG_TEMPLATE_RESOURCE = "org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE";
    private static String[] DEBUG_PARTS;
    private static final String[] IGNORE;

    private static String getErrorTemplate(FacesContext context) {
        String errorTemplate = context.getExternalContext().getInitParameter(ERROR_TEMPLATE_RESOURCE);
        if (errorTemplate != null) {
            return errorTemplate;
        }
        return ERROR_TEMPLATE;
    }

    private static String getDebugTemplate(FacesContext context) {
        String debugTemplate = context.getExternalContext().getInitParameter(DEBUG_TEMPLATE_RESOURCE);
        if (debugTemplate != null) {
            return debugTemplate;
        }
        return DEBUG_TEMPLATE;
    }

    private static void init(FacesContext context) throws IOException {
        if (ERROR_PARTS == null) {
            ERROR_PARTS = _ErrorPageWriter.splitTemplate(_ErrorPageWriter.getErrorTemplate(context));
        }
        if (DEBUG_PARTS == null) {
            DEBUG_PARTS = _ErrorPageWriter.splitTemplate(_ErrorPageWriter.getDebugTemplate(context));
        }
    }

    private static String[] splitTemplate(String rsc) throws IOException {
        int read;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(rsc);
        if (is == null) {
            is = _ErrorPageWriter.class.getClassLoader().getResourceAsStream(rsc);
        }
        if (is == null) {
            throw new FileNotFoundException(rsc);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        String str = baos.toString();
        return str.split("@@");
    }

    private static ArrayList getErrorId(Throwable e) {
        String message = e.getMessage();
        if (message == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(".*?\\Q,Id:\\E\\s*(\\S+)\\s*\\].*?");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public static void writeCause(Writer writer, Throwable ex) throws IOException {
        String msg = ex.getMessage();
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()).getMessage() == null) continue;
            msg = ex.getMessage();
        }
        if (msg != null) {
            msg = ex.getClass().getName() + " - " + msg;
            writer.write(msg.replaceAll("<", TS));
        } else {
            writer.write(ex.getClass().getName());
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces, Throwable e) throws IOException {
        _ErrorPageWriter.init(faces);
        Date now = new Date();
        for (int i = 0; i < ERROR_PARTS.length; ++i) {
            if ("message".equals(ERROR_PARTS[i])) {
                String msg = e.getMessage();
                if (msg != null) {
                    writer.write(msg.replaceAll("<", TS));
                    continue;
                }
                writer.write(e.getClass().getName());
                continue;
            }
            if ("trace".equals(ERROR_PARTS[i])) {
                _ErrorPageWriter.writeException(writer, e);
                continue;
            }
            if ("now".equals(ERROR_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(ERROR_PARTS[i])) {
                if (faces.getViewRoot() == null) continue;
                _ErrorPageWriter.writeComponent(writer, faces.getViewRoot(), _ErrorPageWriter.getErrorId(e));
                continue;
            }
            if ("vars".equals(ERROR_PARTS[i])) {
                _ErrorPageWriter.writeVariables(writer, faces);
                continue;
            }
            if ("cause".equals(ERROR_PARTS[i])) {
                _ErrorPageWriter.writeCause(writer, e);
                continue;
            }
            writer.write(ERROR_PARTS[i]);
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces, List exceptionList) throws IOException {
        _ErrorPageWriter.init(faces);
        Date now = new Date();
        for (int i = 0; i < ERROR_PARTS.length; ++i) {
            if ("message".equals(ERROR_PARTS[i])) {
                for (int j = 0; j < exceptionList.size(); ++j) {
                    Exception e = (Exception)exceptionList.get(j);
                    String msg = e.getMessage();
                    if (msg != null) {
                        writer.write(msg.replaceAll("<", TS));
                    } else {
                        writer.write(e.getClass().getName());
                    }
                    if (j + 1 == exceptionList.size()) continue;
                    writer.write("<br>");
                }
                continue;
            }
            if ("trace".equals(ERROR_PARTS[i])) {
                for (int j = 0; j < exceptionList.size(); ++j) {
                    Exception e = (Exception)exceptionList.get(j);
                    _ErrorPageWriter.writeException(writer, e);
                }
                continue;
            }
            if ("now".equals(ERROR_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(ERROR_PARTS[i])) {
                if (faces.getViewRoot() == null) continue;
                ArrayList highlightId = null;
                for (int j = 0; j < exceptionList.size(); ++j) {
                    Exception e = (Exception)exceptionList.get(j);
                    if (highlightId == null) {
                        highlightId = _ErrorPageWriter.getErrorId(e);
                        continue;
                    }
                    highlightId.addAll(_ErrorPageWriter.getErrorId(e));
                }
                _ErrorPageWriter.writeComponent(writer, faces.getViewRoot(), highlightId);
                continue;
            }
            if ("vars".equals(ERROR_PARTS[i])) {
                _ErrorPageWriter.writeVariables(writer, faces);
                continue;
            }
            if ("cause".equals(ERROR_PARTS[i])) {
                for (int j = 0; j < exceptionList.size(); ++j) {
                    Exception e = (Exception)exceptionList.get(j);
                    _ErrorPageWriter.writeCause(writer, e);
                    if (j + 1 == exceptionList.size()) continue;
                    writer.write("<br>");
                }
                continue;
            }
            writer.write(ERROR_PARTS[i]);
        }
    }

    private static void writeException(Writer writer, Throwable e) throws IOException {
        StringWriter str = new StringWriter(256);
        PrintWriter pstr = new PrintWriter(str);
        e.printStackTrace(pstr);
        pstr.close();
        writer.write(str.toString().replaceAll("<", TS));
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        _ErrorPageWriter.init(faces);
        Date now = new Date();
        for (int i = 0; i < DEBUG_PARTS.length; ++i) {
            if ("message".equals(DEBUG_PARTS[i])) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(DEBUG_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(DEBUG_PARTS[i])) {
                _ErrorPageWriter.writeComponent(writer, faces.getViewRoot(), null);
                continue;
            }
            if ("vars".equals(DEBUG_PARTS[i])) {
                _ErrorPageWriter.writeVariables(writer, faces);
                continue;
            }
            writer.write(DEBUG_PARTS[i]);
        }
    }

    private static void writeVariables(Writer writer, FacesContext faces) throws IOException {
        ExternalContext ctx = faces.getExternalContext();
        _ErrorPageWriter.writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        _ErrorPageWriter.writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        if (ctx.getSession(false) != null) {
            _ErrorPageWriter.writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        }
        _ErrorPageWriter.writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    private static void writeVariables(Writer writer, Map vars, String caption) throws IOException {
        writer.write("<table><caption>");
        writer.write(caption);
        writer.write("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap map = new TreeMap(vars);
            Map.Entry entry2 = null;
            String key = null;
            for (Map.Entry entry2 : map.entrySet()) {
                key = entry2.getKey().toString();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr><td>");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                writer.write(entry2.getValue().toString().replaceAll("<", TS));
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void writeComponent(Writer writer, UIComponent c, List highlightId) throws IOException {
        writer.write("<dl><dt");
        if (_ErrorPageWriter.isText(c)) {
            writer.write(" class=\"uicText\"");
        }
        if (highlightId != null && highlightId.size() > 0 && highlightId.get(0).equals(c.getId())) {
            highlightId.remove(0);
            if (highlightId.size() == 0) {
                writer.write(" class=\"highlightComponent\"");
            }
        }
        writer.write(">");
        boolean hasChildren = c.getChildCount() > 0 || c.getFacets().size() > 0;
        _ErrorPageWriter.writeStart(writer, c, hasChildren);
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacets().size() > 0) {
                for (Map.Entry<String, UIComponent> entry : c.getFacets().entrySet()) {
                    writer.write("<dd class=\"uicFacet\">");
                    writer.write("<span>");
                    writer.write(entry.getKey());
                    writer.write("</span>");
                    _ErrorPageWriter.writeComponent(writer, entry.getValue(), highlightId);
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                Iterator<UIComponent> itr = c.getChildren().iterator();
                while (itr.hasNext()) {
                    writer.write("<dd>");
                    _ErrorPageWriter.writeComponent(writer, itr.next(), highlightId);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt>");
            _ErrorPageWriter.writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!_ErrorPageWriter.isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(_ErrorPageWriter.getName(c));
            writer.write(62);
        }
    }

    private static void writeAttributes(Writer writer, UIComponent c) {
        try {
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            Method m = null;
            Object v = null;
            String str = null;
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getWriteMethod() == null || Arrays.binarySearch(IGNORE, pd[i].getName()) >= 0) continue;
                m = pd[i].getReadMethod();
                try {
                    v = m.invoke((Object)c, null);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    writer.write(" ");
                    writer.write(pd[i].getName());
                    writer.write("=\"");
                    str = v instanceof Expression ? ((Expression)v).getExpressionString() : (v instanceof ValueBinding ? ((ValueBinding)v).getExpressionString() : (v instanceof MethodBinding ? ((MethodBinding)v).getExpressionString() : v.toString()));
                    writer.write(str.replaceAll("<", TS));
                    writer.write("\"");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ValueExpression binding = c.getValueExpression("binding");
            if (binding != null) {
                writer.write(" binding=\"");
                writer.write(binding.getExpressionString().replaceAll("<", TS));
                writer.write("\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeStart(Writer writer, UIComponent c, boolean children) throws IOException {
        if (_ErrorPageWriter.isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(_ErrorPageWriter.getName(c));
            _ErrorPageWriter.writeAttributes(writer, c);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean isText(UIComponent c) {
        return c.getClass().getName().startsWith("com.sun.facelets.compiler");
    }

    public static void handleException(FacesContext facesContext, Exception ex) throws ServletException, IOException {
        _ErrorPageWriter.handleThrowable(facesContext, ex);
    }

    public static void handleThrowable(FacesContext facesContext, Throwable ex) throws ServletException, IOException {
        _ErrorPageWriter.prepareExceptionStack(ex);
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResp = (HttpServletResponse)response;
            if (!httpResp.isCommitted()) {
                httpResp.reset();
                httpResp.setContentType("text/html; charset=UTF-8");
                PrintWriter writer = httpResp.getWriter();
                _ErrorPageWriter.debugHtml((Writer)writer, facesContext, ex);
                log.error((Object)"An exception occurred", ex);
            } else {
                _ErrorPageWriter.throwException(ex);
            }
        } else {
            _ErrorPageWriter.throwException(ex);
        }
    }

    public static void handleExceptionList(FacesContext facesContext, List exceptionList) throws ServletException, IOException {
        for (int i = 0; i < exceptionList.size(); ++i) {
            _ErrorPageWriter.prepareExceptionStack((Exception)exceptionList.get(i));
        }
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResp = (HttpServletResponse)response;
            if (!httpResp.isCommitted()) {
                httpResp.reset();
                httpResp.setContentType("text/html; charset=UTF-8");
                PrintWriter writer = httpResp.getWriter();
                _ErrorPageWriter.debugHtml((Writer)writer, facesContext, exceptionList);
                for (int i = 0; i < exceptionList.size(); ++i) {
                    log.error((Object)"An exception occurred", (Throwable)((Exception)exceptionList.get(i)));
                }
            } else {
                _ErrorPageWriter.throwException((Exception)exceptionList.get(0));
            }
        } else {
            _ErrorPageWriter.throwException((Exception)exceptionList.get(0));
        }
    }

    private static void prepareExceptionStack(Throwable ex) {
        if (ex == null) {
            return;
        }
        if (!_ErrorPageWriter.initCausePerReflection(ex, "getRootCause")) {
            _ErrorPageWriter.initCausePerReflection(ex, "getCause");
        }
        _ErrorPageWriter.prepareExceptionStack(ex.getCause());
    }

    private static boolean initCausePerReflection(Throwable ex, String methodName) {
        try {
            Method causeGetter = ex.getClass().getMethod(methodName, new Class[0]);
            Throwable rootCause = (Throwable)causeGetter.invoke((Object)ex, (Object[])new Class[0]);
            return _ErrorPageWriter.initCauseIfAvailable(ex, rootCause);
        }
        catch (Exception e1) {
            return false;
        }
    }

    static void throwException(Throwable e) throws IOException, ServletException {
        _ErrorPageWriter.prepareExceptionStack(e);
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof ServletException) {
            throw (ServletException)e;
        }
        ServletException ex = e.getMessage() != null ? new ServletException(e.getMessage(), e) : new ServletException(e);
        _ErrorPageWriter.initCauseIfAvailable((Throwable)ex, e);
        throw ex;
    }

    private static boolean initCauseIfAvailable(Throwable th, Throwable cause) {
        if (cause == null) {
            return false;
        }
        try {
            Method m = Throwable.class.getMethod("initCause", Throwable.class);
            m.invoke((Object)th, cause);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
    }
}

