/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.Lifecycle;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.lifecycle.ApplyRequestValuesExecutor;
import org.apache.myfaces.lifecycle.InvokeApplicationExecutor;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.PhaseListenerManager;
import org.apache.myfaces.lifecycle.ProcessValidationsExecutor;
import org.apache.myfaces.lifecycle.RenderResponseExecutor;
import org.apache.myfaces.lifecycle.RestoreViewExecutor;
import org.apache.myfaces.lifecycle.UpdateModelValuesExecutor;
import org.apache.myfaces.util.DebugUtils;
import org.apache.myfaces.util.lang.Assert;

public class LifecycleImpl
extends Lifecycle {
    private static final Logger log = Logger.getLogger(LifecycleImpl.class.getName());
    public static final String FIRST_REQUEST_PROCESSED_PARAM = "org.apache.myfaces.lifecycle.first.request.processed";
    private final PhaseExecutor[] lifecycleExecutors = new PhaseExecutor[]{new RestoreViewExecutor(), new ApplyRequestValuesExecutor(), new ProcessValidationsExecutor(), new UpdateModelValuesExecutor(), new InvokeApplicationExecutor()};
    private final PhaseExecutor renderExecutor = new RenderResponseExecutor();
    private final ClientWindowFactory clientWindowFactory = (ClientWindowFactory)FactoryFinder.getFactory("javax.faces.lifecycle.ClientWindowFactory");
    private final List<PhaseListener> phaseListeners = new CopyOnWriteArrayList<PhaseListener>();
    private volatile boolean _firstRequestProcessed = false;

    @Override
    public void attachWindow(FacesContext facesContext) {
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            clientWindow = this.getClientWindowFactory().getClientWindow(facesContext);
        }
        if (clientWindow != null) {
            try {
                facesContext.getExternalContext().setClientWindow(clientWindow);
                clientWindow.decode(facesContext);
            }
            catch (RuntimeException e) {
                facesContext.getExternalContext().setClientWindow(null);
                throw e;
            }
        }
    }

    protected ClientWindowFactory getClientWindowFactory() {
        return this.clientWindowFactory;
    }

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        if (!facesContext.isProjectStage(ProjectStage.Production)) {
            new FacesConfigurator(facesContext.getExternalContext()).update();
        }
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        for (PhaseExecutor executor : this.lifecycleExecutors) {
            if (!this.executePhase(facesContext, executor, phaseListenerMgr)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePhase(FacesContext context, PhaseExecutor executor, PhaseListenerManager phaseListenerMgr) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entering " + executor.getPhase() + " in " + LifecycleImpl.class.getName());
        }
        PhaseId currentPhaseId = executor.getPhase();
        Flash flash = context.getExternalContext().getFlash();
        try {
            context.setCurrentPhaseId(currentPhaseId);
            flash.doPrePhaseActions(context);
            executor.doPrePhaseActions(context);
            phaseListenerMgr.informPhaseListenersBefore(currentPhaseId);
            if (this.isResponseComplete(context, currentPhaseId, true)) {
                boolean bl = true;
                return bl;
            }
            if (this.shouldRenderResponse(context, currentPhaseId, true)) {
                skipFurtherProcessing = true;
            }
            if (executor.execute(context)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable e) {
            this.publishException(e, currentPhaseId, context);
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(currentPhaseId);
            flash.doPostPhaseActions(context);
        }
        context.getExceptionHandler().handle();
        if (this.isResponseComplete(context, currentPhaseId, false) || this.shouldRenderResponse(context, currentPhaseId, false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isLoggable(Level.FINEST)) {
            log.finest("exiting " + executor.getPhase() + " in " + LifecycleImpl.class.getName());
        }
        return skipFurtherProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(FacesContext facesContext) throws FacesException {
        if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entering " + this.renderExecutor.getPhase() + " in " + LifecycleImpl.class.getName());
        }
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        Flash flash = facesContext.getExternalContext().getFlash();
        try {
            facesContext.setCurrentPhaseId(this.renderExecutor.getPhase());
            flash.doPrePhaseActions(facesContext);
            this.renderExecutor.doPrePhaseActions(facesContext);
            phaseListenerMgr.informPhaseListenersBefore(this.renderExecutor.getPhase());
            if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
                return;
            }
            this.renderExecutor.execute(facesContext);
        }
        catch (Throwable e) {
            this.publishException(e, this.renderExecutor.getPhase(), facesContext);
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(this.renderExecutor.getPhase());
            flash.doPostPhaseActions(facesContext);
            this.requestProcessed(facesContext);
        }
        facesContext.getExceptionHandler().handle();
        if (log.isLoggable(Level.FINEST)) {
            DebugUtils.traceView("View after rendering");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("exiting " + this.renderExecutor.getPhase() + " in " + LifecycleImpl.class.getName());
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners");
            }
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners");
            }
            flag = true;
        }
        return flag;
    }

    @Override
    public void addPhaseListener(PhaseListener phaseListener) {
        Assert.notNull(phaseListener, "phaseListener");
        this.phaseListeners.add(phaseListener);
    }

    @Override
    public void removePhaseListener(PhaseListener phaseListener) {
        Assert.notNull(phaseListener, "phaseListener");
        this.phaseListeners.remove(phaseListener);
    }

    @Override
    public PhaseListener[] getPhaseListeners() {
        return this.phaseListeners.toArray(new PhaseListener[this.phaseListeners.size()]);
    }

    private void publishException(Throwable e, PhaseId phaseId, FacesContext facesContext) {
        ExceptionQueuedEventContext context = new ExceptionQueuedEventContext(facesContext, e, null, phaseId);
        facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, context);
    }

    private void requestProcessed(FacesContext facesContext) {
        if (!this._firstRequestProcessed) {
            facesContext.getExternalContext().getApplicationMap().put(FIRST_REQUEST_PROCESSED_PARAM, Boolean.TRUE);
            this._firstRequestProcessed = true;
        }
    }
}

