/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.ServletContext;
import org.apache.myfaces.context.servlet.ApplicationMap;
import org.apache.myfaces.context.servlet.InitParameterMap;
import org.apache.myfaces.util.lang.Assert;

public abstract class ServletExternalContextImplBase
extends ExternalContext {
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = InitParameterMap.class.getName();
    private ServletContext _servletContext;
    private Map<String, Object> _applicationMap;
    private Map<String, String> _initParameterMap;
    private ClientWindow _clientWindow;

    public ServletExternalContextImplBase(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._applicationMap = null;
        this._initParameterMap = null;
        this._clientWindow = null;
    }

    public void release() {
        this._servletContext = null;
        this._applicationMap = null;
        this._initParameterMap = null;
        this._clientWindow = null;
    }

    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._servletContext);
        }
        return this._applicationMap;
    }

    public String getMimeType(String file) {
        Assert.notNull(file, "file");
        return this._servletContext.getMimeType(file);
    }

    public Object getContext() {
        return this._servletContext;
    }

    public String getContextName() {
        return this._servletContext.getServletContextName();
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "name");
        return this._servletContext.getInitParameter(name);
    }

    public Map<String, String> getInitParameterMap() {
        if (this._initParameterMap == null) {
            this._initParameterMap = (Map)this._servletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE);
            if (this._initParameterMap == null) {
                this._initParameterMap = new InitParameterMap(this._servletContext);
                this._servletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, this._initParameterMap);
            }
        }
        return this._initParameterMap;
    }

    public URL getResource(String path) throws MalformedURLException {
        Assert.notNull(path, "path");
        return this._servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        Assert.notNull(path, "path");
        return this._servletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        Assert.notNull(path, "path");
        return this._servletContext.getResourcePaths(path);
    }

    public void log(String message) {
        Assert.notNull(message, "message");
        this._servletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        Assert.notNull(message, "message");
        Assert.notNull(exception, "exception");
        this._servletContext.log(message, exception);
    }

    public String getRealPath(String path) {
        Assert.notNull(path, "path");
        return this._servletContext.getRealPath(path);
    }

    public ClientWindow getClientWindow() {
        return this._clientWindow;
    }

    public void setClientWindow(ClientWindow window) {
        this._clientWindow = window;
    }

    public String getApplicationContextPath() {
        return this._servletContext.getContextPath();
    }
}

