/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.renderkit.ErrorPageWriter;
import org.apache.myfaces.util.lang.FastWriter;

public final class UIDebug
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "facelets.ui.Debug";
    public static final String COMPONENT_FAMILY = "facelets";
    public static final String DEFAULT_HOTKEY = "D";
    private static final String KEY = "facelets.ui.DebugOutput";
    private static long nextId = System.currentTimeMillis();
    private String _hotkey = "D";

    public UIDebug() {
        this.setTransient(true);
        this.setRendererType(null);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public List<UIComponent> getChildren() {
        return new ArrayList<UIComponent>(){

            @Override
            public boolean add(UIComponent o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }

            @Override
            public void add(int index, UIComponent o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }
        };
    }

    public void encodeBegin(FacesContext faces) throws IOException {
        boolean partialRequest = faces.getPartialViewContext().isPartialRequest();
        String actionId = faces.getApplication().getViewHandler().getActionURL(faces, faces.getViewRoot().getViewId());
        StringBuilder sb = new StringBuilder(512);
        sb.append("<script language=\"javascript\" type=\"text/javascript\">\n");
        if (!partialRequest) {
            sb.append("//<![CDATA[\n");
        }
        sb.append("function faceletsDebug(URL) { day = new Date(); id = day.getTime(); eval(\"page\" + id + \" = window.open(URL, '\" + id + \"', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=800,height=600,left = 240,top = 212');\"); };");
        sb.append("var faceletsOrigKeyup = document.onkeyup; document.onkeyup = function(e) { ");
        sb.append("if (window.event) e = window.event; if (String.fromCharCode(e.keyCode) == '");
        sb.append(this.getHotkey());
        sb.append("' & e.shiftKey & e.ctrlKey) faceletsDebug('");
        sb.append(actionId);
        int index = actionId.indexOf(63);
        if (index != -1) {
            sb.append('&');
        } else {
            sb.append('?');
        }
        sb.append(KEY);
        sb.append('=');
        sb.append(UIDebug.writeDebugOutput(faces));
        sb.append("'); else if (faceletsOrigKeyup) faceletsOrigKeyup(e); };\n");
        if (!partialRequest) {
            sb.append("//]]>\n");
        }
        sb.append("</script>\n");
        ResponseWriter writer = faces.getResponseWriter();
        writer.write(sb.toString());
    }

    private static String writeDebugOutput(FacesContext faces) throws IOException {
        FastWriter fw = new FastWriter();
        ErrorPageWriter.debugHtml(fw, faces);
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs == null) {
            debugs = new LinkedHashMap<String, String>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                    return this.size() > 5;
                }
            };
            session.put(KEY, debugs);
        }
        String id = String.valueOf(nextId++);
        debugs.put(id, fw.toString());
        return id;
    }

    private static String fetchDebugOutput(FacesContext faces, String id) {
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs != null) {
            return (String)debugs.get(id);
        }
        return null;
    }

    public static boolean debugRequest(FacesContext faces) {
        String id = (String)faces.getExternalContext().getRequestParameterMap().get(KEY);
        if (id != null) {
            Object resp = faces.getExternalContext().getResponse();
            if (!faces.getResponseComplete() && resp instanceof HttpServletResponse) {
                try {
                    HttpServletResponse httpResp = (HttpServletResponse)resp;
                    String page = UIDebug.fetchDebugOutput(faces, id);
                    if (page != null) {
                        httpResp.setContentType("text/html");
                        httpResp.getWriter().write(page);
                    } else {
                        httpResp.setContentType("text/plain");
                        httpResp.getWriter().write("No Debug Output Available");
                    }
                    httpResp.flushBuffer();
                    faces.responseComplete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getId() {
        return super.getId();
    }

    public String getHotkey() {
        return this._hotkey;
    }

    public void setHotkey(String hotkey) {
        this._hotkey = hotkey != null ? hotkey.toUpperCase() : "";
    }
}

