/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.bean.ManagedBean;
import javax.inject.Named;
import org.apache.myfaces.bean.literal.NamedLiteral;

class ManagedBeanWrapper
implements AnnotatedType<Object> {
    private final AnnotatedType wrapped;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Set<Annotation> annotationSet;

    ManagedBeanWrapper(AnnotatedType wrapped, ManagedBean managedBean, Class<? extends Annotation> newScope, Class<? extends Annotation> oldScope, AnnotationLiteral literal) {
        this.wrapped = wrapped;
        this.annotations = new HashMap<Class<? extends Annotation>, Annotation>(wrapped.getAnnotations().size());
        this.annotations.put(newScope, (Annotation)literal);
        this.annotations.put(Named.class, (Annotation)((Object)new NamedLiteral(managedBean.name())));
        for (Annotation originalAnnotation : wrapped.getAnnotations()) {
            if (originalAnnotation.annotationType().equals(oldScope) || originalAnnotation.annotationType().equals(ManagedBean.class)) continue;
            this.annotations.put(originalAnnotation.annotationType(), originalAnnotation);
        }
        this.annotationSet = new HashSet<Annotation>(this.annotations.values());
    }

    public Class getJavaClass() {
        return this.wrapped.getJavaClass();
    }

    public Set getConstructors() {
        return this.wrapped.getConstructors();
    }

    public Set getMethods() {
        return this.wrapped.getMethods();
    }

    public Set getFields() {
        return this.wrapped.getFields();
    }

    public Type getBaseType() {
        return this.wrapped.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrapped.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> targetClass) {
        return (T)this.annotations.get(targetClass);
    }

    public Set<Annotation> getAnnotations() {
        return this.annotationSet;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> targetClass) {
        return this.annotations.containsKey(targetClass);
    }
}

