/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.el;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.el.DefaultELHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class FaceletsTaglibExpressionHelper {
    FaceletsTaglibExpressionHelper() {
    }

    public static ValueBindingExpression tryToCreateValueBindingForFaceletsBinding(UIComponent uiComponent) {
        String faceletsValueBindingExpression = DefaultELHelper.getOriginalValueBindingExpression(uiComponent);
        try {
            List<String> foundBindings = FaceletsTaglibExpressionHelper.extractELTerms(ExtValUtils.getELHelper().getBindingOfComponent(uiComponent, "value"));
            HashMap<String, String> mappedFaceletsVars = new HashMap<String, String>();
            ValueBindingExpression vbe = new ValueBindingExpression(faceletsValueBindingExpression.substring(0, 1) + "{" + FaceletsTaglibExpressionHelper.createBinding(foundBindings, mappedFaceletsVars) + "}");
            Class entityClass = ExtValUtils.getELHelper().getTypeOfExpression(FacesContext.getCurrentInstance(), vbe.getBaseExpression());
            if (entityClass == null) {
                return FaceletsTaglibExpressionHelper.tryToReplaceVars(vbe, mappedFaceletsVars);
            }
            return vbe;
        }
        catch (Exception e) {
            return new ValueBindingExpression(faceletsValueBindingExpression);
        }
    }

    @ToDo(value=Priority.MEDIUM, description="logging")
    private static String createBinding(List<String> expressions, Map<String, String> virtualVars) {
        HashMap<String, String> addedVirtualNames = new HashMap<String, String>();
        for (String entry : expressions) {
            if (entry.startsWith("ValueExpression[")) continue;
            String[] foundBindingDetails = entry.split(" ");
            int indexOfBindingDetails = FaceletsTaglibExpressionHelper.findIndexOfBindingDetails(foundBindingDetails);
            if (indexOfBindingDetails == -1) {
                return null;
            }
            String[] bindingDetails = foundBindingDetails[indexOfBindingDetails].split("=");
            if (bindingDetails.length < 2) {
                return null;
            }
            String currentBinding = bindingDetails[1];
            if (currentBinding.contains("{") && !currentBinding.contains("}")) {
                currentBinding = FaceletsTaglibExpressionHelper.addFurtherBindingParts(currentBinding, foundBindingDetails, indexOfBindingDetails);
            }
            if (currentBinding.contains("}") && !addedVirtualNames.containsKey(bindingDetails[0])) {
                addedVirtualNames.put(bindingDetails[0], currentBinding);
            }
            if (currentBinding.contains("{") || currentBinding.contains("}")) continue;
            virtualVars.put(bindingDetails[0], bindingDetails[1].substring(1, bindingDetails[1].length() - 2));
        }
        String originalBinding = (String)addedVirtualNames.get("value");
        originalBinding = originalBinding.substring(originalBinding.indexOf("{") + 1, originalBinding.indexOf("}"));
        addedVirtualNames.remove("value");
        return FaceletsTaglibExpressionHelper.tryToTransformToRealBinding(originalBinding, addedVirtualNames, virtualVars);
    }

    private static String tryToTransformToRealBinding(String originalBinding, Map<String, String> addedVirtualNames, Map<String, String> virtualVars) {
        String currentValue;
        originalBinding = "#{" + originalBinding + "}";
        for (String currentKey : addedVirtualNames.keySet()) {
            currentValue = addedVirtualNames.get(currentKey);
            currentValue = currentValue.substring(currentValue.indexOf("{") + 1, currentValue.indexOf("}"));
            originalBinding = originalBinding.replace("{" + currentKey + ".", "{" + currentValue + ".");
            originalBinding = originalBinding.replace("{" + currentKey + "[", "{" + currentValue + "[");
            originalBinding = originalBinding.replace("." + currentKey + ".", "." + currentValue + ".");
            originalBinding = originalBinding.replace("." + currentKey + "[", "." + currentValue + "[");
            originalBinding = originalBinding.replace("[" + currentKey + "]", "['" + currentValue + "']");
            originalBinding = originalBinding.replace("[" + currentKey + "[", "[" + currentValue + "[");
            originalBinding = originalBinding.replace("[" + currentKey + ".", "[" + currentValue + ".");
        }
        for (String currentKey : virtualVars.keySet()) {
            currentValue = virtualVars.get(currentKey);
            originalBinding = originalBinding.replace("{" + currentKey + ".", "{" + currentValue + ".");
            originalBinding = originalBinding.replace("{" + currentKey + "[", "{" + currentValue + "[");
            originalBinding = originalBinding.replace("." + currentKey + ".", "." + currentValue + ".");
            originalBinding = originalBinding.replace("." + currentKey + "[", "." + currentValue + "[");
            originalBinding = originalBinding.replace("[" + currentKey + "]", "['" + currentValue + "']");
            originalBinding = originalBinding.replace("[" + currentKey + "[", "[" + currentValue + "[");
            originalBinding = originalBinding.replace("[" + currentKey + ".", "[" + currentValue + ".");
        }
        return originalBinding.substring(2, originalBinding.length() - 1);
    }

    private static String addFurtherBindingParts(String currentBinding, String[] foundBindingDetails, int indexOfBindingDetails) {
        for (int i = indexOfBindingDetails + 1; i < foundBindingDetails.length; ++i) {
            currentBinding = currentBinding + foundBindingDetails[i];
            if (!foundBindingDetails[i].contains("}")) continue;
            return currentBinding;
        }
        return currentBinding;
    }

    private static int findIndexOfBindingDetails(String[] bindingDetails) {
        int count = 0;
        for (String entry : bindingDetails) {
            if (entry.contains("=")) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private static List<String> extractELTerms(Object o) {
        ArrayList<String> foundELTerms = new ArrayList<String>();
        try {
            if (FaceletsTaglibExpressionHelper.resolveELTerms(o, new HashMap<Object, Object>(), foundELTerms, 0) > 0) {
                return foundELTerms;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    private static int resolveELTerms(Object o, Map<Object, Object> visited, List<String> foundELTerms, int count) throws Exception {
        if (o == null || visited.containsKey(o) || count > 50) {
            return 0;
        }
        visited.put(o, null);
        int elCount = 0;
        Class<?> c = o.getClass();
        if (o instanceof Map) {
            for (Object entry : ((Map)o).values()) {
                if (entry.toString().contains("ValueExpression[")) {
                    foundELTerms.add(entry.toString());
                }
                elCount += FaceletsTaglibExpressionHelper.resolveELTerms(entry, visited, foundELTerms, count + 1);
            }
            return elCount;
        }
        if (ExtValUtils.getELHelper().isELTermWellFormed(o)) {
            if (foundELTerms != null) {
                foundELTerms.add(o.toString());
            }
            return ++elCount;
        }
        if (c.isArray()) {
            int length = Array.getLength(o);
            if (o.toString().startsWith("[L")) {
                for (int i = 0; i < length; ++i) {
                    if (o.toString().startsWith("[Ljava.lang.String")) {
                        if (!ExtValUtils.getELHelper().isELTermWellFormed(Array.get(o, i))) continue;
                        if (foundELTerms != null) {
                            foundELTerms.add(o.toString());
                        }
                        ++elCount;
                        continue;
                    }
                    elCount += FaceletsTaglibExpressionHelper.resolveELTerms(Array.get(o, i), visited, foundELTerms, count + 1);
                }
            }
            return elCount;
        }
        List<Field> attributes = FaceletsTaglibExpressionHelper.findAllAttributes(c, new ArrayList<Field>());
        AccessibleObject[] fields = attributes.toArray(new Field[attributes.size()]);
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject currentField : fields) {
            if (((Field)currentField).get(o) == null) continue;
            if (((Field)currentField).getType().equals(String.class)) {
                if (((Field)currentField).get(o) == null || !ExtValUtils.getELHelper().isELTermWellFormed(((Field)currentField).get(o))) continue;
                if (foundELTerms != null) {
                    foundELTerms.add(o.toString());
                }
                ++elCount;
                continue;
            }
            if (((Field)currentField).getType().isPrimitive()) continue;
            elCount += FaceletsTaglibExpressionHelper.resolveELTerms(((Field)currentField).get(o), visited, foundELTerms, count + 1);
        }
        return elCount;
    }

    private static List<Field> findAllAttributes(Class c, List<Field> attributes) {
        Field[] fields;
        if (c == null) {
            return attributes;
        }
        FaceletsTaglibExpressionHelper.findAllAttributes(c.getSuperclass(), attributes);
        for (Field currentField : fields = c.getDeclaredFields()) {
            if (Modifier.isStatic(currentField.getModifiers())) continue;
            attributes.add(currentField);
        }
        return attributes;
    }

    private static ValueBindingExpression tryToReplaceVars(ValueBindingExpression valueBindingExpression, Map<String, String> mappedFaceletsVars) {
        String result = "";
        boolean last = false;
        do {
            if (valueBindingExpression.getBaseExpression() == null) {
                last = true;
            }
            String property = valueBindingExpression.getProperty();
            valueBindingExpression = ValueBindingExpression.replaceProperty(valueBindingExpression, FaceletsTaglibExpressionHelper.getNewProperty(property, mappedFaceletsVars));
            result = result.length() == 0 ? valueBindingExpression.getProperty() : valueBindingExpression.getProperty() + "." + result;
            valueBindingExpression = valueBindingExpression.getBaseExpression();
        } while (!last);
        return new ValueBindingExpression(valueBindingExpression.getPrefix() + "{" + result + "}");
    }

    private static String getNewProperty(String oldProperty, Map<String, String> mappedFaceletsVars) {
        List<String> virtualVars = FaceletsTaglibExpressionHelper.getPotentialVirtualVars(oldProperty);
        for (String virtualVar : virtualVars) {
            if (!mappedFaceletsVars.containsKey(virtualVar)) continue;
            oldProperty = FaceletsTaglibExpressionHelper.replacePropertyValue(oldProperty, virtualVar, mappedFaceletsVars.get(virtualVar));
        }
        return oldProperty;
    }

    private static List<String> getPotentialVirtualVars(String oldProperty) {
        int start = -1;
        int end = -1;
        ArrayList<String> virtualVarList = new ArrayList<String>();
        for (int i = 0; i < oldProperty.length(); ++i) {
            if (start == -1 && oldProperty.charAt(i) == '[') {
                start = i + 1;
            } else if (start != -1 && oldProperty.charAt(i) == '[' || oldProperty.charAt(i) == ']') {
                end = i;
            }
            if (start == -1 || end == -1) continue;
            virtualVarList.add(oldProperty.substring(start, end));
            start = oldProperty.charAt(i) == '[' ? i + 1 : -1;
            end = -1;
        }
        return virtualVarList;
    }

    private static String replacePropertyValue(String oldProperty, String targetVar, String newValue) {
        int index = oldProperty.indexOf(targetVar);
        if (index == -1) {
            return oldProperty;
        }
        String result = oldProperty.substring(0, index);
        result = result + newValue;
        return result + oldProperty.substring(index + targetVar.length(), oldProperty.length());
    }
}

