/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.property.DefaultPropertyInformation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.storage.MetaDataStorage;
import org.apache.myfaces.extensions.validator.core.storage.MetaDataStorageFilter;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultMetaDataStorage
implements MetaDataStorage {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Map<String, PropertyInformation>> cachedPropertyInformation = new ConcurrentHashMap<String, Map<String, PropertyInformation>>();
    private List<MetaDataStorageFilter> metaDataStorageFilters = new CopyOnWriteArrayList<MetaDataStorageFilter>();
    private List<Class<? extends MetaDataStorageFilter>> deniedMetaDataFilters = new CopyOnWriteArrayList<Class<? extends MetaDataStorageFilter>>();

    public DefaultMetaDataStorage() {
        this.initFilters();
    }

    private void initFilters() {
        ArrayList<String> metaDataStorageFilterClassNames = new ArrayList<String>();
        metaDataStorageFilterClassNames.add(ExtValCoreConfiguration.get().customMetaDataStorageFilterClassName());
        metaDataStorageFilterClassNames.add(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.META_DATA_STORAGE_FILTER));
        for (String validationExceptionInterceptorName : metaDataStorageFilterClassNames) {
            MetaDataStorageFilter metaDataStorageFilter = (MetaDataStorageFilter)ClassUtils.tryToInstantiateClassForName(validationExceptionInterceptorName);
            if (metaDataStorageFilter == null) continue;
            this.metaDataStorageFilters.add(metaDataStorageFilter);
            this.logAddedFilter(metaDataStorageFilter.getClass());
        }
    }

    @Override
    public void storeMetaDataOf(PropertyInformation propertyInformation) {
        this.invokeFilters(propertyInformation);
        DefaultPropertyInformation propertyInformationToStore = new DefaultPropertyInformation();
        PropertyDetails propertyDetails = propertyInformation.getInformation("property_details", PropertyDetails.class);
        this.copyMetaData(propertyInformation, propertyInformationToStore);
        this.getMapForClass(ProxyUtils.getUnproxiedClass(propertyDetails.getBaseObject().getClass())).put(propertyDetails.getProperty(), propertyInformationToStore);
    }

    private void invokeFilters(PropertyInformation propertyInformation) {
        for (MetaDataStorageFilter filter : this.metaDataStorageFilters) {
            filter.filter(propertyInformation);
        }
    }

    @Override
    public MetaDataEntry[] getMetaData(Class targetClass, String targetProperty) {
        PropertyInformation propertyInformation = this.getMapForClass(targetClass).get(targetProperty);
        DefaultPropertyInformation clonedPropertyInformation = new DefaultPropertyInformation();
        this.copyMetaData(propertyInformation, clonedPropertyInformation);
        return clonedPropertyInformation.getMetaDataEntries();
    }

    @Override
    public boolean containsMetaDataFor(Class targetClass, String targetProperty) {
        return this.getMapForClass(targetClass).containsKey(targetProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFilter(MetaDataStorageFilter storageFilter) {
        DefaultMetaDataStorage defaultMetaDataStorage = this;
        synchronized (defaultMetaDataStorage) {
            if (!this.isFilterDenied(storageFilter) && !this.isFilterAlreadyRegistered(storageFilter)) {
                this.metaDataStorageFilters.add(storageFilter);
                this.logAddedFilter(storageFilter.getClass());
            }
        }
    }

    private boolean isFilterDenied(MetaDataStorageFilter storageFilter) {
        return this.deniedMetaDataFilters.contains(this.getStorageFilterClass(storageFilter));
    }

    private boolean isFilterAlreadyRegistered(MetaDataStorageFilter storageFilter) {
        for (MetaDataStorageFilter filter : this.metaDataStorageFilters) {
            if (!filter.getClass().equals(this.getStorageFilterClass(storageFilter))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterFilter(Class<? extends MetaDataStorageFilter> filterClass) {
        MetaDataStorageFilter storageFilter = ClassUtils.tryToInstantiateClass(filterClass);
        DefaultMetaDataStorage defaultMetaDataStorage = this;
        synchronized (defaultMetaDataStorage) {
            this.metaDataStorageFilters.remove(storageFilter);
        }
        this.logRemovedFilter(storageFilter.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void denyFilter(Class<? extends MetaDataStorageFilter> filterClass) {
        DefaultMetaDataStorage defaultMetaDataStorage = this;
        synchronized (defaultMetaDataStorage) {
            for (Class<? extends MetaDataStorageFilter> filterId : this.deniedMetaDataFilters) {
                if (!filterId.equals(filterClass)) continue;
                return;
            }
            this.deniedMetaDataFilters.add(filterClass);
        }
        this.deregisterFilter(filterClass);
    }

    @ToDo(value=Priority.MEDIUM)
    private void copyMetaData(PropertyInformation source, PropertyInformation target) {
        for (MetaDataEntry metaDataEntry : source.getMetaDataEntries()) {
            MetaDataEntry newMetaDataEntry = new MetaDataEntry();
            newMetaDataEntry.setKey(metaDataEntry.getKey());
            newMetaDataEntry.setValue(metaDataEntry.getValue());
            target.addMetaDataEntry(newMetaDataEntry);
        }
    }

    private void logAddedFilter(Class<? extends MetaDataStorageFilter> filterClass) {
        this.logger.info(filterClass.getName() + " added");
    }

    private void logRemovedFilter(Class<? extends MetaDataStorageFilter> filterClass) {
        this.logger.info(filterClass.getName() + " removed");
    }

    private Map<String, PropertyInformation> getMapForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.cachedPropertyInformation.containsKey(key)) {
            this.cachedPropertyInformation.put(key, new NullValueAwareConcurrentHashMap(new NullMarkerPropertyInformation()));
        }
        return this.cachedPropertyInformation.get(key);
    }

    private Class<? extends MetaDataStorageFilter> getStorageFilterClass(MetaDataStorageFilter storageFilter) {
        return ProxyUtils.getUnproxiedClass(storageFilter.getClass(), MetaDataStorageFilter.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullMarkerPropertyInformation
    implements PropertyInformation {
        private NullMarkerPropertyInformation() {
        }

        @Override
        public boolean containsInformation(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getInformation(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getInformation(String key, Class<T> targetClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setInformation(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MetaDataEntry[] getMetaDataEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMetaDataEntry(MetaDataEntry metaDataEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetMetaDataEntries() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object target) {
            return target != null && this.getClass().equals(target.getClass());
        }
    }
}

