/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;

public abstract class ComparatorBase
implements Comparator {
    private Comparator comparator;
    private boolean reverse;

    protected ComparatorBase() {
    }

    protected ComparatorBase(boolean reverse, Comparator comparator) {
        this.comparator = comparator;
        this.reverse = reverse;
    }

    protected ComparatorBase(boolean reverse) {
        this.reverse = reverse;
    }

    protected ComparatorBase(Comparator comparator) {
        this.comparator = comparator;
    }

    protected int internalCompare(Object obj1, Object obj2) {
        int result;
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return this.reverse ? 1 : -1;
            }
            return this.reverse ? -1 : 1;
        }
        if (!obj1.getClass().isInstance(obj2)) {
            throw new ClassCastException(obj1.getClass().getName() + " != " + obj2.getClass().getName());
        }
        if (this.comparator instanceof Collator) {
            CollationKey collationKey1 = ((Collator)this.comparator).getCollationKey(obj1.toString());
            CollationKey collationKey2 = ((Collator)this.comparator).getCollationKey(obj2.toString());
            result = collationKey1.compareTo(collationKey2);
        } else {
            result = this.comparator != null ? this.comparator.compare(obj1, obj2) : (obj1 instanceof String ? ((String)obj1).compareToIgnoreCase((String)obj2) : (obj1 instanceof Comparable ? ((Comparable)obj1).compareTo(obj2) : obj1.toString().compareTo(obj2.toString())));
        }
        return this.reverse ? -result : result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return ((ComparatorBase)o).getComparator().equals(this.comparator);
    }

    public int hashCode() {
        return this.comparator != null ? this.comparator.hashCode() : 0;
    }

    public Comparator getComparator() {
        return this.comparator;
    }
}

