/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.context.Nonce;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.GridSpan;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Overflow;
import org.apache.myfaces.tobago.layout.Position;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Styles;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class StyleRenderer<T extends AbstractUIStyle>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String file = ((AbstractUIStyle)((Object)component)).getFile();
        if (StringUtils.isNotBlank(file)) {
            writer.startElement(HtmlElements.LINK);
            writer.writeAttribute(HtmlAttributes.REL, "stylesheet", false);
            writer.writeAttribute(HtmlAttributes.HREF, file, true);
            writer.writeAttribute(HtmlAttributes.TYPE, "text/css", false);
            writer.endElement(HtmlElements.LINK);
        } else {
            Measure width = ((AbstractUIStyle)((Object)component)).getWidth();
            Measure height = ((AbstractUIStyle)((Object)component)).getHeight();
            Measure minWidth = ((AbstractUIStyle)((Object)component)).getMinWidth();
            Measure minHeight = ((AbstractUIStyle)((Object)component)).getMinHeight();
            Measure maxWidth = ((AbstractUIStyle)((Object)component)).getMaxWidth();
            Measure maxHeight = ((AbstractUIStyle)((Object)component)).getMaxHeight();
            Measure left = ((AbstractUIStyle)((Object)component)).getLeft();
            Measure right = ((AbstractUIStyle)((Object)component)).getRight();
            Measure top = ((AbstractUIStyle)((Object)component)).getTop();
            Measure bottom = ((AbstractUIStyle)((Object)component)).getBottom();
            Measure paddingLeft = ((AbstractUIStyle)((Object)component)).getPaddingLeft();
            Measure paddingRight = ((AbstractUIStyle)((Object)component)).getPaddingRight();
            Measure paddingTop = ((AbstractUIStyle)((Object)component)).getPaddingTop();
            Measure paddingBottom = ((AbstractUIStyle)((Object)component)).getPaddingBottom();
            Measure marginLeft = ((AbstractUIStyle)((Object)component)).getMarginLeft();
            Measure marginRight = ((AbstractUIStyle)((Object)component)).getMarginRight();
            Measure marginTop = ((AbstractUIStyle)((Object)component)).getMarginTop();
            Measure marginBottom = ((AbstractUIStyle)((Object)component)).getMarginBottom();
            Overflow overflowX = ((AbstractUIStyle)((Object)component)).getOverflowX();
            Overflow overflowY = ((AbstractUIStyle)((Object)component)).getOverflowY();
            Display display = ((AbstractUIStyle)((Object)component)).getDisplay();
            Position position = ((AbstractUIStyle)((Object)component)).getPosition();
            TextAlign textAlign = ((AbstractUIStyle)((Object)component)).getTextAlign();
            String backgroundImage = ((AbstractUIStyle)((Object)component)).getBackgroundImage();
            Float flexGrow = ((AbstractUIStyle)((Object)component)).getFlexGrow();
            Float flexShrink = ((AbstractUIStyle)((Object)component)).getFlexShrink();
            Measure flexBasis = ((AbstractUIStyle)((Object)component)).getFlexBasis();
            String gridTemplateColumns = ((AbstractUIStyle)((Object)component)).getGridTemplateColumns();
            String gridTemplateRows = ((AbstractUIStyle)((Object)component)).getGridTemplateRows();
            GridSpan gridColumn = ((AbstractUIStyle)((Object)component)).getGridColumn();
            GridSpan gridRow = ((AbstractUIStyle)((Object)component)).getGridRow();
            if (width != null || height != null || minWidth != null || minHeight != null || maxWidth != null || maxHeight != null || left != null || right != null || top != null || bottom != null || paddingLeft != null || paddingRight != null || paddingTop != null || paddingBottom != null || marginLeft != null || marginRight != null || marginTop != null || marginBottom != null || overflowX != null || overflowY != null || display != null || position != null || textAlign != null || backgroundImage != null || flexGrow != null || flexShrink != null || flexBasis != null || gridTemplateColumns != null || gridTemplateRows != null || gridColumn != null || gridRow != null) {
                writer.startElement(HtmlElements.STYLE);
                writer.writeAttribute(HtmlAttributes.NONCE, Nonce.getNonce(facesContext), false);
                writer.writeIdAttribute(component.getClientId(facesContext));
                String selector = ((AbstractUIStyle)((Object)component)).getSelector();
                if (selector != null) {
                    StyleRenderUtils.writeSelector(writer, selector);
                } else {
                    String parentId = component.getParent().getClientId(facesContext);
                    StyleRenderUtils.writeIdSelector(writer, parentId);
                }
                writer.writeText("{");
                if (width != null) {
                    this.encodeStyle(writer, Styles.width, width.serialize());
                }
                if (height != null) {
                    this.encodeStyle(writer, Styles.height, height.serialize());
                }
                if (minWidth != null) {
                    this.encodeStyle(writer, Styles.minWidth, minWidth.serialize());
                }
                if (minHeight != null) {
                    this.encodeStyle(writer, Styles.minHeight, minHeight.serialize());
                }
                if (maxWidth != null) {
                    this.encodeStyle(writer, Styles.maxWidth, maxWidth.serialize());
                }
                if (maxHeight != null) {
                    this.encodeStyle(writer, Styles.maxHeight, maxHeight.serialize());
                }
                if (left != null) {
                    this.encodeStyle(writer, Styles.left, left.serialize());
                }
                if (right != null) {
                    this.encodeStyle(writer, Styles.right, right.serialize());
                }
                if (top != null) {
                    this.encodeStyle(writer, Styles.top, top.serialize());
                }
                if (bottom != null) {
                    this.encodeStyle(writer, Styles.bottom, bottom.serialize());
                }
                if (paddingLeft != null) {
                    this.encodeStyle(writer, Styles.paddingLeft, paddingLeft.serialize());
                }
                if (paddingRight != null) {
                    this.encodeStyle(writer, Styles.paddingRight, paddingRight.serialize());
                }
                if (paddingTop != null) {
                    this.encodeStyle(writer, Styles.paddingTop, paddingTop.serialize());
                }
                if (paddingBottom != null) {
                    this.encodeStyle(writer, Styles.paddingBottom, paddingBottom.serialize());
                }
                if (marginLeft != null) {
                    this.encodeStyle(writer, Styles.marginLeft, marginLeft.serialize());
                }
                if (marginRight != null) {
                    this.encodeStyle(writer, Styles.marginRight, marginRight.serialize());
                }
                if (marginTop != null) {
                    this.encodeStyle(writer, Styles.marginTop, marginTop.serialize());
                }
                if (marginBottom != null) {
                    this.encodeStyle(writer, Styles.marginBottom, marginBottom.serialize());
                }
                if (overflowX != null) {
                    this.encodeStyle(writer, Styles.overflowX, overflowX.name());
                }
                if (overflowY != null) {
                    this.encodeStyle(writer, Styles.overflowY, overflowY.name());
                }
                if (display != null) {
                    this.encodeStyle(writer, Styles.display, display.encode());
                }
                if (position != null) {
                    this.encodeStyle(writer, Styles.position, position.name());
                }
                if (textAlign != null) {
                    this.encodeStyle(writer, Styles.textAlign, textAlign.name());
                }
                if (backgroundImage != null) {
                    this.encodeStyle(writer, Styles.backgroundImage, backgroundImage);
                }
                if (flexGrow != null) {
                    this.encodeStyle(writer, Styles.flexGrow, String.valueOf(flexGrow));
                }
                if (flexShrink != null) {
                    this.encodeStyle(writer, Styles.flexShrink, String.valueOf(flexShrink));
                }
                if (flexBasis != null) {
                    this.encodeStyle(writer, Styles.flexBasis, flexBasis.serialize());
                }
                if (gridTemplateColumns != null) {
                    this.encodeStyle(writer, Styles.gridTemplateColumns, gridTemplateColumns);
                    this.encodeStyle(writer, "-ms-grid-columns", gridTemplateColumns);
                }
                if (gridTemplateRows != null) {
                    this.encodeStyle(writer, Styles.gridTemplateRows, gridTemplateRows);
                    this.encodeStyle(writer, "-ms-grid-rows", gridTemplateRows);
                }
                if (gridColumn != null) {
                    this.encodeStyle(writer, Styles.gridColumn, gridColumn.encode());
                    this.encodeStyle(writer, "-ms-grid-column", gridColumn.getStart());
                    this.encodeStyle(writer, "-ms-grid-column-span", gridColumn.getSpan());
                }
                if (gridRow != null) {
                    this.encodeStyle(writer, Styles.gridRow, gridRow.encode());
                    this.encodeStyle(writer, "-ms-grid-row", gridRow.getStart());
                    this.encodeStyle(writer, "-ms-grid-row-span", gridRow.getSpan());
                }
                writer.writeText("}");
                writer.endElement(HtmlElements.STYLE);
            }
        }
    }

    private void encodeStyle(TobagoResponseWriter writer, Styles name, String value) throws IOException {
        writer.writeText(name.getCssName());
        writer.writeText(":");
        switch (name) {
            case backgroundImage: {
                writer.writeText("url(");
                writer.write("'");
                writer.writeText(value);
                writer.write("'");
                writer.writeText(")");
                break;
            }
            default: {
                writer.writeText(value);
            }
        }
        writer.writeText(";");
    }

    private void encodeStyle(TobagoResponseWriter writer, String name, String value) throws IOException {
        writer.writeText(name);
        writer.writeText(":");
        writer.writeText(value);
        writer.writeText(";");
    }

    private void encodeStyle(TobagoResponseWriter writer, String name, Integer value) throws IOException {
        if (value != null) {
            writer.writeText(name);
            writer.writeText(":");
            writer.writeText(value.toString());
            writer.writeText(";");
        }
    }
}

