/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.bridge;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeNotAFacesRequestException;
import javax.portlet.faces.BridgeUninitializedException;
import javax.portlet.faces.annotation.BridgePreDestroy;
import javax.portlet.faces.annotation.BridgeRequestScopeAttributeAdded;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.myfaces.portlet.faces.bridge.wrapper.BridgeRenderRequestWrapper;
import org.apache.myfaces.portlet.faces.el.PortletELContextImpl;
import org.apache.myfaces.portlet.faces.util.QueryString;
import org.apache.myfaces.portlet.faces.util.config.FacesConfigurationProcessor;
import org.apache.myfaces.portlet.faces.util.config.WebConfigurationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeImpl
implements Bridge,
ELContextListener,
PhaseListener,
ServletRequestAttributeListener {
    private static final long serialVersionUID = 5807626987246270989L;
    public static final String UPDATED_VIEW_STATE_PARAM = "org.apache.myfaces.portlet.faces.updatedViewStateParam";
    public static final String REDIRECT_VIEWPARAMS = "org.apache.myfaces.portlet.faces.redirectViewParams";
    public static final String RENDER_REDIRECT_VIEWPARAMS = "org.apache.myfaces.portlet.faces.renderRedirectViewParams";
    public static final String PORTLET_NAME_ATTRIBUTE = "org.apache.myfaces.portlet.faces.portletName";
    public static final String VIEWID_QUERYSTRING_ATTRIBUTE = "org.apache.myfaces.portlet.faces.viewIdQueryString";
    private static final String REQUEST_SCOPE_LOCK = "org.apache.myfaces.portlet.faces.requestScopeLock";
    private static final String REQUEST_SCOPE_MAP = "org.apache.myfaces.portlet.faces.requestScopeMap";
    private static final String REQUEST_SCOPE_LISTENER = "org.apache.myfaces.portlet.faces.requestScopeWatch";
    private static final String REQUEST_SCOPE_ACTIVE = "org.apache.myfaces.portlet.faces.includeInScope.requestScopeActive";
    public static final String FACES_VIEWROOT = "org.apache.myfaces.portlet.faces.includeInScope.facesViewRoot";
    private static final String FACES_MESSAGES = "org.apache.myfaces.portlet.faces.includeInScope.facesMessages";
    private static final String REQUEST_PARAMETERS = "org.apache.myfaces.portlet.faces.includeInScope.requestParameters";
    public static final String PREEXISTING_ATTRIBUTE_NAMES = "org.apache.myfaces.portlet.faces.preExistingAttributeNames";
    private static final String REQUEST_SCOPE_ID_RENDER_PARAM = "__jpfbReqScopeId";
    private static final String NULL_VIEW_STATE_PARAM_VALUE = "org.apache.myfaces.portlet.faces.nullViewState";
    private static final String CACHED_VIEWROOT_LOCALE = "org.apache.myfaces.portlet.faces.cachedViewRootLocale";
    private static final int DEFAULT_MAX_MANAGED_REQUEST_SCOPES = 100;
    private Boolean mPreserveActionParams = Boolean.FALSE;
    private List<String> mExcludedRequestAttributes = null;
    private PortletConfig mPortletConfig = null;
    private FacesContextFactory mFacesContextFactory = null;
    private LifecycleFactory mLifecycleFactory = null;
    private String mLifecycleId = null;
    private List<String> mFacesMappings = null;
    private boolean mInitialized = false;
    private Map<String, String> mDefaultViewIdMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PortletConfig config) throws BridgeException {
        if (this.mInitialized) {
            throw new BridgeException("Bridge already initialized.");
        }
        this.mPortletConfig = config;
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        this.mPreserveActionParams = (Boolean)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "preserveActionParams");
        this.mExcludedRequestAttributes = (List)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "excludedRequestAttributes");
        this.mExcludedRequestAttributes = this.mExcludedRequestAttributes != null ? new ArrayList<String>(this.mExcludedRequestAttributes) : new ArrayList<String>(5);
        this.readExcludedAttributesFromFacesConfig(portletContext, this.mExcludedRequestAttributes);
        PortletContext portletContext2 = portletContext;
        synchronized (portletContext2) {
            Object lock = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
            if (lock == null) {
                portletContext.setAttribute(REQUEST_SCOPE_LOCK, new Object());
            }
        }
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().addELContextListener((ELContextListener)this);
        WebConfigurationProcessor webConfig = new WebConfigurationProcessor(portletContext);
        this.mFacesMappings = webConfig.getFacesMappings();
        if (this.mFacesMappings == null || this.mFacesMappings.size() == 0) {
            throw new BridgeException("BridgeImpl.init(): unable to determine Faces servlet web.xml mapping.");
        }
        this.mDefaultViewIdMap = (Map)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "defaultViewIdMap");
        this.mInitialized = true;
    }

    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        if (!this.mInitialized) {
            throw new BridgeUninitializedException();
        }
        if (request == null || response == null) {
            throw new NullPointerException("request or response parameter is null");
        }
        if (request.getParameter("_jsfBridgeNonFacesView") != null) {
            throw new BridgeNotAFacesRequestException("NonFaces target = " + request.getParameter("_jsfBridgeNonFacesView"));
        }
        StringBuffer keyBuf = new StringBuffer(30);
        String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
        if (request.getPortletSession().getAttribute(key) == null) {
            this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
        }
        request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.ACTION_PHASE);
        request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
        if (this.mFacesMappings != null) {
            request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
        }
        List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
        FacesContext context = null;
        String scopeId = null;
        try {
            Lifecycle lifecycle = this.getLifecycle();
            context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, null);
            lifecycle.execute(context);
            if (!context.getResponseComplete()) {
                this.finalizeActionResponse(context);
                Boolean noScope = (Boolean)request.getAttribute("org.apache.myfaces.portlet.faces.noScope");
                if (noScope == null || noScope.equals(Boolean.FALSE)) {
                    scopeId = this.initBridgeRequestScope(request, response);
                    this.saveFacesView(context);
                    this.saveActionParams(context);
                    this.saveBridgeRequestScopeData(context, scopeId, preExistingAttributes);
                }
            }
        }
        catch (Exception e2) {
            BridgeException e2;
            this.mPortletConfig.getPortletContext().log("Exception thrown in doFacesRequest:action", (Throwable)e2);
            if (!(e2 instanceof BridgeException)) {
                e2 = new BridgeException((Throwable)e2);
            }
            throw (BridgeException)e2;
        }
        finally {
            this.dumpScopeId(scopeId, "ACTION_PHASE");
            if (context != null) {
                context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
                context.release();
            }
            request.removeAttribute("javax.portlet.faces.phase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpScopeId(String scopeId, String phase) {
        PortletContext ctx = this.mPortletConfig.getPortletContext();
        ctx.log("dumpScopeId: " + phase);
        Object object = ctx.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)ctx.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                ctx.log("There are No saved scoped.  Can't match: " + scopeId);
                return;
            }
            Map m = (Map)requestScopeMap.get(scopeId);
            if (m == null) {
                ctx.log("Can't match scope: " + scopeId);
                return;
            }
            Set set = m.entrySet();
            Iterator i = set.iterator();
            ctx.log("Elements in scope: " + scopeId);
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ctx.log("     " + (String)entry.getKey());
            }
            ctx.log("end dumpScopeId");
        }
    }

    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        StringBuffer sb;
        String modeCheck;
        if (!this.mInitialized) {
            throw new BridgeUninitializedException();
        }
        if (request == null || response == null) {
            throw new NullPointerException("request or response parameter is null");
        }
        if (request.getParameter("_jsfBridgeNonFacesView") != null) {
            throw new BridgeNotAFacesRequestException("NonFaces target = " + request.getParameter("_jsfBridgeNonFacesView"));
        }
        StringBuffer keyBuf = new StringBuffer(30);
        String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
        if (request.getPortletSession().getAttribute(key) == null) {
            this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
        }
        String scopeId = null;
        boolean restoredScope = false;
        request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.RENDER_PHASE);
        request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
        if (this.mFacesMappings != null) {
            request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
        }
        List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
        boolean clientDirectedView = request.getAttribute("javax.portlet.faces.viewId") != null || request.getAttribute("javax.portlet.faces.viewPath") != null;
        QueryString redirectParams = (QueryString)request.getPortletSession(true).getAttribute(RENDER_REDIRECT_VIEWPARAMS);
        boolean modeChanged = this.hasModeChanged(request, redirectParams);
        if (redirectParams != null && (clientDirectedView || modeChanged)) {
            redirectParams = null;
            request.getPortletSession().removeAttribute(RENDER_REDIRECT_VIEWPARAMS);
        }
        if (redirectParams == null && !clientDirectedView && (scopeId = request.getParameter(REQUEST_SCOPE_ID_RENDER_PARAM)) != null && scopeId.indexOf(modeCheck = (sb = new StringBuffer(10)).append(":").append(request.getPortletMode().toString()).append(":").toString()) < 0) {
            scopeId = null;
        }
        restoredScope = this.restoreBridgeRequestScopeData((PortletRequest)request, scopeId);
        FacesContext context = null;
        try {
            Lifecycle lifecycle = this.getLifecycle();
            context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, redirectParams);
            ExternalContext extCtx = context.getExternalContext();
            RenderRequest extRequest = (RenderRequest)extCtx.getRequest();
            if (restoredScope) {
                extRequest = this.restoreActionParams(context);
                this.restoreFacesView(context, scopeId);
            }
            if (extCtx.getResponseContentType() == null) {
                response.setContentType(extRequest.getResponseContentType());
            }
            if (extCtx.getRequestParameterValuesMap().containsKey("javax.faces.ViewState")) {
                extCtx.getRequestMap().put("javax.portlet.faces.isPostback", Boolean.TRUE);
            }
            this.doFacesRender(request, response, context, lifecycle, scopeId);
            context = FacesContext.getCurrentInstance();
            extCtx = context.getExternalContext();
        }
        catch (Exception e2) {
            BridgeException e2;
            context = FacesContext.getCurrentInstance();
            this.mPortletConfig.getPortletContext().log("Exception thrown in doFacesRequest:render: " + e2.getMessage() + " : " + e2.toString());
            if (!(e2 instanceof BridgeException)) {
                e2 = new BridgeException((Throwable)e2);
            }
            throw (BridgeException)e2;
        }
        finally {
            this.dumpScopeId(scopeId, "RENDER_PHASE");
            if (context != null) {
                context.release();
            }
            request.removeAttribute("javax.portlet.faces.phase");
        }
    }

    private boolean hasModeChanged(RenderRequest request, QueryString renderRedirectParams) {
        String mode;
        int i;
        boolean hasModeChanged = false;
        String targetViewId = null;
        targetViewId = renderRedirectParams == null ? request.getParameter("__jpfbJSFTARGET") : renderRedirectParams.getParameter("__jpfbJSFTARGET");
        if (targetViewId != null && (i = targetViewId.indexOf(58)) >= 0 && !(mode = targetViewId.substring(0, i)).equalsIgnoreCase(request.getPortletMode().toString())) {
            hasModeChanged = true;
        }
        return hasModeChanged;
    }

    private void doFacesRender(RenderRequest request, RenderResponse response, FacesContext context, Lifecycle lifecycle, String scopeId) throws BridgeException, BridgeUninitializedException, NullPointerException {
        boolean redirectedDuringRender = false;
        try {
            lifecycle.addPhaseListener((PhaseListener)this);
            lifecycle.execute(context);
        }
        catch (Exception e2) {
            BridgeException e2;
            if (!(e2 instanceof BridgeException)) {
                e2 = new BridgeException((Throwable)e2);
            }
            throw (BridgeException)e2;
        }
        finally {
            lifecycle.removePhaseListener((PhaseListener)this);
        }
        QueryString redirectParams = (QueryString)context.getExternalContext().getRequestMap().get(REDIRECT_VIEWPARAMS);
        if (redirectParams == null) {
            lifecycle.render(context);
        } else {
            this.redirectRender(context, lifecycle, request, response, redirectParams);
            context = FacesContext.getCurrentInstance();
            redirectedDuringRender = true;
        }
        redirectParams = (QueryString)context.getExternalContext().getRequestMap().get(REDIRECT_VIEWPARAMS);
        if (redirectParams != null) {
            this.redirectRender(context, lifecycle, request, response, redirectParams);
            context = FacesContext.getCurrentInstance();
            redirectedDuringRender = true;
        }
        if (scopeId != null) {
            if (!redirectedDuringRender) {
                this.updateViewInfo(context, scopeId);
            } else {
                this.removeRequestScopes(scopeId);
            }
        }
    }

    public void destroy() {
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().removeELContextListener((ELContextListener)this);
        this.removeRequestScopes(this.qualifyScopeId(this.mPortletConfig.getPortletName(), null, null, null));
        this.mPortletConfig = null;
    }

    public void contextCreated(ELContextEvent ece) {
        ELContext elContext = ece.getELContext();
        String portletName = (String)((FacesContext)elContext.getContext(FacesContext.class)).getExternalContext().getRequestMap().get(PORTLET_NAME_ATTRIBUTE);
        if (portletName != null && portletName.equals(this.mPortletConfig.getPortletName())) {
            PortletELContextImpl portletELContext;
            if (elContext instanceof PortletELContextImpl) {
                portletELContext = (PortletELContextImpl)elContext;
                portletELContext.setFacesResolved(true);
                portletELContext.setPortletConfig(this.mPortletConfig);
            } else {
                portletELContext = new PortletELContextImpl(elContext.getELResolver());
                portletELContext.setFacesResolved(false);
            }
            elContext.putContext(PortletELContextImpl.class, (Object)portletELContext);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent srae) {
        Bridge.PortletPhase phase = (Bridge.PortletPhase)srae.getServletRequest().getAttribute("javax.portlet.faces.phase");
        if (phase != null && phase == Bridge.PortletPhase.ACTION_PHASE && srae.getServletRequest().getAttribute(REQUEST_SCOPE_ACTIVE) != null) {
            this.notifyPreDestroy(srae.getValue());
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent srae) {
        Bridge.PortletPhase phase = (Bridge.PortletPhase)srae.getServletRequest().getAttribute("javax.portlet.faces.phase");
        if (phase != null && phase == Bridge.PortletPhase.ACTION_PHASE && srae.getServletRequest().getAttribute(REQUEST_SCOPE_ACTIVE) != null) {
            this.notifyPreDestroy(srae.getValue());
        }
    }

    private void initViewHistoryDefaults(PortletSession session, Map<String, String> viewIdDefaultMap) {
        Set<String> keys = viewIdDefaultMap.keySet();
        for (String mode : keys) {
            String modeView = viewIdDefaultMap.get(mode);
            if (modeView == null || modeView.length() == 0) continue;
            String defaultViewId = this.encodeMode(mode, modeView);
            StringBuffer key = new StringBuffer(100);
            session.setAttribute(key.append("javax.portlet.faces.viewIdHistory").append('.').append(mode).toString(), (Object)defaultViewId);
        }
    }

    private String encodeMode(String mode, String viewId) {
        StringBuffer sb = new StringBuffer(viewId.length() + 30);
        int queryStart = viewId.indexOf(63);
        if (queryStart < 0) {
            return sb.append(viewId).append('?').append("javax.portlet.faces.PortletMode").append('=').append(mode).toString();
        }
        QueryString qs = new QueryString(viewId.substring(queryStart + 1), "UTF8");
        qs.setParameter("javax.portlet.faces.PortletMode", mode);
        return sb.append(viewId.substring(0, queryStart + 1)).append(qs.toString()).toString();
    }

    private RenderRequest wrapRequestToRedirect(RenderRequest request, QueryString redirectParams) {
        redirectParams.removeParameter("javax.portlet.faces.DirectLink");
        redirectParams.removeParameter("javax.portlet.faces.PortletMode");
        redirectParams.removeParameter("javax.portlet.faces.WindowState");
        redirectParams.removeParameter("javax.portlet.faces.Secure");
        LinkedHashMap<String, String[]> paramMap = new LinkedHashMap<String, String[]>(redirectParams.numParameters());
        Enumeration<String> nameEnum = redirectParams.getParameterNames();
        while (nameEnum != null && nameEnum.hasMoreElements()) {
            String name = nameEnum.nextElement();
            Enumeration<String> valuesEnum = redirectParams.getParameterValues(name);
            ArrayList<String> values = new ArrayList<String>();
            while (valuesEnum != null && valuesEnum.hasMoreElements()) {
                values.add(valuesEnum.nextElement());
            }
            paramMap.put(name, values.toArray(new String[values.size()]));
        }
        return new BridgeRenderRequestWrapper(request, paramMap, false);
    }

    private void redirectRender(FacesContext context, Lifecycle lifecycle, RenderRequest request, RenderResponse response, QueryString redirectParams) {
        context.release();
        this.getRequestAttributes((PortletRequest)request);
        context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, redirectParams);
        context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
        this.doFacesRender(request, response, context, lifecycle, null);
        context = FacesContext.getCurrentInstance();
        if (context.getExternalContext().getSessionMap().get(RENDER_REDIRECT_VIEWPARAMS) == null) {
            context.getExternalContext().getSessionMap().put(RENDER_REDIRECT_VIEWPARAMS, redirectParams);
        }
    }

    private FacesContextFactory getFacesContextFactory() throws BridgeException {
        try {
            if (this.mFacesContextFactory == null) {
                this.mFacesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            }
            return this.mFacesContextFactory;
        }
        catch (FacesException e) {
            throw new BridgeException((Throwable)e);
        }
    }

    private FacesContext getFacesContext(PortletRequest request, PortletResponse response, Lifecycle lifecycle, QueryString redirectParams) throws FacesException {
        FacesContext context = null;
        context = this.getFacesContextFactory().getFacesContext((Object)this.mPortletConfig.getPortletContext(), (Object)request, (Object)response, lifecycle);
        if (redirectParams != null) {
            context.getExternalContext().setRequest((Object)this.wrapRequestToRedirect((RenderRequest)request, redirectParams));
        }
        return context;
    }

    private Lifecycle getLifecycle() throws BridgeException {
        try {
            if (this.mLifecycleFactory == null) {
                this.mLifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
                this.mLifecycleId = this.mPortletConfig.getPortletContext().getInitParameter("javax.faces.LIFECYCLE_ID");
                if (this.mLifecycleId == null) {
                    this.mLifecycleId = "DEFAULT";
                }
            }
            return this.mLifecycleFactory.getLifecycle(this.mLifecycleId);
        }
        catch (FacesException e) {
            throw new BridgeException((Throwable)e);
        }
    }

    private void saveFacesView(FacesContext context) {
        this.saveFacesMessageState(context);
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(FACES_VIEWROOT, context.getViewRoot());
    }

    private void restoreFacesView(FacesContext context, String scopeId) {
        Map requestMap = context.getExternalContext().getRequestMap();
        UIViewRoot viewRoot = (UIViewRoot)requestMap.get(FACES_VIEWROOT);
        if (viewRoot != null) {
            context.setViewRoot(viewRoot);
            requestMap.remove(FACES_VIEWROOT);
        }
    }

    private void saveActionParams(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Map requestMap = ec.getRequestMap();
        Map requestParameterMap = ec.getRequestParameterValuesMap();
        if (this.mPreserveActionParams.equals(Boolean.FALSE)) {
            HashMap<String, Object> m = new HashMap<String, Object>(1);
            if (requestParameterMap != null && requestParameterMap.containsKey("javax.faces.ViewState")) {
                m.put("javax.faces.ViewState", requestParameterMap.get("javax.faces.ViewState"));
            } else {
                m.put("javax.faces.ViewState", new String[]{NULL_VIEW_STATE_PARAM_VALUE});
            }
            requestMap.put(REQUEST_PARAMETERS, m);
        } else {
            HashMap mutableParams = new HashMap(requestParameterMap);
            requestMap.put(REQUEST_PARAMETERS, mutableParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewInfo(FacesContext context, String scopeId) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return;
            }
            Map scopeMap = (Map)requestScopeMap.get(scopeId);
            if (scopeMap == null) {
                return;
            }
            HashMap<String, String[]> requestParams = (HashMap<String, String[]>)scopeMap.get(REQUEST_PARAMETERS);
            if (requestParams == null) {
                requestParams = new HashMap<String, String[]>(1);
                scopeMap.put(REQUEST_PARAMETERS, requestParams);
            }
            String[] values = new String[1];
            String updatedViewStateParam = (String)context.getExternalContext().getRequestMap().get(UPDATED_VIEW_STATE_PARAM);
            if (updatedViewStateParam != null) {
                values[0] = updatedViewStateParam;
                requestParams.put("javax.faces.ViewState", values);
            }
            scopeMap.remove(FACES_VIEWROOT);
        }
    }

    private LRUMap createRequestScopeMap(PortletContext portletContext) {
        int managedScopes = 100;
        String managedScopesSetting = portletContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
        if (managedScopesSetting != null) {
            managedScopes = Integer.parseInt(managedScopesSetting);
        }
        return new LRUMap(managedScopes);
    }

    private RenderRequest restoreActionParams(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Map m = (Map)ec.getRequestMap().get(REQUEST_PARAMETERS);
        RenderRequest wrapped = (RenderRequest)ec.getRequest();
        if (m != null && !m.isEmpty()) {
            wrapped = new BridgeRenderRequestWrapper(wrapped, m);
            ec.setRequest((Object)wrapped);
        }
        return wrapped;
    }

    public void saveFacesMessageState(FacesContext context) {
        Iterator clientIds = context.getClientIdsWithMessages();
        if (clientIds.hasNext()) {
            FacesMessageState state = new FacesMessageState();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator messages = context.getMessages(clientId);
                while (messages.hasNext()) {
                    state.addMessage(clientId, (FacesMessage)messages.next());
                }
            }
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(FACES_MESSAGES, state);
        }
    }

    private void restoreFacesMessageState(FacesContext context) {
        Map map;
        FacesMessageState state;
        if (context.getExternalContext().getRequest() instanceof RenderRequest && (state = (FacesMessageState)(map = context.getExternalContext().getRequestMap()).get(FACES_MESSAGES)) != null) {
            for (String clientId : state.getClientIds()) {
                for (FacesMessage message : state.getMessages(clientId)) {
                    context.addMessage(clientId, message);
                }
            }
        }
    }

    private String initBridgeRequestScope(ActionRequest request, ActionResponse response) {
        UID uid = new UID();
        String requestScopeId = this.qualifyScopeId(this.mPortletConfig.getPortletName(), request.getPortletSession(true).getId(), request.getPortletMode().toString(), uid.toString());
        response.setRenderParameter(REQUEST_SCOPE_ID_RENDER_PARAM, requestScopeId);
        return requestScopeId;
    }

    private void saveBridgeRequestScopeData(FacesContext context, String scopeId, List<String> preExistingList) {
        Map m = context.getExternalContext().getRequestMap();
        m.put(REQUEST_SCOPE_ACTIVE, Boolean.TRUE);
        this.putBridgeRequestScopeData(scopeId, this.copyRequestMap(m, preExistingList));
        this.watchScope(context, scopeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBridgeRequestScopeData(String scopeId, Map<String, Object> o) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                requestScopeMap = this.createRequestScopeMap(portletContext);
                portletContext.setAttribute(REQUEST_SCOPE_MAP, (Object)requestScopeMap);
            }
            requestScopeMap.put(scopeId, o);
        }
    }

    private Map<String, Object> copyRequestMap(Map<String, Object> m, List<String> preExistingList) {
        HashMap<String, Object> copy = new HashMap<String, Object>(m.size());
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (this.isExcludedFromBridgeRequestScope(key, value = entry.getValue(), preExistingList)) continue;
            copy.put(key, value);
            this.notifyAttributeAdded(value);
        }
        return copy;
    }

    private List<String> getRequestAttributes(PortletRequest request) {
        ArrayList<String> requestAttributeNames = Collections.list(request.getAttributeNames());
        if (requestAttributeNames != null) {
            request.setAttribute(PREEXISTING_ATTRIBUTE_NAMES, requestAttributeNames);
        }
        return requestAttributeNames;
    }

    private boolean isExcludedFromBridgeRequestScope(String key, Object value, List<String> preExistingList) {
        return value != null && value.getClass().getAnnotation(ExcludeFromManagedRequestScope.class) != null || preExistingList != null && preExistingList.contains(key) || this.isPreDefinedExcludedObject(key, value) || this.isConfiguredExcludedAttribute(key);
    }

    private boolean isPreDefinedExcludedObject(String s, Object o) {
        if (o != null && (o instanceof PortletConfig || o instanceof PortletContext || o instanceof PortletRequest || o instanceof PortletResponse || o instanceof PortletSession || o instanceof PortletPreferences || o instanceof PortalContext || o instanceof FacesContext || o instanceof ExternalContext || o instanceof ServletConfig || o instanceof ServletContext || o instanceof ServletRequest || o instanceof ServletResponse || o instanceof HttpSession)) {
            return true;
        }
        return this.isInNamespace(s, "javax.portlet.") || this.isInNamespace(s, "javax.portlet.faces.") || this.isInNamespace(s, "javax.faces.") || this.isInNamespace(s, "javax.servlet.") || this.isInNamespace(s, "javax.servlet.include.") || this.isInNamespace(s, "org.apache.myfaces.portlet.faces.") || s.startsWith("org.apache.myfaces.portlet.faces.context.");
    }

    private boolean isConfiguredExcludedAttribute(String s) {
        if (this.mExcludedRequestAttributes == null) {
            return false;
        }
        if (this.mExcludedRequestAttributes.contains(s)) {
            return true;
        }
        for (String exclude : this.mExcludedRequestAttributes) {
            if (!exclude.endsWith("*") || !this.isInNamespace(s, exclude.substring(0, exclude.length() - 1))) continue;
            return true;
        }
        return false;
    }

    private boolean isInNamespace(String s, String namespace) {
        if (s.startsWith(namespace)) {
            s = s.substring(0, s.lastIndexOf(46) + 1);
            return s.equals(namespace);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restoreBridgeRequestScopeData(PortletRequest request, String scopeId) throws BridgeException {
        Map m;
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        if (scopeId == null) {
            return false;
        }
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return false;
            }
            m = (Map)requestScopeMap.get(scopeId);
            if (m == null) {
                return false;
            }
        }
        Set s = m.entrySet();
        for (Map.Entry e : s) {
            request.setAttribute((String)e.getKey(), e.getValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromBridgeRequestScopeData(FacesContext context, String scopeId, String key) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Map m = null;
        if (scopeId == null) {
            return false;
        }
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return false;
            }
            m = (Map)requestScopeMap.get(scopeId);
            if (m != null) {
                return m.remove(key) != null;
            }
        }
        return false;
    }

    private String qualifyScopeId(String portletId, String sessionId, String mode, String scopeId) {
        if (portletId == null) {
            portletId = this.mPortletConfig.getPortletName();
        }
        StringBuffer sb = new StringBuffer(portletId);
        sb.append(':');
        if (sessionId != null) {
            sb.append(sessionId);
            sb.append(':');
            if (mode != null) {
                sb.append(mode);
                sb.append(':');
                if (scopeId != null) {
                    sb.append(scopeId);
                }
            }
        }
        return sb.toString();
    }

    private void watchScope(FacesContext context, String scopeId) {
        RequestScopeListener scopeListener;
        PortletSession session = (PortletSession)context.getExternalContext().getSession(true);
        if (session != null && (scopeListener = (RequestScopeListener)session.getAttribute(REQUEST_SCOPE_LISTENER)) == null) {
            session.setAttribute(REQUEST_SCOPE_LISTENER, (Object)new RequestScopeListener(this.qualifyScopeId(this.mPortletConfig.getPortletName(), session.getId(), null, null)));
        }
    }

    private void finalizeActionResponse(FacesContext context) throws IOException {
        context.getExternalContext().getRequestMap().put("org.apache.myfaces.portlet.faces.noScope", Boolean.FALSE);
        String viewId = context.getViewRoot().getViewId();
        String qs = (String)context.getViewRoot().getAttributes().remove(VIEWID_QUERYSTRING_ATTRIBUTE);
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        String viewURL = viewHandler.getActionURL(context, viewId);
        if (qs != null && qs.length() > 1) {
            viewURL = viewURL.indexOf(63) < 0 ? viewURL.concat(qs) : viewURL + "&" + qs.substring(1);
        }
        context.getExternalContext().encodeActionURL(viewURL);
    }

    private void notifyPreDestroy(Map<String, Object> scope) {
        Set<Map.Entry<String, Object>> s = scope.entrySet();
        Iterator<Map.Entry<String, Object>> i = s.iterator();
        while (i.hasNext()) {
            this.notifyPreDestroy(i.next().getValue());
        }
    }

    private void notifyAttributeAdded(Object o) {
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(BridgeRequestScopeAttributeAdded.class)) continue;
            try {
                methods[i].invoke(o, null);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void notifyPreDestroy(Object o) {
        Method[] methods = o.getClass().getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (!methods[m].isAnnotationPresent(BridgePreDestroy.class)) continue;
            try {
                methods[m].invoke(o, null);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequestScopes(String scopePrefix) {
        if (scopePrefix == null || this.mPortletConfig == null) {
            return;
        }
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object lock = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        if (lock == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap != null) {
                Iterator iterator = requestScopeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String scopeId = (String)iterator.next();
                    if (scopeId == null || !scopeId.startsWith(scopePrefix)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void readExcludedAttributesFromFacesConfig(PortletContext context, List<String> excludedAttributes) {
        FacesConfigurationProcessor processor = new FacesConfigurationProcessor(context);
        List<String> list = processor.getExcludedAttributes();
        if (list == null) {
            return;
        }
        ListIterator<String> i = list.listIterator();
        while (i.hasNext()) {
            String attr = i.next();
            if (excludedAttributes.contains(attr)) continue;
            excludedAttributes.add(attr);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
        Locale l;
        UIViewRoot viewRoot;
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance()) {
            return;
        }
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW && (viewRoot = context.getViewRoot()) != null && (l = viewRoot.getLocale()) != null) {
            context.getExternalContext().getRequestMap().put(CACHED_VIEWROOT_LOCALE, l);
        }
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance()) {
            return;
        }
        String pName = (String)context.getExternalContext().getRequestMap().get(PORTLET_NAME_ATTRIBUTE);
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            UIViewRoot viewRoot;
            Locale l = (Locale)context.getExternalContext().getRequestMap().get(CACHED_VIEWROOT_LOCALE);
            if (l != null && (viewRoot = context.getViewRoot()) != null) {
                viewRoot.setLocale(l);
            }
            this.restoreFacesMessageState(context);
            context.renderResponse();
        }
    }

    private final class RequestScopeListener
    implements HttpSessionBindingListener {
        String mScopePrefix = null;

        public RequestScopeListener(String scopePrefix) {
            this.mScopePrefix = scopePrefix;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            BridgeImpl.this.removeRequestScopes(this.mScopePrefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FacesMessageState
    implements Serializable {
        private static final long serialVersionUID = 8438070672451887050L;
        private LinkedHashMap<String, List<FacesMessage>> mMessages = new LinkedHashMap();

        private FacesMessageState() {
        }

        public void addMessage(String clientId, FacesMessage message) {
            List<FacesMessage> list = this.mMessages.get(clientId);
            if (list == null) {
                list = new ArrayList<FacesMessage>();
                this.mMessages.put(clientId, list);
            }
            list.add(message);
        }

        public List<FacesMessage> getMessages(String clientId) {
            List<FacesMessage> list = this.mMessages.get(clientId);
            if (list != null) {
                return list;
            }
            return Collections.emptyList();
        }

        public Set<String> getClientIds() {
            return this.mMessages.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LRUMap
    extends LinkedHashMap<String, Map<String, Object>> {
        private static final long serialVersionUID = 4372455368577337965L;
        private int mMaxCapacity;

        public LRUMap(int maxCapacity) {
            super(maxCapacity, 1.0f, true);
            this.mMaxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Map<String, Object>> eldest) {
            if (this.size() > this.mMaxCapacity) {
                this.remove(eldest.getKey());
            }
            return false;
        }

        public Map<String, Object> remove(String key) {
            BridgeImpl.this.dumpScopeId(key, "RemovePhase");
            Map o = (Map)super.remove(key);
            if (o != null) {
                BridgeImpl.this.notifyPreDestroy(o);
            }
            return o;
        }

        @Override
        public Map<String, Object> put(String key, Map<String, Object> value) {
            Map<String, Object> o = super.put(key, value);
            if (o != null) {
                BridgeImpl.this.notifyPreDestroy(o);
            }
            return o;
        }
    }
}

