/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.portlet.faces.Bridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestHeaders {
    private PortletRequest mPortletRequest = null;
    private List<String> mHeaderNames = null;
    private Map<String, List<String>> mHeaders = null;

    public PortletRequestHeaders(PortletRequest request) {
        this.mPortletRequest = request;
    }

    public String getHeader(String name) {
        this.initHeaderMap();
        List<String> headerVals = this.mHeaders.get(name.toUpperCase());
        return headerVals == null ? null : headerVals.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        this.initHeaderMap();
        List<String> headerVals = this.mHeaders.get(name.toUpperCase());
        if (headerVals == null) {
            headerVals = Collections.emptyList();
        }
        return Collections.enumeration(headerVals);
    }

    public Enumeration<String> getHeaderNames() {
        this.initHeaderMap();
        return Collections.enumeration(this.mHeaderNames);
    }

    protected boolean initHeaderMap() {
        if (this.mHeaders != null) {
            return false;
        }
        this.mHeaders = Collections.emptyMap();
        this.mHeaderNames = Collections.emptyList();
        Enumeration props = this.mPortletRequest.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Enumeration values = this.mPortletRequest.getProperties(name);
            while (values != null && values.hasMoreElements()) {
                this.addProperty(name, (String)values.nextElement());
            }
        }
        Object property = null;
        this.ensurePortletAcceptHeader();
        this.ensurePortletAcceptLanguage();
        switch ((Bridge.PortletPhase)this.mPortletRequest.getAttribute("javax.portlet.faces.phase")) {
            case ACTION_PHASE: 
            case RESOURCE_PHASE: {
                this.ensurePortletContentType();
                this.ensurePortletContentLength();
                break;
            }
            case RENDER_PHASE: 
            case EVENT_PHASE: {
                this.mHeaders.remove("CONTENT-TYPE");
                this.mHeaderNames.remove("CONTENT-TYPE");
                this.mHeaders.remove("CONTENT-LENGTH");
                this.mHeaderNames.remove("CONTENT-LENGTH");
            }
        }
        return true;
    }

    private boolean containsHeader(List<String> headerNames, String key) {
        for (String name : headerNames) {
            if (!key.toUpperCase().equals(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private void ensurePortletAcceptHeader() {
        this.mHeaders.remove("ACCEPT");
        this.mHeaderNames.remove("ACCEPT");
        Enumeration contentTypes = this.mPortletRequest.getResponseContentTypes();
        StringBuilder property = new StringBuilder(64);
        boolean addComma = false;
        while (contentTypes.hasMoreElements()) {
            String type = (String)contentTypes.nextElement();
            if (type == null) continue;
            if (addComma) {
                property = property.append(',');
            } else {
                addComma = true;
            }
            property = property.append(type);
        }
        if (addComma) {
            this.addProperty("ACCEPT", property.toString());
        }
    }

    private void ensurePortletAcceptLanguage() {
        this.mHeaders.remove("ACCEPT-LANGUAGE");
        this.mHeaderNames.remove("ACCEPT-LANGUAGE");
        StringBuilder property = new StringBuilder(64);
        Enumeration locales = this.mPortletRequest.getLocales();
        boolean addComma = false;
        while (locales.hasMoreElements()) {
            String s;
            Locale l = (Locale)locales.nextElement();
            if (l == null) continue;
            if (addComma) {
                property = property.append(',');
            } else {
                addComma = true;
            }
            if ((s = l.getLanguage()).length() <= 0) continue;
            property = property.append(s);
            s = l.getCountry();
            if (s.length() <= 0) continue;
            property = property.append('-');
            property = property.append(s);
        }
        if (addComma) {
            this.addProperty("ACCEPT-LANGUAGE", property.toString());
        }
    }

    private void ensurePortletContentType() {
        this.mHeaders.remove("CONTENT-TYPE");
        this.mHeaderNames.remove("CONTENT-TYPE");
        StringBuilder property = new StringBuilder(64);
        String contentType = ((ClientDataRequest)this.mPortletRequest).getContentType();
        String charset = ((ClientDataRequest)this.mPortletRequest).getCharacterEncoding();
        if (contentType != null) {
            if (charset != null) {
                int index = contentType.indexOf(";");
                property = index < 0 ? property.append(contentType) : property.append(contentType, 0, index);
                property = property.append("; charset=");
                property = property.append(charset);
            }
            this.addProperty("CONTENT-TYPE", property.toString());
        }
    }

    private void ensurePortletContentLength() {
        this.mHeaders.remove("CONTENT-LENGTH");
        this.mHeaderNames.remove("CONTENT-LENGTH");
        int contentLength = ((ClientDataRequest)this.mPortletRequest).getContentLength();
        if (contentLength != -1) {
            this.addProperty("CONTENT-LENGTH", String.valueOf(contentLength));
        }
    }

    protected final void addProperty(String name, String value) {
        String upperName;
        List<String> propertyList;
        if (this.mHeaders == Collections.EMPTY_MAP) {
            this.mHeaders = new HashMap<String, List<String>>(40);
            this.mHeaderNames = new ArrayList<String>(30);
        }
        if ((propertyList = this.mHeaders.get(upperName = name.toUpperCase())) == null) {
            propertyList = new ArrayList<String>(4);
            this.mHeaders.put(upperName, propertyList);
            this.mHeaderNames.add(upperName);
        }
        propertyList.add(value);
    }
}

