/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.autoscroll;

import java.io.IOException;
import java.util.List;
import javax.faces.component.StateHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.custom.autoscroll.AutoscrollBehavior;

public class AutoscrollPageTagHandler
extends TagHandler {
    private TagAttribute _event = this.getAttribute("event");

    public AutoscrollPageTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIViewRoot root = this.getViewRoot(ctx, parent);
        if (!root.getAttributes().containsKey("oam.autoscroll.AUTOSCROLL_TAG_ON_PAGE")) {
            root.getAttributes().put("oam.autoscroll.AUTOSCROLL_TAG_ON_PAGE", Boolean.TRUE);
        }
        String eventName = this._event == null ? null : this._event.getValue(ctx);
        root.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)new RegisterAutoscrollBehaviorOnCommandListener(eventName));
        root.subscribeToEvent(PostRestoreStateEvent.class, (ComponentSystemEventListener)new RegisterAutoscrollListener(eventName));
    }

    private UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static class RegisterAutoscrollBehaviorOnCommandListener
    implements SystemEventListener {
        private String _eventName;

        public RegisterAutoscrollBehaviorOnCommandListener(String eventName) {
            this._eventName = eventName;
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UICommand && source instanceof ClientBehaviorHolder;
        }

        public void processEvent(SystemEvent event) {
            ClientBehaviorHolder component = (ClientBehaviorHolder)event.getSource();
            String eventName = this._eventName == null ? component.getDefaultEventName() : this._eventName;
            boolean found = false;
            List list = (List)component.getClientBehaviors().get(eventName);
            if (list != null) {
                for (ClientBehavior cb : list) {
                    if (!(cb instanceof AutoscrollBehavior)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                ClientBehavior behavior = (ClientBehavior)FacesContext.getCurrentInstance().getApplication().createBehavior("org.apache.myfaces.custom.autoscroll.AutoscrollBehavior");
                component.addClientBehavior(eventName, behavior);
            }
        }
    }

    public static class RegisterAutoscrollListener
    implements ComponentSystemEventListener,
    StateHolder {
        private String eventName;

        public RegisterAutoscrollListener() {
        }

        public RegisterAutoscrollListener(String event) {
            this.eventName = event;
        }

        public void processEvent(ComponentSystemEvent event) {
            FacesContext.getCurrentInstance().getViewRoot().subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)new RegisterAutoscrollBehaviorOnCommandListener(this.eventName));
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void restoreState(FacesContext context, Object state) {
            this.eventName = (String)state;
        }

        public Object saveState(FacesContext context) {
            return this.eventName;
        }
    }
}

