/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Interval;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public class Day
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final Date date;
    private final Date dayEnd;
    private final Date dayStart;
    private String specialDayName;
    private boolean workingDay;
    private TreeSet intervals;
    private final TimeZone timeZone;

    public Day(Date date) {
        this(date, TimeZone.getDefault());
    }

    public Day(Date date, TimeZone timeZone) {
        this.date = date;
        this.timeZone = timeZone;
        if (date == null) {
            throw new NullPointerException("date should not be null");
        }
        Calendar cal = this.getCalendarInstance(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.dayStart = cal.getTime();
        cal.add(5, 1);
        this.dayEnd = cal.getTime();
    }

    protected Calendar getCalendarInstance(Date date) {
        return ScheduleUtil.getCalendarInstance(date, this.timeZone);
    }

    public Date getDate() {
        return this.date == null ? new Date() : this.date;
    }

    public Date getDayEnd() {
        return this.dayEnd;
    }

    public Date getDayStart() {
        return this.dayStart;
    }

    public void setSpecialDayName(String specialDayName) {
        this.specialDayName = specialDayName;
    }

    public String getSpecialDayName() {
        return this.specialDayName;
    }

    public void setWorkingDay(boolean workingDay) {
        this.workingDay = workingDay;
    }

    public boolean isWorkingDay() {
        Calendar cal = this.getCalendarInstance(this.date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 7 || dayOfWeek == 1) {
            return false;
        }
        return this.workingDay;
    }

    public TreeSet getIntervals() {
        return this.intervals;
    }

    public void setIntervals(Collection intervals) {
        this.intervals = intervals instanceof TreeSet ? (TreeSet)intervals : new TreeSet(intervals);
    }

    public void addInterval(String label, Date startTime, Date endTime) {
        if (this.intervals == null) {
            this.intervals = new TreeSet();
        }
        this.intervals.add(new Interval(label, startTime, endTime));
    }

    public int compareTo(Object o) {
        if (o instanceof Day) {
            Day other = (Day)o;
            int returnint = ScheduleUtil.compareDays(this.date, other.getDate(), this.timeZone);
            return returnint;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof Day) {
            Day other = (Day)o;
            return ScheduleUtil.isSameDay(this.date, other.getDate(), this.timeZone);
        }
        return false;
    }

    public boolean equalsDate(Date date) {
        if (date == null) {
            return false;
        }
        return ScheduleUtil.isSameDay(date, this.date, this.timeZone);
    }

    public int hashCode() {
        return ScheduleUtil.getHashCodeForDay(this.date, this.timeZone);
    }
}

