/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.resource;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_tomahawk.resource.ResourceHandlerCache;
import org.apache.myfaces.shared_tomahawk.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared_tomahawk.resource.ResourceImpl;
import org.apache.myfaces.shared_tomahawk.resource.ResourceLoader;
import org.apache.myfaces.shared_tomahawk.resource.ResourceMeta;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;
import org.apache.myfaces.tomahawk.resource.UncompressedResourceHandlerSupport;

public class UncompressedResourceHandlerWrapper
extends ResourceHandlerWrapper {
    private ResourceHandler _delegate;
    private ResourceHandlerSupport _resourceHandlerSupport;
    private ResourceHandlerCache _resourceHandlerCache;

    public UncompressedResourceHandlerWrapper(ResourceHandler delegate) {
        this._delegate = delegate;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceImpl resource = null;
        if (this.getResourceHandlerSupport().getResourceLoaders().length > 0) {
            if (contentType == null) {
                contentType = FacesContext.getCurrentInstance().getExternalContext().getMimeType(resourceName);
            }
            String localePrefix = this.getLocalePrefixForLocateResource();
            if (this.getResourceLoaderCache().containsResource(resourceName, libraryName, contentType, localePrefix)) {
                ResourceHandlerCache.ResourceValue resourceValue = this.getResourceLoaderCache().getResource(resourceName, libraryName, contentType, localePrefix);
                resource = new ResourceImpl(resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType);
            } else {
                for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                    ResourceMeta resourceMeta = this.deriveResourceMeta(loader, resourceName, libraryName);
                    if (resourceMeta == null) continue;
                    resource = new ResourceImpl(resourceMeta, loader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putResource(resourceName, libraryName, contentType, localePrefix, resourceMeta, loader);
                    break;
                }
            }
            if (resource != null) {
                return resource;
            }
        }
        return this.getWrapped().createResource(resourceName, libraryName, contentType);
    }

    protected ResourceMeta deriveResourceMeta(ResourceLoader resourceLoader, String resourceName, String libraryName) {
        URL url;
        String localePrefix = this.getLocalePrefixForLocateResource();
        String resourceVersion = null;
        String libraryVersion = null;
        ResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    protected String getLocalePrefixForLocateResource() {
        Locale locale;
        ResourceBundle bundle;
        String localePrefix = null;
        FacesContext context = FacesContext.getCurrentInstance();
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName && (bundle = ResourceBundle.getBundle(bundleName, locale = context.getApplication().getViewHandler().calculateLocale(context), ClassUtils.getContextClassLoader())) != null) {
            try {
                localePrefix = bundle.getString("javax.faces.resource.localePrefix");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    public ResourceHandler getWrapped() {
        return this._delegate;
    }

    public void setResourceHandlerSupport(ResourceHandlerSupport resourceHandlerSupport) {
        this._resourceHandlerSupport = resourceHandlerSupport;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        if (this._resourceHandlerSupport == null) {
            this._resourceHandlerSupport = new UncompressedResourceHandlerSupport();
        }
        return this._resourceHandlerSupport;
    }

    private ResourceHandlerCache getResourceLoaderCache() {
        if (this._resourceHandlerCache == null) {
            this._resourceHandlerCache = new ResourceHandlerCache();
        }
        return this._resourceHandlerCache;
    }
}

