/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.agent.AgentNameUtil;
import org.apache.myfaces.trinidadinternal.agent.CapabilitiesProvider;
import org.apache.myfaces.trinidadinternal.agent.CapabilityKey;
import org.apache.myfaces.trinidadinternal.agent.CapabilityMap;
import org.apache.myfaces.trinidadinternal.agent.DeviceRepository;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrinidadAgentImpl
implements TrinidadAgent,
Cloneable {
    private static volatile URL _capUrl;
    private static final String _CAPABILITIES_FILE = "META-INF/agent/capabilities.xml";
    private static final String _DEVICE_REPOSITORY_URL = "org.apache.myfaces.trinidadinternal.agent.DeviceRepository";
    private static final TrinidadLogger _LOG;
    private static boolean _deviceRepositoryLoaded;
    private static DeviceRepository _deviceRepository;
    private Agent _delegate;
    private CapabilityMap _capMap;
    private int _type;
    private int _application;
    private int _os;
    private int _major;

    public TrinidadAgentImpl(FacesContext context, Agent agent) {
        this._delegate = agent;
        this._initialize(context);
    }

    public TrinidadAgentImpl(Agent agent) {
        this(null, agent);
    }

    public Object getType() {
        return this._delegate.getType();
    }

    @Override
    public int getAgentType() {
        return this._type;
    }

    public String getAgentName() {
        return this._delegate.getAgentName();
    }

    @Override
    public int getAgentApplication() {
        return this._application;
    }

    @Override
    public String getAgentVersion() {
        return this._delegate.getAgentVersion();
    }

    @Override
    public int getAgentMajorVersion() {
        return this._major;
    }

    public String getPlatformName() {
        return this._delegate.getPlatformName();
    }

    public String getPlatformVersion() {
        return this._delegate.getPlatformVersion();
    }

    public Map<Object, Object> getCapabilities() {
        return this._capMap;
    }

    @Override
    public int getAgentOS() {
        return this._os;
    }

    public String getHardwareMakeModel() {
        return this._delegate.getHardwareMakeModel();
    }

    @Override
    public Object getCapability(CapabilityKey key) {
        return this._capMap.getCapability(key);
    }

    @Override
    public Object clone() {
        try {
            TrinidadAgentImpl that = (TrinidadAgentImpl)super.clone();
            that._capMap = (CapabilityMap)this._capMap.clone();
            return that;
        }
        catch (CloneNotSupportedException cnse) {
            assert (false);
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Agent[");
        buffer.append(this.getType());
        buffer.append(',');
        String name = this.getAgentName();
        if (name != null) {
            buffer.append(name);
        } else {
            buffer.append("unknown");
        }
        String version = this.getAgentVersion();
        if (version != null) {
            buffer.append(' ');
            buffer.append(version);
        }
        buffer.append(',');
        name = this.getPlatformName();
        if (name != null) {
            buffer.append(name);
        } else {
            buffer.append("unknown");
        }
        buffer.append(']');
        version = this.getPlatformVersion();
        if (version != null) {
            buffer.append(' ');
            buffer.append(version);
        }
        return new String(buffer);
    }

    private void _initialize(FacesContext context) {
        this._type = AgentNameUtil.getAgentType(this.getType());
        this._application = AgentNameUtil.getAgent(this.getAgentName());
        this._os = AgentNameUtil.getPlatform(this.getPlatformName());
        this._major = 3 == this._application ? 1 : TrinidadAgentImpl._getMajorVersion(this.getAgentVersion());
        this._capMap = this._getCapabilityMap(context);
        Map requestCaps = this._delegate.getCapabilities();
        if (requestCaps != null) {
            this._capMap = this._capMap.merge(requestCaps);
        }
    }

    private CapabilityMap _getCapabilityMap(FacesContext context) {
        CapabilityMap capMap = null;
        DeviceRepository repository = TrinidadAgentImpl._getDeviceRepository();
        if (repository != null) {
            capMap = repository.getCapabilityMap(context, this);
        }
        if (capMap == null) {
            URL url = TrinidadAgentImpl._getCapabilitiesFile();
            if (url == null) {
                _LOG.severe("CANNOT_LOCATE_CAPABILITIES_DOCUMENT");
            }
            CapabilitiesProvider capProvider = CapabilitiesProvider.getCapabilitiesProvider(url);
            capMap = capProvider.getCapabilities(this);
        }
        return capMap;
    }

    private static synchronized DeviceRepository _getDeviceRepository() {
        if (!_deviceRepositoryLoaded) {
            List list = ClassLoaderUtils.getServices((String)_DEVICE_REPOSITORY_URL);
            _deviceRepository = list.isEmpty() ? null : (DeviceRepository)list.get(0);
            _deviceRepositoryLoaded = true;
        }
        return _deviceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL _getCapabilitiesFile() {
        if (_capUrl != null) {
            return _capUrl;
        }
        URL path = null;
        Class<TrinidadAgentImpl> clazz = TrinidadAgentImpl.class;
        synchronized (TrinidadAgentImpl.class) {
            if (_capUrl != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _capUrl;
            }
            if (path == null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = TrinidadAgentImpl.class.getClassLoader();
                }
                path = loader.getResource(_CAPABILITIES_FILE);
            }
            if (path == null) {
                _LOG.severe("CANNOT_RESOLVE_CAPABILITIES_FILE");
            }
            _capUrl = path;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _capUrl;
        }
    }

    private static int _getMajorVersion(String source) {
        double version = 0.0;
        if (source != null) {
            boolean hasDecimal = false;
            double divisor = 10.0;
            int sourceLength = source.length();
            for (int currIndex = 0; currIndex < sourceLength; ++currIndex) {
                char currChar = source.charAt(currIndex);
                if (currChar >= '0' && currChar <= '9') {
                    double addValue = currChar - 48;
                    if (hasDecimal) {
                        addValue /= divisor;
                        divisor *= 10.0;
                    } else {
                        version *= 10.0;
                    }
                    version += addValue;
                    continue;
                }
                if (hasDecimal || currChar != '.') break;
                hasDecimal = true;
            }
        }
        return (int)version;
    }

    void __mergeCapabilities(Map<Object, Object> capabilities) {
        this._capMap = this._capMap.merge(capabilities);
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(TrinidadAgentImpl.class);
    }
}

