/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.RequestContextFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidadinternal.context.RequestContextFactoryImpl;
import org.apache.myfaces.trinidadinternal.skin.SkinFactoryImpl;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;

public final class GlobalConfiguratorImpl
extends Configurator {
    private boolean _initialized;
    private List<Configurator> _services;
    private static final Map<ClassLoader, GlobalConfiguratorImpl> _CONFIGURATORS = new HashMap<ClassLoader, GlobalConfiguratorImpl>();
    private static final String _IN_REQUEST = GlobalConfiguratorImpl.class.getName() + ".IN_REQUEST";
    private static final String _REQUEST_CONTEXT = GlobalConfiguratorImpl.class.getName() + ".REQUEST_CONTEXT";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GlobalConfiguratorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GlobalConfiguratorImpl getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            Map<ClassLoader, GlobalConfiguratorImpl> map = _CONFIGURATORS;
            synchronized (map) {
                GlobalConfiguratorImpl config = _CONFIGURATORS.get(loader);
                if (config == null) {
                    try {
                        config = new GlobalConfiguratorImpl();
                        _CONFIGURATORS.put(loader, config);
                    }
                    catch (RuntimeException e) {
                        _LOG.severe((Throwable)e);
                        throw e;
                    }
                    _LOG.fine("GlobalConfigurator has been created.");
                }
                return config;
            }
        }
        _LOG.severe("CANNOT_FIND_CONTEXT_CLASS_LOADER");
        return null;
    }

    public static boolean isRequestStarted(ExternalContext ec) {
        return RequestType.getType(ec) != null;
    }

    private static final boolean _isDisabled(ExternalContext ec) {
        Boolean inRequest = (Boolean)ec.getRequestMap().get(_IN_REQUEST);
        if (inRequest == null) {
            return GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        }
        boolean disabled = inRequest;
        if (disabled != GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec)) {
            _LOG.warning("Configurator services were disabled after beginRequest was executed.  Cannot disable configurator services");
        }
        return disabled;
    }

    private GlobalConfiguratorImpl() {
    }

    public void beginRequest(ExternalContext externalContext) {
        assert (externalContext != null);
        if (RequestType.getType(externalContext) == null) {
            RequestType.setType(externalContext);
            if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
                if (!this._initialized) {
                    this.init(externalContext);
                }
                this._attachRequestContext(externalContext);
                if (externalContext.getRequestMap().get(_IN_REQUEST) == null) {
                    this._startConfiguratorServiceRequest(externalContext);
                }
            } else {
                _LOG.fine("GlobalConfigurator: Configurators have been disabled for this request.");
            }
        } else {
            if (!RequestType.isCorrectType(externalContext)) {
                throw new IllegalStateException("The previous action request was not ended.");
            }
            _LOG.fine("BeginRequest called multiple times for this request");
        }
    }

    public void destroy() {
        if (this._initialized) {
            for (Configurator config : this._services) {
                try {
                    config.destroy();
                }
                catch (Throwable t) {
                    _LOG.severe(t);
                }
            }
            this._services = null;
            this._initialized = false;
        }
    }

    public void endRequest(ExternalContext externalContext) {
        if (RequestType.getType(externalContext) != null) {
            if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
                RequestType type = RequestType.getType(externalContext);
                if (type != RequestType.PORTAL_ACTION) {
                    this._endConfiguratorServiceRequest(externalContext);
                }
                this._releaseRequestContext(externalContext);
            }
            RequestType.clearType(externalContext);
        }
    }

    public ExternalContext getExternalContext(ExternalContext externalContext) {
        if (RequestType.getType(externalContext) == null) {
            this.beginRequest(externalContext);
        }
        if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
            for (Configurator config : this._services) {
                externalContext = config.getExternalContext(externalContext);
            }
        }
        return externalContext;
    }

    public void init(ExternalContext externalContext) {
        assert (externalContext != null);
        if (!this._initialized) {
            this._services = ClassLoaderUtils.getServices((String)Configurator.class.getName());
            if (RequestContextFactory.getFactory() == null) {
                RequestContextFactory.setFactory((RequestContextFactory)new RequestContextFactoryImpl());
            }
            if (SkinFactory.getFactory() == null) {
                SkinFactory.setFactory((SkinFactory)new SkinFactoryImpl());
            }
            SkinUtils.registerBaseSkins();
            for (Configurator config : this._services) {
                config.init(externalContext);
            }
            SkinUtils.registerSkinExtensions(externalContext);
            this._initialized = true;
        } else {
            _LOG.warning("CONFIGURATOR_SERVICES_INITIALIZED");
        }
    }

    private void _attachRequestContext(ExternalContext externalContext) {
        Object cachedRequestContext;
        RequestContext context = RequestContext.getCurrentInstance();
        if (context != null) {
            if (_LOG.isWarning()) {
                _LOG.warning("REQUESTCONTEXT_NOT_PROPERLY_RELEASED");
            }
            context.release();
        }
        if ((cachedRequestContext = externalContext.getRequestMap().get(_REQUEST_CONTEXT)) instanceof RequestContext) {
            context = (RequestContext)cachedRequestContext;
            context.attach();
        } else {
            RequestContextFactory factory = RequestContextFactory.getFactory();
            assert (factory != null);
            context = factory.createContext(externalContext);
            externalContext.getRequestMap().put(_REQUEST_CONTEXT, context);
        }
        assert (RequestContext.getCurrentInstance() == context);
    }

    private void _releaseRequestContext(ExternalContext ec) {
        RequestContext context;
        if (RequestType.getType(ec) != RequestType.PORTAL_ACTION) {
            ec.getRequestMap().remove(_REQUEST_CONTEXT);
        }
        if ((context = RequestContext.getCurrentInstance()) != null) {
            context.release();
            assert (RequestContext.getCurrentInstance() == null);
        }
    }

    private void _endConfiguratorServiceRequest(ExternalContext ec) {
        ec.getRequestMap().remove(_IN_REQUEST);
        if (this._services != null) {
            for (Configurator config : this._services) {
                config.endRequest(ec);
            }
        }
    }

    private void _startConfiguratorServiceRequest(ExternalContext ec) {
        boolean disabled = GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        ec.getRequestMap().put(_IN_REQUEST, disabled);
        for (Configurator config : this._services) {
            config.beginRequest(ec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestType {
        PORTAL_ACTION,
        PORTAL_RENDER,
        SERVLET;

        private static final String _REQUEST_TYPE;

        public static void clearType(ExternalContext ec) {
            ec.getRequestMap().remove(_REQUEST_TYPE);
        }

        public static RequestType getType(ExternalContext ec) {
            return (RequestType)((Object)ec.getRequestMap().get(_REQUEST_TYPE));
        }

        public static boolean isCorrectType(ExternalContext ec) {
            return RequestType._findType(ec) == RequestType.getType(ec);
        }

        public static void setType(ExternalContext ec) {
            ec.getRequestMap().put(_REQUEST_TYPE, RequestType._findType(ec));
        }

        private static final RequestType _findType(ExternalContext ec) {
            if (ExternalContextUtils.isPortlet((ExternalContext)ec)) {
                if (ExternalContextUtils.isAction((ExternalContext)ec)) {
                    return PORTAL_ACTION;
                }
                return PORTAL_RENDER;
            }
            return SERVLET;
        }

        static {
            _REQUEST_TYPE = GlobalConfiguratorImpl.class.getName() + ".REQUEST_TYPE";
        }
    }
}

