/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.EditableValueRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;

public abstract class FormElementRenderer
extends EditableValueRenderer {
    private PropertyKey _autoSubmitKey;
    private PropertyKey _labelKey;
    private PropertyKey _contentStyleKey;
    private PropertyKey _onblurKey;
    private PropertyKey _onfocusKey;
    private PropertyKey _onchangeKey;

    protected FormElementRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._autoSubmitKey = type.findKey("autoSubmit");
        this._onblurKey = type.findKey("onblur");
        this._onfocusKey = type.findKey("onfocus");
        this._onchangeKey = type.findKey("onchange");
        this._labelKey = type.findKey("label");
        this._contentStyleKey = type.findKey("contentStyle");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        if (this._autoSubmitKey != null) {
            this.detectAutoSubmit(context, component, clientId);
        }
        return super.getSubmittedValue(context, component, clientId);
    }

    protected final void detectAutoSubmit(FacesContext context, UIComponent component, String clientId) {
        String event;
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        String source = (String)parameterMap.get("source");
        if (clientId.equals(source) && "autosub".equals(event = (String)parameterMap.get("event")) && this.isAutoSubmit(this.getFacesBean(component))) {
            new AutoSubmitEvent(component).queue();
        }
    }

    protected final void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.renderAsElement(context, arc, bean)) {
            this.encodeAllAsNonElement(context, arc, component, bean);
        } else {
            this.encodeAllAsElement(context, arc, component, bean);
        }
    }

    protected boolean isHiddenLabelRequired(RenderingContext arc) {
        return true;
    }

    protected void renderShortDescAsHiddenLabel(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        String hiddenLabel;
        String clientId;
        if (HiddenLabelUtils.supportsHiddenLabels(arc) && this.isHiddenLabelRequired(arc) && HiddenLabelUtils.wantsHiddenLabel(arc, clientId = this.getClientId(context, component)) && (hiddenLabel = this.getHiddenLabel(bean)) != null) {
            HiddenLabelUtils.outputHiddenLabel(context, arc, clientId, hiddenLabel, component);
        }
    }

    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
    }

    protected void encodeAllAsNonElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", component);
        this.renderId(context, component);
        rw.writeAttribute("title", (Object)this.getShortDesc(bean), "shortDesc");
        this.renderStyleAttributes(context, arc, bean);
        this.renderNonElementContent(context, arc, component, bean);
        rw.endElement("span");
    }

    protected void renderNonElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
    }

    protected void renderEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        super.renderEventHandlers(context, bean);
        this.renderFormEventHandlers(context, bean);
    }

    protected void renderFormEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.writeAttribute("onblur", (Object)this.getOnblur(bean), "onblur");
        rw.writeAttribute("onfocus", (Object)this.getOnfocus(bean), "onfocus");
        rw.writeAttribute("onchange", (Object)this.getOnchange(bean), "onchange");
    }

    protected final boolean renderAsElement(FacesContext context, RenderingContext arc, FacesBean bean) {
        if (!(!this.getReadOnly(context, bean) && FormElementRenderer.supportsEditing(arc) || this.renderReadOnlyAsElement(arc, bean))) {
            return false;
        }
        return FormElementRenderer.supportsDisabledFormElements(arc) || !this.getDisabled(bean);
    }

    protected boolean renderReadOnlyAsElement(RenderingContext arc, FacesBean bean) {
        return false;
    }

    protected String getLabel(FacesBean bean) {
        if (this._labelKey == null) {
            return null;
        }
        return FormElementRenderer.toString((Object)bean.getProperty(this._labelKey));
    }

    protected String getContentStyle(FacesBean bean) {
        if (this._contentStyleKey == null) {
            return null;
        }
        return FormElementRenderer.toString((Object)bean.getProperty(this._contentStyleKey));
    }

    protected String getOnblur(FacesBean bean) {
        if (this._onblurKey == null) {
            return null;
        }
        return FormElementRenderer.toString((Object)bean.getProperty(this._onblurKey));
    }

    protected String getOnfocus(FacesBean bean) {
        if (this._onfocusKey == null) {
            return null;
        }
        return FormElementRenderer.toString((Object)bean.getProperty(this._onfocusKey));
    }

    protected String getOnchange(FacesBean bean) {
        if (this._onchangeKey == null) {
            return null;
        }
        return FormElementRenderer.toString((Object)bean.getProperty(this._onchangeKey));
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return "AFFieldText";
    }

    protected boolean isAutoSubmit(FacesBean bean) {
        if (this._autoSubmitKey == null) {
            return false;
        }
        return Boolean.TRUE.equals(bean.getProperty(this._autoSubmitKey));
    }

    protected String getHiddenLabel(FacesBean bean) {
        String hiddenLabel = this.getShortDesc(bean);
        if (hiddenLabel == null) {
            hiddenLabel = this.getLabel(bean);
        }
        return hiddenLabel;
    }

    private static final class AutoSubmitEvent
    extends FacesEvent {
        public AutoSubmitEvent(UIComponent source) {
            super(source);
            this.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }

        public void processListener(FacesListener listener) {
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return false;
        }
    }
}

