/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlHead;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.StyleSheetRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.share.config.UIXCookie;

public class HeadRenderer
extends XhtmlRenderer {
    private CoreRenderer _styleSheetRenderer = new StyleSheetRenderer(){

        protected void renderId(FacesContext context, UIComponent component) {
        }
    };
    private PropertyKey _titleKey;

    public HeadRenderer() {
        this(HtmlHead.TYPE);
    }

    protected HeadRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._titleKey = type.findKey("title");
    }

    protected void encodeBegin(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("head", comp);
        this.renderId(context, comp);
        String title = this.getTitle(bean);
        if (title != null) {
            rw.startElement("title", null);
            rw.writeText((Object)title, null);
            rw.endElement("title");
        }
        HeadRenderer._writeGeneratorTag(context);
        this.delegateRenderer(context, arc, comp, bean, this._styleSheetRenderer);
        HeadRenderer._writeCookieScript(context, arc);
    }

    protected void encodeEnd(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.endElement("head");
    }

    protected String getTitle(FacesBean bean) {
        return HeadRenderer.toString((Object)bean.getProperty(this._titleKey));
    }

    private static void _writeGeneratorTag(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("meta", null);
        writer.writeAttribute("name", (Object)"generator", null);
        writer.writeAttribute("content", (Object)"Apache MyFaces Trinidad", null);
        writer.endElement("meta");
    }

    private static void _writeCookieScript(FacesContext context, RenderingContext arc) throws IOException {
        if (HeadRenderer._needsCookieScript(context, arc)) {
            XhtmlUtils.addLib(context, arc, "defaultTimeZone");
        }
    }

    private static boolean _needsCookieScript(FacesContext context, RenderingContext arc) {
        ExternalContext externalContext = context.getExternalContext();
        String outputMode = arc.getOutputMode();
        if ("portlet".equals(outputMode)) {
            return false;
        }
        if (arc.getPartialPageContext() != null) {
            return false;
        }
        Object request = externalContext.getRequest();
        Object response = externalContext.getResponse();
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            UIXCookie cookie = UIXCookie.getUIXCookie((HttpServletRequest)request, (HttpServletResponse)response, false);
            return (cookie == null || HeadRenderer._timeZoneIsDefaulting(cookie)) && HeadRenderer._supportsUIXCookie();
        }
        return false;
    }

    private static boolean _timeZoneIsDefaulting(UIXCookie cookie) {
        TimeZone tz = cookie.getTimeZone();
        return tz == null || tz.getID().startsWith("GMT");
    }

    private static boolean _supportsUIXCookie() {
        return true;
    }
}

