/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;
import org.apache.myfaces.trinidadinternal.share.util.MultipartFormItem;

public class MultipartFormHandler {
    private static final String _MULTIPART_REQUEST_TYPE = "multipart/form-data";
    private static final String _DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final String _BOUNDARY_PARAMETER = "boundary=";
    private static final String _NAME_PARAMETER = "name=";
    private static final String _FILENAME_PARAMETER = "filename=";
    private static final String _CONTENT_TYPE_PARAMETER = "content-type";
    private static final String _CONTENT_DISPOSITION_PARAMETER = "content-disposition:";
    private static final String _FORM_DATA_DISPOSITION = "form-data";
    private static final String _HANDLED = "org.apache.myfaces.trinidadinternal.share.util.MultipartFormHandler.handled";
    private static final int _STREAM_BUFFER_SIZE = 65000;
    private static final int _LINE_BUFFER_SIZE = 8000;
    private final byte[] _lineBuffer = new byte[8000];
    private byte[] _streamBuffer;
    private InputStream _in;
    private String _boundary;
    private MultipartFormItemImpl _currentItem;
    private String _characterEncoding;
    private long _maxAllowedBytes = 0x8000000L;
    private int _totalBytesRead;
    private int _contentStreamSize = -1;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MultipartFormHandler.class);

    public static boolean isMultipartRequest(ExternalContext externalContext) {
        String contentType = ExternalContextUtils.getContentType((ExternalContext)externalContext);
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith(_MULTIPART_REQUEST_TYPE) && externalContext.getRequestMap().get(_HANDLED) == null;
    }

    public MultipartFormHandler(ExternalContext externalContext) throws IOException {
        this(ExternalContextUtils.getContentType((ExternalContext)externalContext), ExternalContextUtils.getRequestInputStream((ExternalContext)externalContext));
        Map requestMap = externalContext.getRequestMap();
        requestMap.put(_HANDLED, Boolean.TRUE);
        this._contentStreamSize = ExternalContextUtils.getContentLength((ExternalContext)externalContext);
    }

    public MultipartFormHandler(String type, InputStream in) throws IOException {
        if (!type.startsWith(_MULTIPART_REQUEST_TYPE)) {
            throw new IllegalStateException(_LOG.getMessage("CONTENT_NOT_MULTIPART_FORM_DATA"));
        }
        this._boundary = MultipartFormHandler._parseBoundary(type);
        this._in = in;
        this._skipBoundary();
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        CaboHttpUtils.validateEncoding(characterEncoding);
        this._characterEncoding = characterEncoding;
    }

    public long getBytesRead() {
        return this._totalBytesRead;
    }

    public long getTotalBytes() {
        return this._contentStreamSize;
    }

    public void setMaximumAllowedBytes(long maxAllowedBytes) {
        this._maxAllowedBytes = Math.max(0L, maxAllowedBytes);
    }

    public long getMaximumAllowedBytes() {
        return this._maxAllowedBytes;
    }

    public MultipartFormItem getNextPart() throws IOException {
        String dispositionText;
        MultipartFormItemImpl previous = this._currentItem;
        if (previous != null) {
            previous.finish();
        }
        if ((dispositionText = this._readLine(false)) == null) {
            return null;
        }
        Disposition disposition = new Disposition(dispositionText);
        String contentTypeText = this._readLine(false);
        if (contentTypeText == null) {
            return null;
        }
        String contentType = this._parseContentType(contentTypeText);
        if (contentType == null) {
            contentType = _DEFAULT_CONTENT_TYPE;
        } else {
            String emptyLine = this._readLine(true);
            if (emptyLine.length() > 0) {
                throw new IOException();
            }
        }
        this._currentItem = new MultipartFormItemImpl(disposition, contentType);
        return this._currentItem;
    }

    private void _skipBoundary() throws IOException {
        String line = this._readLine(true);
        if (!line.startsWith(this._boundary)) {
            throw new EOFException();
        }
    }

    private String _readLine(boolean required) throws IOException {
        return this._readLine(required, false, true);
    }

    private String _readLine(boolean required, boolean decodeEncoding, boolean stripNewLines) throws IOException {
        byte[] data = this._lineBuffer;
        int bytes = this._readLine(data, 0, data.length);
        String line = null;
        if (bytes < 0) {
            if (required) {
                throw new EOFException();
            }
        } else {
            line = this._dataToString(data, 0, bytes, decodeEncoding, stripNewLines);
        }
        return line;
    }

    private int _readLine(byte[] buffer, int offset, int length) throws IOException {
        int c;
        if (length <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = this._in.read()) != -1) {
            buffer[offset++] = (byte)c;
            ++count;
            if (c == 10) break;
            if (count != length - 1) continue;
            if (c != 13) break;
            int nextchar = this._in.read();
            buffer[offset++] = (byte)nextchar;
            ++count;
            break;
        }
        this._totalBytesRead += count;
        return count > 0 ? count : -1;
    }

    private String _dataToString(byte[] data, int start, int bytes, boolean decodeEncoding, boolean stripNewLines) {
        block9: {
            if (bytes > 0) {
                byte lastChar;
                int i;
                for (i = 0; i < 2 && bytes > 0 && ((lastChar = data[start + bytes - 1]) == 13 || lastChar == 10); --bytes, ++i) {
                }
                if (!stripNewLines && i > 0) {
                    data[start + ++bytes - 1] = 10;
                }
                if (decodeEncoding && this._characterEncoding != null) {
                    try {
                        return new String(data, start, bytes, this._characterEncoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        assert (false);
                        break block9;
                    }
                }
                try {
                    return new String(data, start, bytes, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
        return "";
    }

    private static String _parseBoundary(String contentType) {
        int boundaryStart = contentType.indexOf(_BOUNDARY_PARAMETER);
        if (boundaryStart < 0) {
            return null;
        }
        return "--" + contentType.substring(boundaryStart + _BOUNDARY_PARAMETER.length());
    }

    private String _parseContentType(String line) throws IOException {
        String contentType = null;
        if ((line = line.toLowerCase()).startsWith(_CONTENT_TYPE_PARAMETER)) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException();
            }
            contentType = line.substring(start + 1);
        } else if (line.length() > 0) {
            throw new IOException();
        }
        return contentType;
    }

    byte[] __getStreamBuffer() {
        if (this._streamBuffer == null) {
            this._streamBuffer = new byte[65000];
        }
        return this._streamBuffer;
    }

    private class Disposition {
        private String _name;
        private String _filename;

        Disposition(String line) throws IOException {
            StringTokenizer tokenizer = new StringTokenizer(line, ";");
            if (!tokenizer.hasMoreTokens()) {
                throw new IOException();
            }
            String disposition = tokenizer.nextToken().toLowerCase();
            if (!disposition.startsWith(MultipartFormHandler._CONTENT_DISPOSITION_PARAMETER)) {
                throw new IllegalArgumentException();
            }
            if (!(disposition = disposition.substring(MultipartFormHandler._CONTENT_DISPOSITION_PARAMETER.length()).trim()).equals(MultipartFormHandler._FORM_DATA_DISPOSITION)) {
                throw new IOException();
            }
            StringBuilder filenameBuffer = null;
            while (tokenizer.hasMoreTokens()) {
                String keyValue = tokenizer.nextToken().trim();
                if (this._name == null) {
                    this._name = this._extractName(keyValue);
                    continue;
                }
                if (filenameBuffer == null) {
                    filenameBuffer = new StringBuilder(keyValue);
                    continue;
                }
                filenameBuffer.append(";").append(keyValue);
            }
            if (filenameBuffer != null) {
                this._filename = this._extractFilename(filenameBuffer.toString());
            }
        }

        public final String getName() {
            return this._name;
        }

        public final String getFilename() {
            return this._filename;
        }

        private String _extractName(String keyValue) {
            return this._extractValue(keyValue, MultipartFormHandler._NAME_PARAMETER);
        }

        private String _extractFilename(String keyValue) {
            int index;
            String fileName;
            block3: {
                fileName = this._extractValue(keyValue, MultipartFormHandler._FILENAME_PARAMETER);
                try {
                    fileName = CaboHttpUtils.decodeRequestParameter(fileName, MultipartFormHandler.this.getCharacterEncoding(), null);
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            if (fileName != null && (index = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92))) != -1) {
                fileName = fileName.substring(index + 1);
            }
            return fileName;
        }

        private String _extractValue(String keyValue, String param) {
            int length = param.length();
            if (keyValue.regionMatches(true, 0, param, 0, length)) {
                int end;
                int start = length;
                if (keyValue.charAt(start) == '\"') {
                    ++start;
                }
                if (keyValue.charAt((end = keyValue.length()) - 1) == '\"') {
                    --end;
                }
                return keyValue.substring(start, end);
            }
            return null;
        }
    }

    private class MultipartFormItemImpl
    implements MultipartFormItem {
        private MultipartInputStream _inputStream;
        private Disposition _disposition;
        private String _contentType;
        private String _parameterValue;
        private boolean _finished;
        private int _begin;
        private int _end;
        private byte[] _buffer;
        private boolean _addCRLF;

        MultipartFormItemImpl(Disposition disposition, String contentType) throws IOException {
            this._disposition = disposition;
            this._contentType = contentType;
            if (disposition.getFilename() == null) {
                this._parameterValue = this._readParameter();
            }
        }

        public void finish() throws IOException {
            if (this._parameterValue == null && !this._finished) {
                if (this._inputStream == null) {
                    this.writeFile(null);
                } else {
                    this._inputStream.finish();
                }
                this._finished = true;
            }
        }

        public String getValue() {
            return this._parameterValue;
        }

        public String getName() {
            return this._disposition.getName();
        }

        public String getFilename() {
            return this._disposition.getFilename();
        }

        public String getContentType() {
            return this._contentType;
        }

        public long writeFile(OutputStream out) throws IOException {
            String line;
            if (this._parameterValue != null) {
                throw new IOException(_LOG.getMessage("ITEM_NOT_A_FILE"));
            }
            if (this._finished) {
                throw new IOException(_LOG.getMessage("ITEM_ALREADY_BEEN_READ_PAST"));
            }
            if (this._inputStream != null) {
                throw new IOException(_LOG.getMessage("INPUT_STREAM_ALREADY_REQUESTED"));
            }
            long totalBytesWritten = 0L;
            boolean addCRLF = false;
            int numbuf = 0;
            byte[] buffer = MultipartFormHandler.this.__getStreamBuffer();
            int bufferSize = buffer.length;
            while (!((numbuf = MultipartFormHandler.this._readLine(buffer, 0, bufferSize)) == -1 || numbuf > 2 && buffer[0] == 45 && buffer[1] == 45 && (line = MultipartFormHandler.this._dataToString(buffer, 0, numbuf, false, true)).startsWith(MultipartFormHandler.this._boundary))) {
                if (addCRLF) {
                    if (out != null) {
                        out.write(13);
                        out.write(10);
                        totalBytesWritten += 2L;
                    }
                    addCRLF = false;
                }
                if (numbuf >= 2 && buffer[numbuf - 2] == 13 && buffer[numbuf - 1] == 10) {
                    numbuf -= 2;
                    addCRLF = true;
                }
                if (out == null || (totalBytesWritten += (long)numbuf) > MultipartFormHandler.this._maxAllowedBytes) continue;
                out.write(buffer, 0, numbuf);
            }
            this._finished = true;
            if (totalBytesWritten >= MultipartFormHandler.this._maxAllowedBytes) {
                throw new EOFException(_LOG.getMessage("UPLOADED_FILE_EXCEEDED_MAXIMUM_ALLOWED_LENGTH", new Object[]{totalBytesWritten, MultipartFormHandler.this._maxAllowedBytes}));
            }
            return totalBytesWritten;
        }

        public InputStream getInputStream() throws IOException {
            if (this._parameterValue != null) {
                throw new IOException(_LOG.getMessage("ITEM_NOT_A_FILE"));
            }
            if (this._finished) {
                throw new IOException(_LOG.getMessage("ITEM_ALREADY_BEEN_READ_PAST"));
            }
            if (this._inputStream != null) {
                throw new IOException(_LOG.getMessage("INPUT_STREAM_ALREADY_REQUESTED"));
            }
            this._inputStream = new MultipartInputStream();
            return this._inputStream;
        }

        private String _readParameter() throws IOException {
            StringBuffer buffer = new StringBuffer(200);
            String line = MultipartFormHandler.this._readLine(false, true, false);
            while (line != null && !line.startsWith(MultipartFormHandler.this._boundary)) {
                buffer.append(line);
                line = MultipartFormHandler.this._readLine(false, true, false);
            }
            int length = buffer.length();
            if (buffer.charAt(length - 1) == '\n') {
                buffer.deleteCharAt(length - 1);
            }
            return buffer.toString();
        }

        static /* synthetic */ byte[] access$1102(MultipartFormItemImpl x0, byte[] x1) {
            x0._buffer = x1;
            return x1;
        }

        private class MultipartInputStream
        extends InputStream {
            MultipartInputStream() throws IOException {
                if (MultipartFormItemImpl.this._parameterValue != null) {
                    throw new IOException(_LOG.getMessage("ITEM_NOT_A_FILE"));
                }
                if (MultipartFormItemImpl.this._finished) {
                    throw new IOException(_LOG.getMessage("ITEM_ALREDY_BEEN_READ_PAST"));
                }
                MultipartFormItemImpl.this._begin = 0;
                MultipartFormItemImpl.this._end = 0;
                MultipartFormItemImpl.this._addCRLF = false;
                MultipartFormItemImpl.access$1102(MultipartFormItemImpl.this, MultipartFormHandler.this.__getStreamBuffer());
            }

            public void finish() {
                try {
                    while (this.read(MultipartFormItemImpl.this._buffer) > 0) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private void readLine() throws IOException {
                String line;
                if (MultipartFormItemImpl.this._finished) {
                    throw new IOException(_LOG.getMessage("END_OF_FILE"));
                }
                if (MultipartFormItemImpl.this._addCRLF) {
                    ((MultipartFormItemImpl)MultipartFormItemImpl.this)._buffer[((MultipartFormItemImpl)MultipartFormItemImpl.this)._end++] = 13;
                    ((MultipartFormItemImpl)MultipartFormItemImpl.this)._buffer[((MultipartFormItemImpl)MultipartFormItemImpl.this)._end++] = 10;
                    MultipartFormItemImpl.this._addCRLF = false;
                }
                int bufferSize = MultipartFormItemImpl.this._buffer.length;
                int numbuf = MultipartFormHandler.this._readLine(MultipartFormItemImpl.this._buffer, MultipartFormItemImpl.this._end, bufferSize - MultipartFormItemImpl.this._end);
                if (numbuf < 0) {
                    MultipartFormItemImpl.this._finished = true;
                    return;
                }
                if (numbuf > 2 && MultipartFormItemImpl.this._buffer[MultipartFormItemImpl.this._end] == 45 && MultipartFormItemImpl.this._buffer[MultipartFormItemImpl.this._end + 1] == 45 && (line = MultipartFormHandler.this._dataToString(MultipartFormItemImpl.this._buffer, MultipartFormItemImpl.this._end, numbuf, false, true)).startsWith(MultipartFormHandler.this._boundary)) {
                    MultipartFormItemImpl.this._finished = true;
                    return;
                }
                if (numbuf >= 2 && MultipartFormItemImpl.this._buffer[MultipartFormItemImpl.this._end + numbuf - 2] == 13 && MultipartFormItemImpl.this._buffer[MultipartFormItemImpl.this._end + numbuf - 1] == 10) {
                    numbuf -= 2;
                    MultipartFormItemImpl.this._addCRLF = true;
                }
                MultipartFormItemImpl.this._end += numbuf;
            }

            public int read(byte[] buffer, int offset, int length) throws IOException {
                int bytes = -1;
                if (!MultipartFormItemImpl.this._finished || MultipartFormItemImpl.this._end > 0) {
                    if (MultipartFormItemImpl.this._end == 0) {
                        this.readLine();
                    }
                    if (!MultipartFormItemImpl.this._finished) {
                        int cachedBytes = MultipartFormItemImpl.this._end - MultipartFormItemImpl.this._begin;
                        bytes = length > cachedBytes ? cachedBytes : length;
                        System.arraycopy(MultipartFormItemImpl.this._buffer, MultipartFormItemImpl.this._begin, buffer, offset, bytes);
                        MultipartFormItemImpl.this._begin += bytes;
                        if (MultipartFormItemImpl.this._begin == MultipartFormItemImpl.this._end) {
                            MultipartFormItemImpl.this._begin = (MultipartFormItemImpl.this._end = 0);
                        }
                    }
                }
                return bytes;
            }

            public int read(byte[] buffer) throws IOException {
                return this.read(buffer, 0, buffer.length);
            }

            public int read() throws IOException {
                byte[] temp = new byte[1];
                int value = this.read(temp, 0, 1);
                if (value > 0) {
                    value = (char)temp[0];
                }
                return value;
            }
        }
    }
}

