/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassParserFactory
implements ParserFactory {
    private Class<?> _class;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ClassParserFactory.class);

    public ClassParserFactory(Class<?> classObject) {
        if (classObject == null) {
            throw new NullPointerException();
        }
        this._class = classObject;
        this._checkClass();
    }

    public ClassParserFactory(String className) {
        try {
            this._class = ClassLoaderUtils.loadClass((String)className);
        }
        catch (ClassNotFoundException e) {
            _LOG.severe((Throwable)e);
        }
        this._checkClass();
    }

    @Override
    public NodeParser getParser(ParseContext context, String namespaceURI, String localName) {
        NodeParser parser = null;
        try {
            parser = (NodeParser)this._class.newInstance();
        }
        catch (IllegalAccessException e) {
            _LOG.severe((Throwable)e);
        }
        catch (InstantiationException e) {
            _LOG.severe((Throwable)e);
        }
        return parser;
    }

    private void _checkClass() {
        assert (this._class != null);
        assert (NodeParser.class.isAssignableFrom(this._class));
    }
}

