/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.share.url.FormEncoder;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;

@Deprecated
public class ProcessUtils {
    private static final String _NAV_SUBMIT_SCRIPTLET = "ui.NavSubmit";
    private static final String _NAV_CHOICE_SUBMIT_SCRIPTLET = "ui.NavChoiceSubmit";
    private static final String[] _NAV_SUBMIT_SCRIPT;
    private static final int _NAV_SUBMIT_SCRIPT_LENGTH;
    private static final String _LINK_ON_CHANGE_FORM_START = "_navSubmit('";
    private static final String _CHOICE_ON_CHANGE_FORM_START = "_navChoiceSubmit(this, '";
    private static final String _CHOICE_ON_CHANGE_FORM_END = ")";
    private static final String _CHOICE_SUBMIT_SCRIPT = "function _navChoiceSubmit(choice, formName, event, node, vld, sze, partialTargets){if (!_navSubmit(formName, event, node, vld, choice.options[choice.selectedIndex].value, sze, partialTargets)){choice.selectedIndex = choice._lastValue;}}";
    public static final int NO_INDEX = -1;

    public static UINode createSubmitButton(UIXRenderingContext context, Object buttonText, Object buttonAccessKey, String buttonID, String formName, boolean validate, String eventKey, String sourceKey, String source, String valueKey, long value, String sizeKey, int size) {
        MarlinBean submitButton = new MarlinBean("submitButton");
        submitButton.setID(buttonID);
        submitButton.setAttributeValue(UIConstants.FORM_NAME_ATTR, formName);
        submitButton.setAttributeValue(UIConstants.UNVALIDATED_ATTR, !validate);
        submitButton.setAttributeValue(UIConstants.TEXT_ATTR, buttonText);
        submitButton.setAttributeValue(UIConstants.ACCESS_KEY_ATTR, buttonAccessKey);
        String nameAttri = XhtmlUtils.getEncodedNameAttribute(new String[]{sourceKey, source, eventKey, "goto", valueKey, Long.toString(value), sizeKey, Integer.toString(size)});
        submitButton.setAttributeValue(UIConstants.NAME_ATTR, nameAttri);
        return submitButton;
    }

    public static String getSubmitScriptCall(UIXRenderingContext context, String form, String eventKey, String sourceKey, String name, String valueKey, long value, String sizeKey, int size, boolean doValidate, String partialTargetsKey, String partialTargets) {
        String valueString = IntegerUtils.getString((long)value);
        String sizeString = IntegerUtils.getString((int)size);
        FormEncoder formEncoder = context.getFormEncoder();
        String encodedGotoEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, eventKey, "goto");
        String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sourceKey, name);
        String encodedValue = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, valueKey, valueString);
        String encodedSize = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sizeKey, sizeString);
        String encodedPartialTargets = null;
        if (partialTargetsKey != null && partialTargets != null) {
            encodedPartialTargets = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, partialTargetsKey, partialTargets);
        }
        if (form == null) {
            form = "";
        }
        if (encodedSource == null) {
            encodedSource = "";
        }
        int bufferSize = _LINK_ON_CHANGE_FORM_START.length() + form.length() + 34 + encodedGotoEvent.length() + encodedSource.length() + encodedValue.length() + encodedSize.length();
        if (partialTargets != null) {
            bufferSize += partialTargets.length() + 2;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(_LINK_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("', '");
        buffer.append(encodedGotoEvent);
        buffer.append("', '");
        buffer.append(encodedSource);
        if (doValidate) {
            buffer.append("',1,'");
        } else {
            buffer.append("',0,'");
        }
        buffer.append(encodedValue);
        buffer.append("', '");
        buffer.append(encodedSize);
        buffer.append("',");
        if (encodedPartialTargets != null) {
            buffer.append("'");
            buffer.append(encodedPartialTargets);
            buffer.append("'");
        } else {
            buffer.append("null");
        }
        buffer.append(");return false");
        return buffer.toString();
    }

    public static String getChoiceOnChangeFormSubmitted(UIXRenderingContext context, UINode node, String form, String eventKey, String sourceKey, String name, String partialTargetsKey, String partialTargets) {
        FormEncoder formEncoder = context.getFormEncoder();
        String encodedGotoEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, eventKey, "goto");
        String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, sourceKey, name);
        String encodedPartialTargets = XhtmlLafUtils.getFormEncodedParameter(formEncoder, form, partialTargetsKey, partialTargets);
        int initialSize = _CHOICE_ON_CHANGE_FORM_START.length() + form.length() + 13 + encodedSource.length() + _CHOICE_ON_CHANGE_FORM_END.length();
        if (encodedPartialTargets != null) {
            initialSize += encodedPartialTargets.length() + 2;
        }
        StringBuffer buffer = new StringBuffer(initialSize);
        buffer.append(_CHOICE_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("','");
        buffer.append(encodedGotoEvent);
        buffer.append("','");
        buffer.append(encodedSource);
        buffer.append("',0");
        if (encodedPartialTargets != null) {
            buffer.append(",null,");
            buffer.append("'");
            buffer.append(encodedPartialTargets);
            buffer.append("'");
        }
        buffer.append(_CHOICE_ON_CHANGE_FORM_END);
        return buffer.toString();
    }

    public static int getBackIndex(UIXCollection component, UIComponent stamp, int startIndex) {
        for (int i = startIndex - 1; i >= 0; --i) {
            component.setRowIndex(i);
            boolean disabled = Boolean.TRUE.equals(stamp.getAttributes().get("disabled"));
            boolean readOnly = Boolean.TRUE.equals(stamp.getAttributes().get("readOnly"));
            boolean rendered = stamp.isRendered();
            if (disabled || readOnly || !rendered) continue;
            component.setRowIndex(startIndex);
            return i;
        }
        component.setRowIndex(startIndex);
        return -1;
    }

    public static int getNextIndex(UIXCollection component, UIComponent stamp, int startIndex) {
        int rowCount = component.getRowCount();
        for (int i = startIndex + 1; i < rowCount; ++i) {
            component.setRowIndex(i);
            boolean disabled = Boolean.TRUE.equals(stamp.getAttributes().get("disabled"));
            boolean readOnly = Boolean.TRUE.equals(stamp.getAttributes().get("readOnly"));
            boolean rendered = stamp.isRendered();
            if (disabled || readOnly || !rendered) continue;
            component.setRowIndex(startIndex);
            return i;
        }
        component.setRowIndex(startIndex);
        return -1;
    }

    public static void renderNavSubmitScript(UIXRenderingContext context) throws IOException {
        XhtmlLafUtils.addLib(context, _NAV_SUBMIT_SCRIPTLET);
    }

    public static void renderNavChoiceSubmitScript(UIXRenderingContext context) throws IOException {
        XhtmlLafUtils.addLib(context, _NAV_CHOICE_SUBMIT_SCRIPTLET);
    }

    public static String concatenateParams(long value, int size) {
        String valueString = IntegerUtils.getString((long)value);
        String sizeString = IntegerUtils.getString((int)size);
        int bufferSize = valueString.length() + 2 + sizeString.length();
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(valueString);
        buffer.append(",");
        buffer.append(sizeString);
        return buffer.toString();
    }

    private static String[] _createKeyValueArray(String eventKey, String sourceKey, String source, String valueKey, long value, String sizeKey, int size, String partialTargetKey, String partialTargets) {
        int length = 8;
        if (partialTargets != null) {
            length += 2;
        }
        String[] keyValues = new String[length];
        keyValues[0] = eventKey;
        keyValues[1] = "goto";
        keyValues[2] = sourceKey;
        keyValues[3] = source;
        keyValues[4] = valueKey;
        keyValues[5] = IntegerUtils.getString((long)value);
        keyValues[6] = sizeKey;
        keyValues[7] = IntegerUtils.getString((int)size);
        if (partialTargets != null) {
            keyValues[8] = partialTargetKey;
            keyValues[9] = partialTargets;
        }
        return keyValues;
    }

    private static String _getNavSubmitScript(String eventKey, String sourceKey, String valueKey, String sizeKey, String partialTargetsKey) {
        int len = _NAV_SUBMIT_SCRIPT_LENGTH + eventKey.length() + sourceKey.length() + valueKey.length() + sizeKey.length() + partialTargetsKey.length();
        StringBuffer buf = new StringBuffer(len);
        buf.append(_NAV_SUBMIT_SCRIPT[0]);
        buf.append(eventKey);
        buf.append(_NAV_SUBMIT_SCRIPT[1]);
        buf.append(sourceKey);
        buf.append(_NAV_SUBMIT_SCRIPT[2]);
        buf.append(valueKey);
        buf.append(_NAV_SUBMIT_SCRIPT[3]);
        buf.append(sizeKey);
        buf.append(_NAV_SUBMIT_SCRIPT[4]);
        buf.append(partialTargetsKey);
        buf.append(_NAV_SUBMIT_SCRIPT[5]);
        return buf.toString();
    }

    static {
        NavSubmitScriptlet.sharedInstance().registerSelf();
        NavChoiceSubmitScriptlet.sharedInstance().registerSelf();
        _NAV_SUBMIT_SCRIPT = new String[]{"function _navSubmit(formName, event, node, vld, val, sze, partialTargets){var i = val.indexOf(',');if (i >= 0){sze = val.substring(i+1);val = val.substring(0, i);}var submitFunc = (partialTargets == (void 0)) ? submitForm : _submitPartialChange;return submitFunc(formName,vld,{", ":event,", ":node,", ":val,", ":sze,", ":partialTargets});}"};
        _NAV_SUBMIT_SCRIPT_LENGTH = XhtmlLafUtils.getLength(_NAV_SUBMIT_SCRIPT);
    }

    private static class NavChoiceSubmitScriptlet
    extends Scriptlet {
        private static NavChoiceSubmitScriptlet _sInstance = new NavChoiceSubmitScriptlet();

        private NavChoiceSubmitScriptlet() {
        }

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        public Object getScriptletKey() {
            return ProcessUtils._NAV_CHOICE_SUBMIT_SCRIPTLET;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.write(ProcessUtils._CHOICE_SUBMIT_SCRIPT);
        }
    }

    private static class NavSubmitScriptlet
    extends Scriptlet {
        private static NavSubmitScriptlet _sInstance = new NavSubmitScriptlet();

        private NavSubmitScriptlet() {
        }

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        public Object getScriptletKey() {
            return ProcessUtils._NAV_SUBMIT_SCRIPTLET;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)ProcessUtils._getNavSubmitScript("event", "source", "value", "size", "partialTargets"), null);
        }
    }
}

