/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.event;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.trinidad.model.RowKeySet;

public abstract class RowKeySetChangeEvent
extends FacesEvent {
    private RowKeySet _oldRemoved;
    private RowKeySet _newAdded;
    private boolean _needsDiff;
    private static final long serialVersionUID = 1L;

    public RowKeySetChangeEvent(UIComponent source, RowKeySet removedSet, RowKeySet addedSet) {
        this(source, removedSet, addedSet, false);
    }

    public RowKeySetChangeEvent(RowKeySet oldSet, RowKeySet newSet, UIComponent source) {
        this(source, oldSet, newSet, true);
    }

    private RowKeySetChangeEvent(UIComponent source, RowKeySet oldRemoved, RowKeySet newAdded, boolean needsDiff) {
        super(source);
        this._newAdded = newAdded;
        this._oldRemoved = oldRemoved;
        this._needsDiff = needsDiff;
    }

    public RowKeySet getAddedSet() {
        this._diff();
        return this._newAdded;
    }

    public RowKeySet getRemovedSet() {
        this._diff();
        return this._oldRemoved;
    }

    private void _diff() {
        if (this._needsDiff) {
            RowKeySet removed = this._oldRemoved.clone();
            removed.removeAll(this._newAdded);
            RowKeySet added = this._newAdded.clone();
            added.removeAll(this._oldRemoved);
            this._needsDiff = false;
            this._oldRemoved = removed;
            this._newAdded = added;
        }
    }
}

