/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html.layout;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXShowDetail;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.html.layout.ShowOneUtils;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.uinode.UINodeRendererBase;

abstract class ShowOneListRendererBase
extends UINodeRendererBase {
    private static final String _ALIGNMENT_LEFT = "start";
    private static final String _ALIGNMENT_RIGHT = "end";
    private static final String _ALIGNMENT_TOP = "top";
    private static final String _ALIGNMENT_BOTTOM = "bottom";
    private static final String _ALIGNMENT_CENTER = "center";
    private static final String _ALIGNMENT_DEFAULT_VALUE = "center";
    private static final String _POSITION_LEFT = "start";
    private static final String _POSITION_RIGHT = "end";
    private static final String _POSITION_TOP = "top";
    private static final String _POSITION_BOTTOM = "bottom";
    private static final String _POSITION_DEFAULT_VALUE = "start";
    private static Map<String, String> positionMap = new HashMap<String, String>(4);
    private static final String _SEPARATOR_SIZE = "8";
    private static final String _LABEL_CONTROL_SEPARATOR_SIZE = "12";
    private static final TrinidadLogger _LOG;

    ShowOneListRendererBase() {
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        _LOG.entering("ShowOneListRendererBase", "encodeBegin");
        List children = component.getChildren();
        int numChildren = children.size();
        UIXShowDetail disclosedChild = null;
        UIXShowDetail renderableChild = null;
        for (int indxChild = 0; indxChild < numChildren; ++indxChild) {
            Object disabled;
            UIXShowDetail detailChild;
            UIComponent child = (UIComponent)children.get(indxChild);
            if (!(child instanceof UIXShowDetail) || !(detailChild = (UIXShowDetail)children.get(indxChild)).isRendered() || Boolean.TRUE.equals(disabled = detailChild.getAttributes().get(UIConstants.DISABLED_ATTR.getAttributeName()))) continue;
            if (renderableChild == null) {
                renderableChild = detailChild;
            }
            if (!detailChild.isDisclosed()) continue;
            disclosedChild = detailChild;
        }
        if (disclosedChild == null && renderableChild != null && !renderableChild.isDisclosedTransient()) {
            renderableChild.setDisclosed(true);
        }
        _LOG.exiting("ShowOneListRendererBase", "encodeBegin");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        String shortDesc;
        String alignment;
        String position;
        this.writeAdditionalJS(context, component);
        if (XhtmlRenderer.supportsNarrowScreen(RenderingContext.getCurrentInstance())) {
            position = "top";
            alignment = "start";
        } else {
            alignment = ShowOneListRendererBase._getAlignment(component);
            if (alignment == null) {
                alignment = "center";
            }
            if (!positionMap.containsKey(position = ShowOneListRendererBase._getPosition(component))) {
                position = "start";
            }
        }
        _LOG.finest("ShowOneListRendererBase.encodeChildren: alignment: {0}, position: {1} ", new Object[]{alignment, position});
        ResponseWriter out = context.getResponseWriter();
        String disclosedItemId = ShowOneListRendererBase._getDisclosedItemId(context, component);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        if (!isDesktop) {
            out.startElement("div", component);
            out.writeAttribute("id", (Object)component.getClientId(context), null);
        }
        out.startElement("table", component);
        if (isDesktop) {
            out.writeAttribute("id", (Object)component.getClientId(context), null);
        }
        if ((shortDesc = (String)component.getAttributes().get("shortDesc")) != null) {
            out.writeAttribute("summary", (Object)shortDesc, null);
        } else {
            out.writeAttribute("summary", (Object)"", null);
        }
        out.writeAttribute("border", (Object)"0", null);
        out.writeAttribute("cellspacing", (Object)"0", null);
        out.writeAttribute("cellpadding", (Object)"0", null);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styleClass);
        }
        UIXRenderingContext rCtx = ShowOneListRendererBase.getRenderingContext(context, component);
        ShowOneUtils.renderGenericAttributes(rCtx, component, out);
        out.startElement("tr", component);
        if (position.equals("start")) {
            out.startElement("td", component);
            this._renderAlignmentTopBottom(out, alignment);
            this.renderListDisplay(context, component, disclosedItemId);
            out.endElement("td");
            this.renderSpacerTD(out, component, _SEPARATOR_SIZE);
            out.startElement("td", component);
            out.writeAttribute("align", (Object)"left", null);
            ShowOneListRendererBase._findAndEncodeChild(context, component, disclosedItemId);
            out.endElement("td");
        }
        if (position.equals("end")) {
            out.startElement("td", component);
            out.writeAttribute("align", (Object)"right", null);
            ShowOneListRendererBase._findAndEncodeChild(context, component, disclosedItemId);
            out.endElement("td");
            this.renderSpacerTD(out, component, _SEPARATOR_SIZE);
            out.startElement("td", component);
            this._renderAlignmentTopBottom(out, alignment);
            out.writeAttribute("align", (Object)"left", null);
            this.renderListDisplay(context, component, disclosedItemId);
            out.endElement("td");
        }
        if (position.equals("bottom")) {
            out.startElement("td", component);
            ShowOneListRendererBase._findAndEncodeChild(context, component, disclosedItemId);
            out.endElement("td");
            out.endElement("tr");
            this._renderSpacerTR(out, component);
            out.startElement("tr", component);
            out.startElement("td", component);
            this._renderAlignmentLeftRight(out, alignment);
            this.renderListDisplay(context, component, disclosedItemId);
            out.endElement("td");
        }
        if (position.equals("top")) {
            out.startElement("td", component);
            this._renderAlignmentLeftRight(out, alignment);
            this.renderListDisplay(context, component, disclosedItemId);
            out.endElement("td");
            out.endElement("tr");
            this._renderSpacerTR(out, component);
            out.startElement("tr", component);
            out.startElement("td", component);
            ShowOneListRendererBase._findAndEncodeChild(context, component, disclosedItemId);
            out.endElement("td");
        }
        out.endElement("tr");
        out.endElement("table");
        if (!isDesktop) {
            out.endElement("div");
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    protected void writeAdditionalJS(FacesContext context, UIComponent component) throws IOException {
    }

    protected boolean elementSupportsPartial(UIXRenderingContext context, String id) {
        return id != null && XhtmlLafRenderer.supportsPartialRendering(context);
    }

    protected void renderSelectLabel(UIXRenderingContext rCtx, UIComponent component, ResponseWriter out, String compId) throws IOException {
        out.startElement("td", component);
        out.writeAttribute("align", (Object)"left", null);
        out.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        out.startElement("span", component);
        XhtmlLafRenderer.renderStyleClassAttribute(rCtx, this.getLabelClassName());
        out.startElement("label", component);
        String controlId = this.getHTMLControlID(compId);
        out.writeAttribute("for", (Object)controlId, null);
        Character accessChar = (Character)component.getAttributes().get("accessKey");
        if (accessChar != null) {
            out.writeAttribute("accessKey", (Object)accessChar.toString(), null);
        }
        this.writeLabel(out, component, (String)component.getAttributes().get("label"));
        out.endElement("label");
        out.endElement("span");
        out.endElement("td");
    }

    protected void writeLabel(ResponseWriter out, UIComponent component, String label) throws IOException {
        Character accessChar = (Character)component.getAttributes().get("accessKey");
        if (label != null) {
            if (accessChar == null) {
                out.writeText((Object)label, null);
            } else {
                int accessKeyIndex = label.indexOf(accessChar.charValue());
                if (accessKeyIndex < 0) {
                    out.writeText((Object)label, null);
                } else {
                    String strBefAccessKey = label.substring(0, accessKeyIndex);
                    String strAfterAccessKey = label.substring(accessKeyIndex + 1, label.length());
                    out.writeText((Object)strBefAccessKey, null);
                    out.startElement("span", null);
                    XhtmlRenderer.renderStyleClass((FacesContext)FacesContext.getCurrentInstance(), (RenderingContext)RenderingContext.getCurrentInstance(), (String)"AFAccessKeyStyle");
                    out.writeText((Object)accessChar.toString(), null);
                    out.endElement("span");
                    out.writeText((Object)strAfterAccessKey, null);
                }
            }
        }
    }

    protected void renderSpacerTD(ResponseWriter out, UIComponent component, String separatorSize) throws IOException {
        out.startElement("td", component);
        out.writeAttribute("width", (Object)separatorSize, null);
        out.endElement("td");
    }

    protected String getHTMLControlID(String compId) {
        return compId;
    }

    protected String getFieldTextClass() {
        return "AFFieldText";
    }

    protected String getLabelControlSeparatorSize() {
        return _LABEL_CONTROL_SEPARATOR_SIZE;
    }

    protected abstract void renderListDisplay(FacesContext var1, UIComponent var2, String var3) throws IOException;

    private String getLabelClassName() {
        return "AFLabelText";
    }

    private static String _getDisclosedItemId(FacesContext context, UIComponent component) throws IOException {
        String returnId = null;
        ListIterator iter = component.getChildren().listIterator();
        if (iter == null) {
            return null;
        }
        while (iter.hasNext()) {
            UIXShowDetail detailChild;
            UIComponent child = (UIComponent)iter.next();
            if (!child.isRendered() || !(child instanceof UIXShowDetail) || !(detailChild = (UIXShowDetail)child).isDisclosed()) continue;
            returnId = detailChild.getClientId(context);
            break;
        }
        return returnId;
    }

    private static String _getPosition(UIComponent component) {
        return (String)component.getAttributes().get("position");
    }

    private static String _getAlignment(UIComponent component) {
        return (String)component.getAttributes().get("alignment");
    }

    private static void _findAndEncodeChild(FacesContext context, UIComponent parent, String disclosedChildId) throws IOException {
        UIComponent disclosedChild = ShowOneListRendererBase._findChild(context, parent, disclosedChildId);
        if (disclosedChild == null) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", disclosedChild);
        if (disclosedChild.isRendered() && disclosedChild.getChildCount() > 0) {
            for (UIComponent child : disclosedChild.getChildren()) {
                RenderUtils.encodeRecursive((FacesContext)context, (UIComponent)child);
            }
        }
        out.endElement("span");
    }

    private static UIComponent _findChild(FacesContext context, UIComponent component, String disclosedChildId) {
        if (disclosedChildId == null) {
            return null;
        }
        for (UIComponent child : component.getChildren()) {
            String childId = child.getClientId(context);
            if (!disclosedChildId.equals(childId)) continue;
            return child;
        }
        return null;
    }

    private void _renderSpacerTR(ResponseWriter out, UIComponent component) throws IOException {
        out.startElement("tr", component);
        out.startElement("td", component);
        out.writeAttribute("height", (Object)_SEPARATOR_SIZE, null);
        out.endElement("td");
        out.endElement("tr");
    }

    private void _renderAlignmentTopBottom(ResponseWriter out, String alignment) throws IOException {
        if (alignment.equals("top")) {
            out.writeAttribute("valign", (Object)"top", null);
        } else if (alignment.equals("bottom")) {
            out.writeAttribute("valign", (Object)"bottom", null);
        } else {
            out.writeAttribute("valign", (Object)"middle", null);
        }
    }

    private void _renderAlignmentLeftRight(ResponseWriter out, String alignment) throws IOException {
        if (alignment.equals("start")) {
            out.writeAttribute("align", (Object)"left", null);
        } else if (alignment.equals("end")) {
            out.writeAttribute("align", (Object)"right", null);
        } else {
            out.writeAttribute("align", (Object)"center", null);
        }
    }

    static {
        positionMap.put("start", "start");
        positionMap.put("end", "end");
        positionMap.put("top", "top");
        positionMap.put("bottom", "bottom");
        _LOG = TrinidadLogger.createTrinidadLogger(ShowOneListRendererBase.class);
    }
}

