/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.validation.Validation;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.FacesMessageWrapper;
import org.apache.myfaces.trinidad.component.UIXValue;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ValueUpdatedEvent;
import org.apache.myfaces.trinidad.event.ValueUpdatedListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.LabeledFacesMessage;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.util.Reportable;

public abstract class UIXEditableValue
extends UIXValue
implements EditableValueHolder {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXValue.TYPE);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class, Boolean.FALSE);
    public static final PropertyKey VALID_KEY = TYPE.registerKey("valid", Boolean.class, Boolean.TRUE);
    public static final PropertyKey REQUIRED_KEY = TYPE.registerKey("required", Boolean.class, Boolean.FALSE);
    public static final PropertyKey LOCAL_VALUE_SET_KEY = TYPE.registerKey("localValueSet", Boolean.class, 1);
    public static final PropertyKey SUBMITTED_VALUE_KEY = TYPE.registerKey("submittedValue", 1);
    public static final PropertyKey VALIDATOR_KEY = TYPE.registerKey("validator", MethodBinding.class, 9);
    public static final PropertyKey VALUE_CHANGE_LISTENER_KEY = TYPE.registerKey("valueChangeListener", MethodBinding.class, 9);
    public static final PropertyKey REQUIRED_MESSAGE_DETAIL_KEY = TYPE.registerKey("requiredMessageDetail", String.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.EditableValue";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.EditableValue";
    public static final PropertyKey VALIDATORS_KEY = TYPE.registerKey("validators", Validator[].class, 4);
    public static final String REQUIRED_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXEditableValue.REQUIRED";
    public static final String CONVERSION_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXEditableValue.CONVERSION";
    public static final String TRINIDAD_BEAN_VALIDATION_AVAILABLE = "org.apache.myfaces.trinidad.UIXEditableValue.BEAN_VALIDATION_AVAILABLE";
    public static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "org.apache.myfaces.trinidad.UIXEditableValue.VALIDATE_EMPTY_FIELDS";
    private static final String JSF_SPEC_EMPTY_VALUES_AS_NULL_PARAM_NAME = "javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL";
    public static final String TRINIDAD_EMPTY_VALUES_AS_NULL_PARAM_NAME = "org.apache.myfaces.trinidad.UIXEditableValue.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXEditableValue.class);

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().addEntry(VALIDATORS_KEY, validator);
    }

    public Validator[] getValidators() {
        return (Validator[])this.getFacesBean().getEntries(VALIDATORS_KEY, Validator.class);
    }

    public void removeValidator(Validator validator) {
        this.getFacesBean().removeEntry(VALIDATORS_KEY, validator);
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        if (UIXEditableValue.shouldInterpretEmptyStringSubmittedValuesAsNull(context) && this._isEmptyString(submittedValue)) {
            submittedValue = null;
        }
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this._addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.setValue(newValue);
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ValueChangeEvent) {
            this.broadcastToMethodBinding(event, this.getValueChangeListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDecodes(FacesContext context) {
        if (!this.isValid()) {
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        this.setValid(true);
        RequestContext requestContext = RequestContext.getCurrentInstance();
        requestContext.pushCurrentComponent(context, this);
        this.pushComponentToEL(context, this);
        try {
            if (!this.isRendered()) {
                return;
            }
            super.processDecodes(context);
            if (this.isImmediate()) {
                this._executeValidate(context);
            }
        }
        finally {
            this.popComponentFromEL(context);
            requestContext.popCurrentComponent(context, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdates(FacesContext context) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        requestContext.pushCurrentComponent(context, this);
        this.pushComponentToEL(context, this);
        try {
            if (!this.isRendered()) {
                return;
            }
            super.processUpdates(context);
            this.updateModel(context);
        }
        finally {
            this.popComponentFromEL(context);
            requestContext.popCurrentComponent(context, this);
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processValidators(FacesContext context) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        requestContext.pushCurrentComponent(context, this);
        this.pushComponentToEL(context, this);
        try {
            if (!this.isRendered()) {
                return;
            }
            super.processValidators(context);
            if (!this.isImmediate()) {
                this._executeValidate(context);
            }
        }
        finally {
            this.popComponentFromEL(context);
            requestContext.popCurrentComponent(context, this);
        }
    }

    public void addValueUpdatedListener(ValueUpdatedListener listener) {
        super.addFacesListener(listener);
    }

    public void removeValueUpdatedListener(ValueUpdatedListener listener) {
        super.removeFacesListener(listener);
    }

    public void updateModel(FacesContext context) {
        block7: {
            if (context == null) {
                throw new NullPointerException();
            }
            if (!this.isValid() || !this.isLocalValueSet()) {
                return;
            }
            ValueExpression expression = this.getFacesBean().getValueExpression(VALUE_KEY);
            if (expression == null) {
                return;
            }
            try {
                Object localValue = this.getLocalValue();
                expression.setValue(context.getELContext(), localValue);
                this.setValue(null);
                this.setLocalValueSet(false);
                new ValueUpdatedEvent(this).queue();
                if (_LOG.isFiner()) {
                    _LOG.finer("Wrote value {0} to model {1} in component {2}", new Object[]{localValue, expression.getExpressionString(), this});
                }
            }
            catch (RuntimeException e) {
                boolean shouldReportMessage;
                if (_LOG.isFine()) {
                    _LOG.fine("Error updating expression ({0})", expression.getExpressionString());
                    _LOG.fine(e);
                }
                this.setValid(false);
                boolean bl = shouldReportMessage = e instanceof Reportable ? ((Reportable)((Object)e)).shouldReportMessage() : true;
                if (!shouldReportMessage) break block7;
                FacesMessage message = MessageFactory.getMessage(e);
                message = this._wrapMessage(message);
                context.addMessage(this.getClientId(context), message);
            }
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (!this.isValid()) {
            return;
        }
        boolean isEmpty = this.isEmpty(newValue);
        if (isEmpty && this.isRequired()) {
            FacesMessage message = this._getRequiredFacesMessage(context);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (!isEmpty || UIXEditableValue.shouldValidateEmptyFields(context)) {
            Iterator<? extends Object> validators = this.getFacesBean().entries(VALIDATORS_KEY);
            while (validators.hasNext()) {
                Validator validator = (Validator)validators.next();
                try {
                    validator.validate(context, (UIComponent)this, newValue);
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    FacesMessage message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    message = this._wrapMessage(message);
                    context.addMessage(this.getClientId(context), message);
                }
            }
            MethodBinding validatorBinding = this.getValidator();
            if (validatorBinding != null) {
                try {
                    validatorBinding.invoke(context, new Object[]{context, this, newValue});
                }
                catch (EvaluationException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof ValidatorException) {
                        ValidatorException ve = (ValidatorException)cause;
                        this.setValid(false);
                        FacesMessage message = ve.getFacesMessage();
                        if (message != null) {
                            message.setSeverity(FacesMessage.SEVERITY_ERROR);
                            message = this._wrapMessage(message);
                            context.addMessage(this.getClientId(context), message);
                        }
                    }
                    throw ee;
                }
            }
        }
    }

    protected String getRequiredMessageKey() {
        return REQUIRED_MESSAGE_ID;
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        Object newValue = null;
        if (_LOG.isFine()) {
            _LOG.fine("Converting from " + submittedValue + "(" + submittedValue.getClass() + ")");
        }
        if (renderer != null) {
            newValue = renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
            if (_LOG.isFine()) {
                _LOG.fine("Renderer " + renderer + " returned value " + newValue + "(" + (newValue != null ? newValue.getClass().getName() : "null") + ")");
            }
        } else {
            Converter converter;
            newValue = submittedValue instanceof String ? ((converter = this._getConverterWithType(context)) != null ? converter.getAsObject(context, (UIComponent)this, (String)submittedValue) : submittedValue) : submittedValue;
        }
        return newValue;
    }

    protected boolean compareValues(Object previous, Object value) {
        boolean isNotEqual;
        if (previous == null || "".equals(previous)) {
            return value != null && !"".equals(value);
        }
        boolean bl = isNotEqual = !previous.equals(value);
        if (isNotEqual && value instanceof Comparable && previous.getClass().equals(value.getClass())) {
            int compareTo = ((Comparable)previous).compareTo(value);
            isNotEqual = compareTo != 0;
        }
        return isNotEqual;
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String && ((String)value).trim().length() == 0;
    }

    private boolean _isEmptyString(Object value) {
        return value instanceof String && ((String)value).length() == 0;
    }

    public static boolean shouldInterpretEmptyStringSubmittedValuesAsNull(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Boolean interpretEmptyStringAsNull = (Boolean)ec.getApplicationMap().get(TRINIDAD_EMPTY_VALUES_AS_NULL_PARAM_NAME);
        if (interpretEmptyStringAsNull == null) {
            String param = ec.getInitParameter(JSF_SPEC_EMPTY_VALUES_AS_NULL_PARAM_NAME);
            interpretEmptyStringAsNull = "true".equalsIgnoreCase(param);
            ec.getApplicationMap().put(TRINIDAD_EMPTY_VALUES_AS_NULL_PARAM_NAME, interpretEmptyStringAsNull);
        }
        return interpretEmptyStringAsNull;
    }

    public static boolean shouldValidateEmptyFields(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Boolean shouldValidateEmptyFields = (Boolean)ec.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
        if (shouldValidateEmptyFields == null) {
            String param = ec.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
            if (param == null) {
                Object value = ec.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
                if (value instanceof Boolean) {
                    shouldValidateEmptyFields = (Boolean)value;
                    return shouldValidateEmptyFields;
                }
                param = (String)value;
            }
            param = param == null ? "auto" : param.toLowerCase();
            shouldValidateEmptyFields = param.equals("auto") && UIXEditableValue._isBeanValidationAvailable(context) ? Boolean.TRUE : Boolean.valueOf("true".equalsIgnoreCase(param));
            ec.getApplicationMap().put(VALIDATE_EMPTY_FIELDS_PARAM_NAME, shouldValidateEmptyFields);
        }
        return shouldValidateEmptyFields;
    }

    private static boolean _isBeanValidationAvailable(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Boolean couldLoadBeanValidationAPI = (Boolean)ec.getApplicationMap().get(TRINIDAD_BEAN_VALIDATION_AVAILABLE);
        if (couldLoadBeanValidationAPI == null) {
            try {
                couldLoadBeanValidationAPI = ClassLoaderUtils.loadClass("javax.validation.Validation") != null;
                if (couldLoadBeanValidationAPI.booleanValue()) {
                    try {
                        Validation.buildDefaultValidatorFactory().getValidator();
                    }
                    catch (Exception validationException) {
                        _LOG.warning("VALIDATOR_FACTORY_UNAVAILABLE", validationException.getMessage());
                        couldLoadBeanValidationAPI = Boolean.FALSE;
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                _LOG.warning("A Bean Validation provider is not present, therefore bean validation is disabled");
                couldLoadBeanValidationAPI = Boolean.FALSE;
            }
            ec.getApplicationMap().put(TRINIDAD_BEAN_VALIDATION_AVAILABLE, couldLoadBeanValidationAPI);
        }
        return couldLoadBeanValidationAPI;
    }

    private void _executeValidate(FacesContext context) {
        Application application = context.getApplication();
        application.publishEvent(context, PreValidateEvent.class, UIComponent.class, (Object)this);
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            application.publishEvent(context, PostValidateEvent.class, UIComponent.class, (Object)this);
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object _getLabel() {
        Object o = this.getAttributes().get("label");
        if (o == null) {
            o = this.getValueExpression("label");
        }
        return o;
    }

    private Object _getRequiredMessageDetail() {
        Object o = this.getAttributes().get("requiredMessageDetail");
        if (o == null) {
            o = this.getValueExpression("requiredMessageDetail");
        }
        return o;
    }

    private FacesMessage _getRequiredFacesMessage(FacesContext context) {
        Object customMessageDetail = this._getRequiredMessageDetail();
        Object label = this._getLabel();
        FacesMessage message = MessageFactory.getMessage(context, this.getRequiredMessageKey(), customMessageDetail, new Object[]{label}, label);
        return message;
    }

    private void _addConversionErrorMessage(FacesContext context, ConverterException ce, Object value) {
        FacesMessage message = ce.getFacesMessage();
        if (message == null) {
            Object label = this._getLabel();
            message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID, new Object[]{label, value, ce.getMessage()}, label);
        } else {
            message = this._wrapMessage(message);
        }
        context.addMessage(this.getClientId(context), message);
    }

    private Converter _getConverterWithType(FacesContext context) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(context.getELContext());
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private FacesMessage _wrapMessage(FacesMessage original) {
        if (original instanceof LabeledFacesMessage) {
            return original;
        }
        return new FacesMessageWrapper(original, this._getLabel());
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY), false);
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isValid() {
        return ComponentUtils.resolveBoolean(this.getProperty(VALID_KEY), true);
    }

    public final void setValid(boolean valid) {
        this.setProperty(VALID_KEY, valid ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isRequired() {
        return ComponentUtils.resolveBoolean(this.getProperty(REQUIRED_KEY), false);
    }

    public final void setRequired(boolean required) {
        this.setProperty(REQUIRED_KEY, required ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isLocalValueSet() {
        return ComponentUtils.resolveBoolean(this.getProperty(LOCAL_VALUE_SET_KEY));
    }

    public final void setLocalValueSet(boolean localValueSet) {
        this.setProperty(LOCAL_VALUE_SET_KEY, localValueSet ? Boolean.TRUE : Boolean.FALSE);
    }

    public final Object getSubmittedValue() {
        return this.getProperty(SUBMITTED_VALUE_KEY);
    }

    public final void setSubmittedValue(Object submittedValue) {
        this.setProperty(SUBMITTED_VALUE_KEY, submittedValue);
    }

    public final MethodBinding getValidator() {
        return (MethodBinding)this.getProperty(VALIDATOR_KEY);
    }

    public final void setValidator(MethodBinding validator) {
        this.setProperty(VALIDATOR_KEY, validator);
    }

    public final MethodBinding getValueChangeListener() {
        return (MethodBinding)this.getProperty(VALUE_CHANGE_LISTENER_KEY);
    }

    public final void setValueChangeListener(MethodBinding valueChangeListener) {
        this.setProperty(VALUE_CHANGE_LISTENER_KEY, valueChangeListener);
    }

    public final String getRequiredMessageDetail() {
        return ComponentUtils.resolveString(this.getProperty(REQUIRED_MESSAGE_DETAIL_KEY));
    }

    public final void setRequiredMessageDetail(String requiredMessageDetail) {
        this.setProperty(REQUIRED_MESSAGE_DETAIL_KEY, requiredMessageDetail);
    }

    public final void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.EditableValue";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXEditableValue(String rendererType) {
        super(rendererType);
    }

    protected UIXEditableValue() {
        this(null);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.EditableValue", "org.apache.myfaces.trinidad.EditableValue");
    }
}

