/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.xmlHttp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpConfigurator;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlOutput;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;

final class XmlHttpServletResponse
extends HttpServletResponseWrapper {
    private String _contentType = "text/xml;charset=utf-8";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XmlHttpServletResponse.class);

    XmlHttpServletResponse(ExternalContext ec) {
        super((HttpServletResponse)ec.getResponse());
        this.setContentType(this._contentType);
    }

    public void sendRedirect(String url) throws IOException {
        XmlHttpConfigurator.sendXmlRedirect(this.getWriter(), url);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream base = super.getOutputStream();
        return new XmlOutput((OutputStream)base).getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter base = super.getWriter();
        return new XmlOutput(base).getWriter();
    }

    public void setContentType(String type) {
        _LOG.finer("ignoring setContentType:{0}", (Object)type);
        super.setContentType(this._contentType);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendError(int sc, String string) throws IOException {
        PrintWriter writer = this.getWriter();
        XmlResponseWriter rw = new XmlResponseWriter(writer, "UTF-8");
        rw.startDocument();
        rw.startElement("error", null);
        rw.writeAttribute("status", sc, null);
        rw.writeText(string, null);
        rw.endElement("error");
        rw.endDocument();
        rw.close();
    }
}

